/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.appcompat.graphics.drawable.DrawableWrapperCompat;
import androidx.core.graphics.drawable.DrawableCompat;

@SuppressLint(value={"RestrictedApi"})
class AutoMirrorDrawable
extends DrawableWrapperCompat {
    public AutoMirrorDrawable(@NonNull Drawable drawable) {
        super(drawable);
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.needMirroring()) {
            float centerX = this.getBounds().exactCenterX();
            canvas.scale(-1.0f, 1.0f, centerX, 0.0f);
            super.draw(canvas);
            canvas.scale(-1.0f, 1.0f, centerX, 0.0f);
        } else {
            super.draw(canvas);
        }
    }

    public boolean onLayoutDirectionChanged(int layoutDirection) {
        super.onLayoutDirectionChanged(layoutDirection);
        return true;
    }

    public boolean isAutoMirrored() {
        return true;
    }

    private boolean needMirroring() {
        return DrawableCompat.getLayoutDirection((Drawable)this) == 1;
    }

    public boolean getPadding(@NonNull Rect padding) {
        boolean hasPadding = super.getPadding(padding);
        if (this.needMirroring()) {
            int paddingEnd;
            int paddingStart = padding.left;
            padding.left = paddingEnd = padding.right;
            padding.right = paddingStart;
        }
        return hasPadding;
    }
}

