/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.eventbusactivityscope;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.greenrobot.eventbus.EventBus;

public class EventBusActivityScope {
    private static final String TAG = EventBusActivityScope.class.getSimpleName();
    private static AtomicBoolean sInitialized = new AtomicBoolean(false);
    private static volatile EventBus sInvalidEventBus;
    private static final Map<Activity, LazyEventBusInstance> sActivityEventBusScopePool;

    static void init(Context context) {
        if (sInitialized.getAndSet(true)) {
            return;
        }
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
            private Handler mainHandler = new Handler(Looper.getMainLooper());

            public void onActivityCreated(Activity activity, Bundle bundle) {
                sActivityEventBusScopePool.put(activity, new LazyEventBusInstance());
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(final Activity activity) {
                if (!sActivityEventBusScopePool.containsKey(activity)) {
                    return;
                }
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        sActivityEventBusScopePool.remove(activity);
                    }
                });
            }
        });
    }

    public static EventBus getDefault(Activity activity) {
        if (activity == null) {
            Log.e((String)TAG, (String)"Can't find the Activity, the Activity is null!");
            return EventBusActivityScope.invalidEventBus();
        }
        LazyEventBusInstance lazyEventBusInstance = sActivityEventBusScopePool.get(activity);
        if (lazyEventBusInstance == null) {
            Log.e((String)TAG, (String)"Can't find the Activity, it has been removed!");
            return EventBusActivityScope.invalidEventBus();
        }
        return lazyEventBusInstance.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EventBus invalidEventBus() {
        if (sInvalidEventBus != null) return sInvalidEventBus;
        Class<EventBusActivityScope> clazz = EventBusActivityScope.class;
        synchronized (EventBusActivityScope.class) {
            if (sInvalidEventBus != null) return sInvalidEventBus;
            sInvalidEventBus = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInvalidEventBus;
        }
    }

    static {
        sActivityEventBusScopePool = new ConcurrentHashMap<Activity, LazyEventBusInstance>();
    }

    static class LazyEventBusInstance {
        private volatile EventBus eventBus;

        LazyEventBusInstance() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EventBus getInstance() {
            if (this.eventBus == null) {
                LazyEventBusInstance lazyEventBusInstance = this;
                synchronized (lazyEventBusInstance) {
                    if (this.eventBus == null) {
                        this.eventBus = new EventBus();
                    }
                }
            }
            return this.eventBus;
        }
    }
}

