/*
 * Decompiled with CFR 0.152.
 */
package me.ydcool.lib.qrmodule.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.google.zxing.ResultPoint;
import java.util.Collection;
import java.util.HashSet;
import me.ydcool.lib.qrmodule.R;
import me.ydcool.lib.qrmodule.camera.CameraManager;

public final class ViewfinderView
extends View {
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private static final long ANIMATION_DELAY = 100L;
    private static final int OPAQUE = 255;
    private final Paint paint = new Paint();
    private final int maskColor;
    private final int resultColor;
    private final int frameColor;
    private final int laserColor;
    private final int resultPointColor;
    private Bitmap resultBitmap;
    private int scannerAlpha;
    private String hintString;
    private Collection<ResultPoint> possibleResultPoints;
    private Collection<ResultPoint> lastPossibleResultPoints;

    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.paint.setTextSize(context.getResources().getDisplayMetrics().scaledDensity * 15.0f);
        this.paint.setAntiAlias(true);
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.maskColor = this.getContext().getResources().getColor(R.color.viewfinder_mask);
        this.resultColor = this.getContext().getResources().getColor(R.color.result_view);
        this.frameColor = this.getContext().getResources().getColor(R.color.viewfinder_frame);
        this.laserColor = this.getContext().getResources().getColor(R.color.viewfinder_laser);
        this.resultPointColor = this.getContext().getResources().getColor(R.color.possible_result_points);
        this.hintString = context.getString(R.string.scan_hint);
        this.scannerAlpha = 0;
        this.possibleResultPoints = new HashSet<ResultPoint>(5);
    }

    public void onDraw(Canvas canvas) {
        Rect frame = CameraManager.get().getFramingRect();
        if (frame == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(255);
            canvas.drawBitmap(this.resultBitmap, (float)frame.left, (float)frame.top, this.paint);
        } else {
            this.paint.setColor(this.frameColor);
            canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.right + 1), (float)(frame.top + 2), this.paint);
            canvas.drawRect((float)frame.left, (float)(frame.top + 2), (float)(frame.left + 2), (float)(frame.bottom - 1), this.paint);
            canvas.drawRect((float)(frame.right - 1), (float)frame.top, (float)(frame.right + 1), (float)(frame.bottom - 1), this.paint);
            canvas.drawRect((float)frame.left, (float)(frame.bottom - 1), (float)(frame.right + 1), (float)(frame.bottom + 1), this.paint);
            this.paint.setColor(this.laserColor);
            this.paint.setAlpha(SCANNER_ALPHA[this.scannerAlpha]);
            this.scannerAlpha = (this.scannerAlpha + 1) % SCANNER_ALPHA.length;
            int middle = frame.height() / 2 + frame.top;
            canvas.drawRect((float)(frame.left + 2), (float)(middle - 1), (float)(frame.right - 1), (float)(middle + 2), this.paint);
            this.paint.setColor(-1);
            canvas.drawText(this.hintString, (float)frame.centerX(), (float)(frame.bottom + frame.height() / 4), this.paint);
            Collection<ResultPoint> currentPossible = this.possibleResultPoints;
            Collection<ResultPoint> currentLast = this.lastPossibleResultPoints;
            if (currentPossible.isEmpty()) {
                this.lastPossibleResultPoints = null;
            } else {
                this.possibleResultPoints = new HashSet<ResultPoint>(5);
                this.lastPossibleResultPoints = currentPossible;
                this.paint.setAlpha(255);
                this.paint.setColor(this.resultPointColor);
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 6.0f, this.paint);
                }
            }
            if (currentLast != null) {
                this.paint.setAlpha(127);
                this.paint.setColor(this.resultPointColor);
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 3.0f, this.paint);
                }
            }
            this.postInvalidateDelayed(100L, frame.left, frame.top, frame.right, frame.bottom);
        }
    }

    public void drawViewfinder() {
        this.resultBitmap = null;
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap barcode) {
        this.resultBitmap = barcode;
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
        this.possibleResultPoints.add(point);
    }
}

