/*
 * Decompiled with CFR 0.152.
 */
package me.ydcool.lib.qrmodule.encoding;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.Hashtable;

public final class QrGenerator {
    private int mQrSize;
    private int mColor;
    private int mMargin;
    private int mBgColor;
    private int mOverlaySize;
    private int mOverlayAlpha;
    private String mContent;
    private String mFootNote;
    private Bitmap mOverlay;
    private ErrorCorrectionLevel mEcl;
    private PorterDuff.Mode mXfermode;

    private QrGenerator(Builder builder) {
        this.mMargin = builder.mMargin;
        this.mQrSize = builder.mQrSize;
        this.mColor = builder.mColor;
        this.mBgColor = builder.mBgColor;
        this.mContent = builder.mContent;
        this.mEcl = builder.mEcl;
        this.mOverlay = builder.mOverlay;
        this.mOverlaySize = builder.mOverlaySize;
        this.mOverlayAlpha = builder.mOverlayAlpha;
        this.mXfermode = builder.mXFerMode;
        this.mFootNote = builder.mFootNote;
    }

    private Bitmap createQRCode() throws WriterException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, this.mEcl);
        hints.put(EncodeHintType.MARGIN, this.mMargin);
        BitMatrix matrix = new MultiFormatWriter().encode(this.mContent, BarcodeFormat.QR_CODE, this.mQrSize, this.mQrSize, hints);
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pixels[y * width + x] = matrix.get(x, y) ? this.mColor : this.mBgColor;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        if (this.mOverlay != null && this.mOverlaySize > 0) {
            Bitmap w = Bitmap.createBitmap((Bitmap)this.mOverlay);
            Bitmap o = w.copy(Bitmap.Config.ARGB_8888, true);
            w.recycle();
            int overlayW = o.getWidth();
            int overlayH = o.getHeight();
            int scaledH = this.mOverlaySize * overlayW / overlayH;
            int offsetX = (this.mQrSize - this.mOverlaySize) / 2;
            int offsetY = (this.mQrSize - scaledH) / 2;
            Paint p = new Paint(2);
            p.setAlpha(this.mOverlayAlpha);
            p.setXfermode((Xfermode)new PorterDuffXfermode(this.mXfermode));
            Canvas canvas = new Canvas(bitmap);
            Rect src = new Rect(0, 0, overlayW, overlayH);
            Rect dst = new Rect(0, 0, this.mOverlaySize, scaledH);
            canvas.translate((float)offsetX, (float)offsetY);
            canvas.drawBitmap(o, src, dst, p);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mFootNote)) {
            Bitmap result = Bitmap.createBitmap((int)this.mQrSize, (int)(this.mQrSize * 3 / 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            TextPaint textPaint = new TextPaint();
            textPaint.setColor(this.mColor);
            textPaint.setTextSize(20.0f);
            textPaint.setAntiAlias(true);
            StaticLayout mTextLayout = new StaticLayout((CharSequence)this.mFootNote, textPaint, this.mQrSize, Layout.Alignment.ALIGN_CENTER, 1.4f, 0.2f, false);
            Canvas canvas = new Canvas(result);
            canvas.drawColor(this.mBgColor);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            canvas.translate(0.0f, (float)(this.mQrSize * 9 / 8));
            mTextLayout.draw(canvas);
            return result;
        }
        return bitmap;
    }

    public static class Builder {
        private int mColor = -16777216;
        private int mBgColor = -1;
        private int mMargin = 2;
        private int mQrSize;
        private int mOverlaySize;
        private int mOverlayAlpha = 255;
        private String mContent;
        private String mFootNote;
        private Bitmap mOverlay;
        private ErrorCorrectionLevel mEcl = ErrorCorrectionLevel.L;
        private PorterDuff.Mode mXFerMode = PorterDuff.Mode.SRC_OVER;

        public Bitmap encode() throws WriterException {
            return new QrGenerator(this).createQRCode();
        }

        public Builder content(String content) {
            this.mContent = content;
            return this;
        }

        public Builder qrSize(int widthAndHeight) {
            this.mQrSize = widthAndHeight;
            return this;
        }

        public Builder margin(int margin) {
            this.mMargin = margin;
            return this;
        }

        public Builder color(int color2) {
            this.mColor = color2;
            return this;
        }

        public Builder color(Context context, int color2) {
            return this.color(context.getResources().getColor(color2));
        }

        public Builder bgColor(int bgColor) {
            this.mBgColor = bgColor;
            return this;
        }

        public Builder ecc(ErrorCorrectionLevel ecl) {
            this.mEcl = ecl;
            return this;
        }

        public Builder overlay(Bitmap overlay) {
            this.mOverlay = overlay;
            return this;
        }

        public Builder overlay(Context context, int overlay) {
            return this.overlay(BitmapFactory.decodeResource((Resources)context.getResources(), (int)overlay));
        }

        public Builder overlaySize(int overlaySize) {
            this.mOverlaySize = overlaySize;
            return this;
        }

        public Builder overlayAlpha(int alpha) {
            this.mOverlayAlpha = alpha;
            return this;
        }

        public Builder overlayXfermode(PorterDuff.Mode xfermode) {
            this.mXFerMode = xfermode;
            return this;
        }

        public Builder footNote(String note) {
            this.mFootNote = note;
            return this;
        }
    }
}

