/*
 * Decompiled with CFR 0.152.
 */
package me.ydcool.lib.qrmodule.decoding;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import java.util.Vector;
import me.ydcool.lib.qrmodule.activity.QrScannerActivity;
import me.ydcool.lib.qrmodule.camera.CameraManager;
import me.ydcool.lib.qrmodule.decoding.DecodeThread;
import me.ydcool.lib.qrmodule.view.ViewfinderResultPointCallback;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getSimpleName();
    private final QrScannerActivity activity;
    private final DecodeThread decodeThread;
    private State state;

    public CaptureActivityHandler(QrScannerActivity activity, Vector<BarcodeFormat> decodeFormats, String characterSet) {
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity, decodeFormats, characterSet, new ViewfinderResultPointCallback(activity.getViewfinderView()));
        this.decodeThread.start();
        this.state = State.SUCCESS;
        CameraManager.get().startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 100: {
                if (this.state != State.PREVIEW) break;
                CameraManager.get().requestAutoFocus(this, 100);
                break;
            }
            case 101: {
                Log.d((String)TAG, (String)"Got restart preview message");
                this.restartPreviewAndDecode();
                break;
            }
            case 102: {
                Log.d((String)TAG, (String)"Got decode succeeded message");
                this.state = State.SUCCESS;
                Bundle bundle = message.getData();
                Bitmap barcode = bundle == null ? null : (Bitmap)bundle.getParcelable("barcode_bitmap");
                this.activity.handleDecode((Result)message.obj, barcode);
                break;
            }
            case 103: {
                this.state = State.PREVIEW;
                CameraManager.get().requestPreviewFrame(this.decodeThread.getHandler(), 106);
                break;
            }
            case 104: {
                Log.d((String)TAG, (String)"Got return scan result message");
                this.activity.setResult(-1, (Intent)message.obj);
                this.activity.finish();
                break;
            }
            case 105: {
                Log.d((String)TAG, (String)"Got product query message");
                String url = (String)message.obj;
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.addFlags(524288);
                this.activity.startActivity(intent);
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        CameraManager.get().stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)107);
        quit.sendToTarget();
        try {
            this.decodeThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(102);
        this.removeMessages(103);
    }

    public void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.decodeThread.getHandler(), 106);
            CameraManager.get().requestAutoFocus(this, 100);
            this.activity.drawViewfinder();
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

