/*
 * Decompiled with CFR 0.152.
 */
package me.ydcool.lib.qrmodule.camera;

import android.os.IBinder;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class FlashlightManager {
    private static final String TAG = FlashlightManager.class.getSimpleName();
    private static final Object iHardwareService = FlashlightManager.getHardwareService();
    private static final Method setFlashEnabledMethod = FlashlightManager.getSetFlashEnabledMethod(iHardwareService);

    private FlashlightManager() {
    }

    static void enableFlashlight() {
        FlashlightManager.setFlashlight(false);
    }

    static void disableFlashlight() {
        FlashlightManager.setFlashlight(false);
    }

    private static Object getHardwareService() {
        Class<?> serviceManagerClass = FlashlightManager.maybeForName("android.os.ServiceManager");
        if (serviceManagerClass == null) {
            return null;
        }
        Method getServiceMethod = FlashlightManager.maybeGetMethod(serviceManagerClass, "getService", String.class);
        if (getServiceMethod == null) {
            return null;
        }
        Object hardwareService = FlashlightManager.invoke(getServiceMethod, null, "hardware");
        if (hardwareService == null) {
            return null;
        }
        Class<?> iHardwareServiceStubClass = FlashlightManager.maybeForName("android.os.IHardwareService$Stub");
        if (iHardwareServiceStubClass == null) {
            return null;
        }
        Method asInterfaceMethod = FlashlightManager.maybeGetMethod(iHardwareServiceStubClass, "asInterface", IBinder.class);
        if (asInterfaceMethod == null) {
            return null;
        }
        return FlashlightManager.invoke(asInterfaceMethod, null, hardwareService);
    }

    private static Method getSetFlashEnabledMethod(Object iHardwareService) {
        if (iHardwareService == null) {
            return null;
        }
        Class<?> proxyClass = iHardwareService.getClass();
        return FlashlightManager.maybeGetMethod(proxyClass, "setFlashlightEnabled", Boolean.TYPE);
    }

    private static Class<?> maybeForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (RuntimeException re) {
            Log.w((String)TAG, (String)("Unexpected error while finding class " + name), (Throwable)re);
            return null;
        }
    }

    private static Method maybeGetMethod(Class<?> clazz, String name, Class<?> ... argClasses) {
        try {
            return clazz.getMethod(name, argClasses);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (RuntimeException re) {
            Log.w((String)TAG, (String)("Unexpected error while finding method " + name), (Throwable)re);
            return null;
        }
    }

    private static Object invoke(Method method, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (String)("Unexpected error while invoking " + method), (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (String)("Unexpected error while invoking " + method), (Throwable)e.getCause());
            return null;
        }
        catch (RuntimeException re) {
            Log.w((String)TAG, (String)("Unexpected error while invoking " + method), (Throwable)re);
            return null;
        }
    }

    private static void setFlashlight(boolean active) {
        if (iHardwareService != null) {
            FlashlightManager.invoke(setFlashEnabledMethod, iHardwareService, active);
        }
    }

    static {
        if (iHardwareService == null) {
            Log.v((String)TAG, (String)"This device does supports control of a flashlight");
        } else {
            Log.v((String)TAG, (String)"This device does not support control of a flashlight");
        }
    }
}

