/*
 * Decompiled with CFR 0.152.
 */
package me.ydcool.lib.qrmodule.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import com.google.zxing.ResultPoint;
import java.io.IOException;
import me.ydcool.lib.qrmodule.camera.AutoFocusCallback;
import me.ydcool.lib.qrmodule.camera.CameraConfigurationManager;
import me.ydcool.lib.qrmodule.camera.FlashlightManager;
import me.ydcool.lib.qrmodule.camera.PlanarYUVLuminanceSource;
import me.ydcool.lib.qrmodule.camera.PreviewCallback;

public final class CameraManager {
    static final int SDK_INT;
    private static final String TAG;
    private static final int MIN_FRAME_WIDTH = 480;
    private static final int MIN_FRAME_HEIGHT = 360;
    private static final int MAX_FRAME_WIDTH = 800;
    private static final int MAX_FRAME_HEIGHT = 600;
    private static CameraManager cameraManager;
    private final Context context;
    private final CameraConfigurationManager configManager;
    private final boolean useOneShotPreviewCallback;
    private final PreviewCallback previewCallback;
    private final AutoFocusCallback autoFocusCallback;
    private Camera camera;
    private Rect framingRect;
    private Rect framingRectInPreview;
    private boolean initialized;
    private boolean previewing;

    private CameraManager(Context context) {
        this.context = context;
        this.configManager = new CameraConfigurationManager(context);
        this.useOneShotPreviewCallback = Integer.parseInt(Build.VERSION.SDK) > 3;
        this.previewCallback = new PreviewCallback(this.configManager, this.useOneShotPreviewCallback);
        this.autoFocusCallback = new AutoFocusCallback();
    }

    public static void init(Context context) {
        if (cameraManager == null) {
            cameraManager = new CameraManager(context);
        }
    }

    public static CameraManager get() {
        return cameraManager;
    }

    public void openDriver(SurfaceHolder holder) throws IOException {
        if (this.camera == null) {
            this.camera = Camera.open();
            if (this.camera == null) {
                throw new IOException();
            }
            this.camera.setPreviewDisplay(holder);
            if (!this.initialized) {
                this.initialized = true;
                this.configManager.initFromCameraParameters(this.camera);
            }
            this.configManager.setDesiredCameraParameters(this.camera);
            FlashlightManager.enableFlashlight();
        }
    }

    public void closeDriver() {
        if (this.camera != null) {
            FlashlightManager.disableFlashlight();
            this.camera.release();
            this.camera = null;
        }
    }

    public void startPreview() {
        if (this.camera != null && !this.previewing) {
            this.camera.startPreview();
            this.previewing = true;
        }
    }

    public void stopPreview() {
        if (this.camera != null && this.previewing) {
            if (!this.useOneShotPreviewCallback) {
                this.camera.setPreviewCallback(null);
            }
            this.camera.stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.autoFocusCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public void requestPreviewFrame(Handler handler, int message) {
        if (this.camera != null && this.previewing) {
            this.previewCallback.setHandler(handler, message);
            if (this.useOneShotPreviewCallback) {
                this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            } else {
                this.camera.setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            }
        }
    }

    public void requestAutoFocus(Handler handler, int message) {
        if (this.camera != null && this.previewing) {
            this.autoFocusCallback.setHandler(handler, message);
            this.camera.autoFocus((Camera.AutoFocusCallback)this.autoFocusCallback);
        }
    }

    public Rect getFramingRect() {
        Point screenResolution = this.configManager.getScreenResolution();
        if (this.framingRect == null) {
            int width;
            if (this.camera == null) {
                return null;
            }
            int height = width = screenResolution.x * 3 / 5;
            int leftOffset = (screenResolution.x - width) / 2;
            int topOffset = (screenResolution.y - height) / 3;
            this.framingRect = new Rect(leftOffset, topOffset, leftOffset + width, topOffset + height);
            Log.d((String)TAG, (String)("Calculated framing rect: " + this.framingRect));
        }
        return this.framingRect;
    }

    public Rect getFramingRectInPreview() {
        if (this.framingRectInPreview == null) {
            Rect rect = new Rect(this.getFramingRect());
            Point cameraResolution = this.configManager.getCameraResolution();
            Point screenResolution = this.configManager.getScreenResolution();
            rect.left = rect.left * cameraResolution.y / screenResolution.x;
            rect.right = rect.right * cameraResolution.y / screenResolution.x;
            rect.top = rect.top * cameraResolution.x / screenResolution.y;
            rect.bottom = rect.bottom * cameraResolution.x / screenResolution.y;
            this.framingRectInPreview = rect;
        }
        return this.framingRectInPreview;
    }

    public Point[] convertResultPoints(ResultPoint[] points) {
        Rect frame = this.getFramingRectInPreview();
        int count = points.length;
        Point[] output = new Point[count];
        for (int x = 0; x < count; ++x) {
            output[x] = new Point();
            output[x].x = frame.left + (int)(points[x].getX() + 0.5f);
            output[x].y = frame.top + (int)(points[x].getY() + 0.5f);
        }
        return output;
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height) {
        Rect rect = this.getFramingRectInPreview();
        int previewFormat = this.configManager.getPreviewFormat();
        String previewFormatString = this.configManager.getPreviewFormatString();
        switch (previewFormat) {
            case 16: 
            case 17: {
                return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height());
            }
        }
        if ("yuv420p".equals(previewFormatString)) {
            return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height());
        }
        throw new IllegalArgumentException("Unsupported picture format: " + previewFormat + '/' + previewFormatString);
    }

    public void openLight() {
        if (this.camera != null) {
            Camera.Parameters parameter = this.camera.getParameters();
            parameter.setFlashMode("torch");
            this.camera.setParameters(parameter);
        }
    }

    public void offLight() {
        if (this.camera != null) {
            Camera.Parameters parameter = this.camera.getParameters();
            parameter.setFlashMode("off");
            this.camera.setParameters(parameter);
        }
    }

    public Context getContext() {
        return this.context;
    }

    static {
        int sdkInt;
        TAG = CameraManager.class.getSimpleName();
        try {
            sdkInt = Integer.parseInt(Build.VERSION.SDK);
        }
        catch (NumberFormatException nfe) {
            sdkInt = 10000;
        }
        SDK_INT = sdkInt;
    }
}

