/*
 * Decompiled with CFR 0.152.
 */
package me.ydcool.lib.qrmodule.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import java.io.IOException;
import java.util.Vector;
import me.ydcool.lib.qrmodule.R;
import me.ydcool.lib.qrmodule.camera.CameraManager;
import me.ydcool.lib.qrmodule.decoding.CaptureActivityHandler;
import me.ydcool.lib.qrmodule.decoding.InactivityTimer;
import me.ydcool.lib.qrmodule.view.ViewfinderView;

public class QrScannerActivity
extends Activity
implements SurfaceHolder.Callback {
    private static final float BEEP_VOLUME = 0.1f;
    private static final long VIBRATE_DURATION = 200L;
    public static final String QR_RESULT_STR = "result";
    public static final int QR_REQUEST_CODE = 200;
    private final MediaPlayer.OnCompletionListener beepListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(0);
        }
    };
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private boolean hasSurface;
    private Vector<BarcodeFormat> decodeFormats;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;
    private boolean isFlashLightOn;
    private ImageView mFlashBtn;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_qr_scanner);
        if (this.getActionBar() != null) {
            this.getActionBar().hide();
        }
        this.setUpButtons();
        this.setUpCamera();
    }

    private void setUpButtons() {
        this.findViewById(R.id.back_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QrScannerActivity.this.finish();
            }
        });
        this.mFlashBtn = (ImageView)this.findViewById(R.id.flash_btn);
        this.mFlashBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QrScannerActivity.this.isFlashLightOn) {
                    CameraManager.get().offLight();
                } else {
                    CameraManager.get().openLight();
                }
                QrScannerActivity.this.mFlashBtn.setImageResource(QrScannerActivity.this.isFlashLightOn ? R.drawable.ic_flash_off_white_36dp : R.drawable.ic_flash_on_white_36dp);
                QrScannerActivity.this.isFlashLightOn = !QrScannerActivity.this.isFlashLightOn;
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.setUpSurfaceAndSound();
    }

    protected void setUpCamera() {
        CameraManager.init((Context)this.getApplication());
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        this.viewfinderView.setVisibility(0);
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
    }

    protected void setUpSurfaceAndSound() {
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
        surfaceView.setVisibility(0);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
        this.decodeFormats = null;
        this.characterSet = null;
        this.playBeep = true;
        AudioManager audioService = (AudioManager)this.getSystemService("audio");
        if (audioService.getRingerMode() != 2) {
            this.playBeep = false;
        }
        this.initBeepSound();
        this.vibrate = true;
    }

    protected void onPause() {
        super.onPause();
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        if (this.isFlashLightOn) {
            this.isFlashLightOn = false;
            CameraManager.get().offLight();
        }
        CameraManager.get().closeDriver();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public void handleDecode(Result result, Bitmap barcode) {
        this.inactivityTimer.onActivity();
        this.playBeepSoundAndVibrate();
        this.onQrResult(result.getText());
    }

    public void resetScanner() {
        if (this.handler != null) {
            this.handler.restartPreviewAndDecode();
        }
    }

    public void resetScannerDelayed(long millionSeconds) {
        this.mFlashBtn.postDelayed(new Runnable(){

            @Override
            public void run() {
                QrScannerActivity.this.resetScanner();
            }
        }, millionSeconds);
    }

    public void onQrResult(String resultString) {
        if (resultString.equals("")) {
            Toast.makeText((Context)this, (CharSequence)"Scan Result Empty!", (int)0).show();
            this.setResult(0);
        } else {
            Intent resultIntent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putString(QR_RESULT_STR, resultString);
            resultIntent.putExtras(bundle);
            this.setResult(-1, resultIntent);
        }
        this.finish();
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return;
        }
        if (this.handler == null) {
            this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.characterSet);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    private void initBeepSound() {
        if (this.playBeep && this.mediaPlayer == null) {
            this.setVolumeControlStream(3);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setOnCompletionListener(this.beepListener);
            AssetFileDescriptor file = this.getResources().openRawResourceFd(R.raw.beep);
            try {
                this.mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                this.mediaPlayer.setVolume(0.1f, 0.1f);
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        }
    }

    private void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }
}

