/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.tool;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class StringTool {
    public static String dealIfNull(String str) {
        return null == str ? "" : str;
    }

    public static void checkNull(String str, String name) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            Throwable throwable = new Throwable("\u5c5e\u6027\uff1a\uff08" + name + "\uff09\u4e0d\u80fd\u4e3a Empty");
            throw new RuntimeException(throwable);
        }
    }

    public static String parseUrl(String dir, String s) {
        StringTool.checkNothing(dir);
        StringTool.checkNothing(s);
        return dir + s;
    }

    private static void checkNotNull(Object o) {
        if (null == o) {
            Throwable throwable = new Throwable("\u5bf9\u8c61" + o.getClass().getSimpleName() + "\u4e0d\u80fd\u4e3anull");
            throw new RuntimeException(throwable);
        }
    }

    private static void checkNothing(String o) {
        StringTool.checkNotNull(o);
        if (TextUtils.isEmpty((CharSequence)o)) {
            Throwable throwable = new Throwable("\u6b64\u5904 \u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a \"\"");
            throw new RuntimeException(throwable);
        }
    }

    public static String getErrorMsg(Throwable e) {
        if (null == e) {
            return "";
        }
        String msg = e.getMessage();
        if (TextUtils.isEmpty((CharSequence)msg) && null != e.getCause()) {
            msg = e.getCause().getMessage();
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = e.getClass().getSimpleName();
        }
        return msg;
    }

    public static Map<String, String> parseQuery2Map(String query) {
        String[] strings = query.split("&");
        HashMap<String, String> queryMap = new HashMap<String, String>(strings.length);
        for (String string : strings) {
            String[] sub = string.split("=");
            if (sub.length <= 1) continue;
            queryMap.put(sub[0], sub[1]);
        }
        return queryMap;
    }

    public static String getMD5(String val) throws NoSuchAlgorithmException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] result = messageDigest.digest(val.getBytes());
            StringBuffer sb = new StringBuffer();
            for (byte b : result) {
                int num = b & 0xFF;
                String hex = Integer.toHexString(num);
                if (hex.length() == 1) {
                    sb.append(0);
                }
                sb.append(hex);
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String deleteString(String ssdz, String s) {
        if (TextUtils.isEmpty((CharSequence)ssdz)) {
            return "";
        }
        return ssdz.replaceAll(s, "");
    }

    public static String getGender(int xb) {
        String xbStr = "\u672a\u77e5";
        switch (xb) {
            case 1: {
                xbStr = "\u7537";
                break;
            }
            case 2: {
                xbStr = "\u5973";
                break;
            }
            default: {
                xbStr = "\u672a\u77e5\u6027\u522b";
            }
        }
        return xbStr;
    }

    public static String convertArray2String(ArrayList<Integer> houseIds) {
        int size = houseIds.size();
        if (null == houseIds || houseIds.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(houseIds.get(0)));
        if (size > 1) {
            for (int i = 1; i < size; ++i) {
                stringBuilder.append(",").append(houseIds.get(i));
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bitmapToBase64(Bitmap bitmap, int quality) {
        String result = null;
        ByteArrayOutputStream baos = null;
        try {
            if (bitmap != null) {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
                baos.flush();
                baos.close();
                byte[] bitmapBytes = baos.toByteArray();
                result = Base64.encodeToString((byte[])bitmapBytes, (int)0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String bitmapToBase64(Bitmap bitmap) {
        return StringTool.bitmapToBase64(bitmap, 80);
    }

    public static Bitmap base64ToBitmap(String base64Data) {
        if (null == base64Data) {
            return null;
        }
        byte[] bytes = Base64.decode((String)base64Data, (int)0);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static String formatTime(long time) {
        return StringTool.formatTime(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatTime(long time, String pattern) {
        if (time == 0L) {
            return "\u672a\u77e5";
        }
        SimpleDateFormat sDateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        String date = sDateFormat.format(new Date(time));
        return date;
    }
}

