/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.tool;

public class Transform {
    static final double Pi = Math.PI;
    static final double A = 6378245.0;
    static final double EE = 0.006693421622965943;

    public static double[] WGS842Mars(double wgsLat, double wgsLon) {
        double[] xyarr = new double[2];
        if (Transform.outOfChina(wgsLat, wgsLon)) {
            xyarr[1] = wgsLat;
            xyarr[0] = wgsLon;
            return xyarr;
        }
        double dLat = Transform.transformLat(wgsLon - 105.0, wgsLat - 35.0);
        double dLon = Transform.transformLon(wgsLon - 105.0, wgsLat - 35.0);
        double radLat = wgsLat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        xyarr[1] = wgsLat + dLat;
        xyarr[0] = wgsLon + dLon;
        return xyarr;
    }

    static boolean outOfChina(double lat, double lon) {
        if (lon < 72.004 || lon > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + 320.0 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static double[] Mars2WGS(double marsLat, double marsLng) {
        double[] rexy = new double[2];
        double prec = 1.0E-9;
        double minx = marsLng - 0.5;
        double miny = marsLat - 0.5;
        double maxx = marsLng + 0.5;
        double maxy = marsLat + 0.5;
        double dis = Double.MAX_VALUE;
        double curx = marsLng;
        double cury = marsLat;
        int count = 0;
        while (dis > prec) {
            curx = (minx + maxx) / 2.0;
            cury = (miny + maxy) / 2.0;
            double[] calxy = Transform.WGS842Mars(cury, curx);
            double calx = calxy[0];
            double caly = calxy[1];
            if (caly >= marsLat) {
                maxy = cury;
            } else {
                miny = cury;
            }
            if (calx >= marsLng) {
                maxx = curx;
            } else {
                minx = curx;
            }
            dis = Math.abs(calx - marsLng) + Math.abs(caly - marsLat);
            if (++count < 3) continue;
            if (Math.abs(maxx - minx) < prec / 5.0 && Math.abs(calx - marsLng) > prec / 2.0) {
                if (calx >= marsLng) {
                    minx -= 0.01;
                } else {
                    maxx += 0.01;
                }
            }
            if (Math.abs(maxy - miny) < prec / 5.0 && Math.abs(caly - marsLat) > prec / 2.0) {
                if (caly >= marsLat) {
                    miny -= 0.01;
                } else {
                    maxy += 0.01;
                }
            }
            if (!(minx > maxx) && !(miny > maxy) && count <= 300) continue;
            double wgsLng = 1.368660281996339E-7 * marsLng * marsLng * marsLng + -1.180928130750135E-8 * marsLng * marsLng * marsLat + -2.8882557135286497E-8 * marsLng * marsLat * marsLat + -1.9701061211739227E-8 * marsLat * marsLat * marsLat + -4.3871816410430085E-5 * marsLng * marsLng + 2.312263036974062E-6 * marsLng * marsLat + 3.524130062939154E-6 * marsLat * marsLat + 1.0045663287213806 * marsLng + -1.3931706059903598E-4 * marsLat + -0.15629046141059658;
            double wgsLat = 1.9633521507503826E-10 * marsLng * marsLng * marsLng + 5.042926958596946E-12 * marsLng * marsLng * marsLat + 1.4343237310979937E-10 * marsLng * marsLat * marsLat + 1.7413852403156825E-7 * marsLat * marsLat * marsLat + -7.126752970697697E-8 * marsLng * marsLng + -9.092793512456868E-7 * marsLng * marsLat + -1.8936576425611334E-5 * marsLat * marsLat + 2.1967158739942877E-5 * marsLng + 1.0006054151828006 * marsLat + -0.003172773997829536;
            double[] xys = Transform.WGS842Mars(wgsLat, wgsLng);
            double calx1 = xys[0];
            double caly1 = xys[1];
            double dis1 = Math.abs(calx1 - marsLng) + Math.abs(caly1 - marsLat);
            if (dis1 < dis) {
                rexy[0] = wgsLng;
                rexy[1] = wgsLat;
                return rexy;
            }
            wgsLat = cury;
            rexy[0] = wgsLng = curx;
            rexy[1] = wgsLat;
            return rexy;
        }
        rexy[0] = curx;
        rexy[1] = cury;
        return rexy;
    }
}

