/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.xutil.tool;

import android.content.Context;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.widget.TextView;
import me.xujichang.xutil.R;

public class SnackBarTool {
    private Snackbar snackbar;
    private static SnackBarTool instance;

    protected SnackBarTool(String pS) {
    }

    public static SnackBarTool getInstance() {
        if (null == instance) {
            instance = new SnackBarTool();
        }
        return instance;
    }

    private SnackBarTool() {
    }

    public void showToast(View view, String msg) {
        this.snackbar = Snackbar.make((View)view, (CharSequence)msg, (int)-1);
        this.initDefaultSnackBar(this.snackbar);
        this.snackbar.show();
    }

    private void initDefaultSnackBar(Snackbar snackbar) {
        Context context = snackbar.getContext();
        View view = snackbar.getView();
        TextView textView = (TextView)view.findViewById(R.id.snackbar_text);
        view.setBackgroundColor(context.getResources().getColor(R.color.colorPrimary));
        textView.setGravity(17);
        textView.setTextColor(-1);
    }

    public void showToastWithAction(View view, String msg, View.OnClickListener listener) {
        this.snackbar = Snackbar.make((View)view, (CharSequence)msg, (int)-2);
        this.initDefaultSnackBar(this.snackbar);
        this.snackbar.setAction((CharSequence)"Action", listener);
        this.snackbar.show();
    }

    public SnackBarTool showToastWithAction(View view, String msg) {
        this.snackbar = Snackbar.make((View)view, (CharSequence)msg, (int)-1);
        this.initDefaultSnackBar(this.snackbar);
        return this;
    }

    public SnackBarTool action(String action, View.OnClickListener listener) {
        this.snackbar.setAction((CharSequence)action, listener);
        return this;
    }

    public void show() {
        this.snackbar.show();
    }

    public SnackBarTool cancel(boolean cancel) {
        this.snackbar.setDuration(cancel ? -1 : -2);
        return this;
    }
}

