/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.xutil.tool;

public class BaiduTransform {
    private static double x_pi = 52.35987755982988;

    public static double[] TransMars2Baidu(double lat, double lng) {
        double xx;
        double[] outlatlng = new double[2];
        outlatlng = BaiduTransform.bd_encrypt(lat, lng);
        lat = outlatlng[1];
        lng = outlatlng[0];
        double[] outxy = BaiduTransform.LocationToLogicalPoint(lat, lng);
        double x = outxy[0];
        double y = outxy[1];
        double yy = 7.35352340086685E-12 * x * x + 9.39729146931851E-12 * x * y + 8.12647141921724E-10 * y * y + 1.98403678528303 * y + -2.12332608690639E-4 * x + 3915.53854399894;
        x = xx = 2.26599796724512E-12 * x * x + 3.5001926984551E-12 * x * y + 7.10391945293842E-13 * y * y + -5.51338363883895E-5 * y + 1.99995201582597 * x + 546.960811821871;
        y = yy;
        double bdy = -9.23252621691802E-13 * x * x + -1.1847454693199E-12 * x * y + 5.33054899581017E-5 * x + -1.0289695213812E-10 * y * y + 0.504013673001146 * y + -1945.85220766316;
        double bdx = -2.83449363094412E-13 * x * x + -4.39499358827202E-13 * x * y + 0.500012000279237 * x + -8.97821283288101E-14 * y * y + 1.38470631066736E-5 * y + -273.19134165059;
        double[] bdlatlng = BaiduTransform.Mercator2LngLat(bdx, bdy);
        return bdlatlng;
    }

    public static double[] TransBaidu2Mars(double bdlat, double bdlng) {
        double[] bdxy = BaiduTransform.LocationToLogicalPoint(bdlat, bdlng);
        double bdx = bdxy[0];
        double bdy = bdxy[1];
        double x = 2.27590556595279E-12 * bdx * bdx + 3.48903000589754E-12 * bdx * bdy + 1.99995185232662 * bdx + 6.22586361169189E-13 * bdy * bdy + -5.42933221577055E-5 * bdy + 545.606002724657;
        double y = 7.35379347817621E-12 * bdx * bdx + 9.39684565383036E-12 * bdx * bdy + -2.12336129489022E-4 * bdx + 8.12646661774628E-10 * bdy * bdy + 1.98403679386021 * bdy + 3916.0375954923;
        double xx = -2.73297968370015E-13 * x * x + -4.3688646200802E-13 * x * y + -9.82000305954539E-14 * y * y + 1.39020525825477E-5 * y + 0.500011499020342 * x + -267.697879080613;
        double yy = -9.0298913442894E-13 * x * x + -1.19856067495038E-12 * x * y + -1.03052329152388E-10 * y * y + 0.504016205195998 * y + 5.24246363084467E-5 * x + -1943.29405470358;
        double[] xy = BaiduTransform.Mercator2LngLat(xx, yy);
        double[] rexy = BaiduTransform.bd_decrypt(xy[1], xy[0]);
        return rexy;
    }

    private static double[] LocationToLogicalPoint(double Latitude, double Longitude) {
        double[] outdoubles = new double[]{Longitude * 2.003750834E7 / 180.0, Math.log(Math.tan((90.0 + Latitude) * Math.PI / 360.0)) / (Math.PI / 180)};
        outdoubles[1] = outdoubles[1] * 2.003750834E7 / 180.0;
        return outdoubles;
    }

    private static double[] Mercator2LngLat(double x, double y) {
        double[] outdoubles = new double[2];
        x = x / 2.003750834E7 * 180.0;
        y = y / 2.003750834E7 * 180.0;
        y = 57.29577951308232 * (2.0 * Math.atan(Math.exp(y * Math.PI / 180.0)) - 1.5707963267948966);
        outdoubles[0] = x;
        outdoubles[1] = y;
        return outdoubles;
    }

    private static double[] bd_encrypt(double gg_lat, double gg_lon) {
        double[] outdoubles = new double[2];
        double x = gg_lon;
        double y = gg_lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * x_pi);
        outdoubles[0] = z * Math.cos(theta) + 0.0065;
        outdoubles[1] = z * Math.sin(theta) + 0.006;
        return outdoubles;
    }

    private static double[] bd_decrypt(double bd_lat, double bd_lon) {
        double[] outdoubles = new double[2];
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_pi);
        outdoubles[0] = z * Math.cos(theta);
        outdoubles[1] = z * Math.sin(theta);
        return outdoubles;
    }
}

