/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.xutil.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.xujichang.xutil.activity.SuperActionBarActivity;
import me.xujichang.xutil.base.SuperPresenter;
import me.xujichang.xutil.bean.AppInfo;
import me.xujichang.xutil.tool.LogTool;
import me.xujichang.xutil.tool.SnackBarTool;

public abstract class SuperActivity
extends SuperActionBarActivity
implements View.OnClickListener {
    private MaterialDialog errorDialog;
    private MaterialDialog warningDialog;
    private ProgressDialog progressDialog;
    private int requestNum = 0;
    private long startTime = 0L;
    private SuperPresenter cachePresenter;

    public SuperPresenter getCachePresenter() {
        return this.cachePresenter;
    }

    protected void registerPresenter(SuperPresenter presenter) {
        this.cachePresenter = presenter;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (null != this.cachePresenter) {
            this.cachePresenter.destroy();
        }
    }

    public void onBackPressed() {
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        if (this.hideSoftKeyBoard() || this.hideKeyBoardForDialog()) {
            return;
        }
        if (this.getMainActivityName().equals(className)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.startTime > this.getActivityExitDuration()) {
                this.showToastWithAction("\u518d\u6b21\u70b9\u51fb\u5c06\u9000\u51fa\u7a0b\u5e8f", new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperActivity.this.finish();
                        System.gc();
                    }
                }, "\u9000\u51fa");
                this.startTime = currentTime;
            } else {
                this.finish();
                System.gc();
            }
            return;
        }
        this.onParentBackPressed();
    }

    public boolean hideKeyBoardForDialog() {
        return false;
    }

    public boolean hideSoftKeyBoard() {
        boolean closed = false;
        InputMethodManager methodManager = (InputMethodManager)this.getSystemService("input_method");
        if (null != methodManager) {
            closed = methodManager.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        return closed;
    }

    public void startLoading(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = "\u52a0\u8f7d\u4e2d...";
        }
        if (this.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        if (this.requestNum == 0) {
            this.progressDialog = ProgressDialog.show((Context)this, null, (CharSequence)msg);
        } else {
            this.progressDialog.setMessage((CharSequence)msg);
        }
        ++this.requestNum;
        LogTool.d("==============requestNum:" + this.requestNum);
    }

    public void stopLoading() {
        --this.requestNum;
        LogTool.d("==============requestNum:" + this.requestNum);
        if (this.requestNum > 0) {
            return;
        }
        if (null == this.progressDialog || this.requestNum < 0) {
            this.requestNum = 0;
        }
        if (null != this.progressDialog) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
            this.requestNum = 0;
        }
    }

    public void showToast(String msg) {
        this.showToast((View)this.getSuperRoot(), msg);
    }

    public void showToastWithAction(View view, String msg, View.OnClickListener listener) {
        this.showToastWithAction(view, msg, listener, "action");
    }

    public void showToastWithAction(View view, String msg, View.OnClickListener listener, String actionstr) {
        SnackBarTool.getInstance().showToastWithAction(view, msg).action(actionstr, listener).cancel(true).show();
    }

    public void showToastWithAction(View view, String msg, View.OnClickListener listener, String actionstr, boolean cancel) {
        if (!cancel) {
            msg = msg + "(\u53f3\u6ed1\u5220\u9664\u6b64\u6d88\u606f)";
        }
        SnackBarTool.getInstance().showToastWithAction(view, msg).action(actionstr, listener).cancel(cancel).show();
    }

    public void showToastWithAction(String msg, View.OnClickListener listener, String actionstr) {
        this.showToastWithAction((View)this.getSuperRoot(), msg, listener, actionstr);
    }

    public void showToastWithAction(String msg, View.OnClickListener listener, String actionstr, boolean cancel) {
        this.showToastWithAction((View)this.getSuperRoot(), msg, listener, actionstr, cancel);
    }

    public void showToast(String msg, View.OnClickListener listener) {
        this.showToastWithAction((View)this.getSuperRoot(), msg, listener);
    }

    public void showToast(View view, String msg) {
        this.showToastWithAction(view, msg, null);
    }

    public void loadingError(String msg) {
        this.createErrorDialog(msg);
    }

    public void loadingComplete() {
        this.stopLoading();
    }

    public void finishActivity() {
        this.finish();
    }

    public void startAnotherActivity(String activityName) {
        Intent intent = new Intent();
        intent.setClassName((Context)this, this.getPackageName() + "." + activityName);
        List resolveInfoList = this.getPackageManager().queryIntentActivities(intent, 0);
        if (resolveInfoList.size() > 0) {
            this.startActivity(intent);
        } else {
            this.createErrorDialog("\u76ee\u6807 " + activityName + "\u4e0d\u5b58\u5728", null);
        }
    }

    public void showWarningDialog(@NonNull String msg, MaterialDialog.SingleButtonCallback callback) {
        new MaterialDialog.Builder((Context)this).title((CharSequence)"\u8b66\u544a").content((CharSequence)msg).positiveText((CharSequence)"\u786e\u5b9a").negativeText((CharSequence)"\u53d6\u6d88").onPositive(callback).cancelable(false).build().show();
    }

    protected void createErrorDialog(String msg) {
        this.stopLoading();
        this.createErrorDialog(msg, null);
    }

    protected void createErrorDialog(String msg, MaterialDialog.SingleButtonCallback callback) {
        if (this.isFinishing()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = "\u672a\u77e5\u9519\u8bef";
        }
        if (null != this.errorDialog) {
            String temp = this.errorDialog.getContentView().getText().toString();
            this.errorDialog.setContent((CharSequence)new StringBuilder(temp).append(",").append(msg));
            return;
        }
        this.errorDialog = new MaterialDialog.Builder((Context)this).title((CharSequence)"Error").content((CharSequence)msg).positiveText((CharSequence)"\u786e\u5b9a").onPositive(callback).cancelable(false).dismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                SuperActivity.this.errorDialog = null;
            }
        }).build();
        this.errorDialog.show();
    }

    public void doFullScreen() {
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
    }

    public void toActivity(Class c) {
        this.toActivity(c, null);
    }

    public void toActivity(Class c, Map<String, String> parmas) {
        Intent intent = new Intent((Context)this, c);
        if (null != parmas) {
            for (Map.Entry<String, String> entry : parmas.entrySet()) {
                intent.putExtra(entry.getKey(), entry.getValue());
            }
        }
        this.startActivity(intent);
    }

    public void toActivityForResult(Class c, Map<String, String> parmas, int code) {
        Intent intent = new Intent((Context)this, c);
        if (null != parmas) {
            for (Map.Entry<String, String> entry : parmas.entrySet()) {
                intent.putExtra(entry.getKey(), entry.getValue());
            }
        }
        this.startActivityForResult(intent, code);
    }

    public void toActivityForResult(Class c, int code) {
        this.startActivityForResult(new Intent((Context)this, c), code);
    }

    protected void showUpdateDialog(AppInfo appInfo, MaterialDialog.SingleButtonCallback callback) {
        this.showUpdateDialog(appInfo, false, callback);
    }

    protected void showUpdateDialog(AppInfo appInfo, boolean must, MaterialDialog.SingleButtonCallback callback) {
        MaterialDialog dialog = new MaterialDialog.Builder((Context)this).title((CharSequence)(appInfo.getAppName() + "\u53ef\u66f4\u65b0")).content((CharSequence)appInfo.getContent()).autoDismiss(false).cancelable(false).positiveText((CharSequence)"\u66f4\u65b0").onPositive(callback).negativeText((CharSequence)"\u53d6\u6d88").onNegative(callback).build();
        if (must) {
            dialog.getActionButton(DialogAction.NEGATIVE).setVisibility(8);
        }
        dialog.show();
    }

    protected String[] checkPermissions(String[] permissions) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(permissions));
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!this.checkPermission(iterator.next())) continue;
            iterator.remove();
        }
        return arrayList.toArray(new String[0]);
    }

    protected boolean checkPermission(String permission2) {
        return ActivityCompat.checkSelfPermission((Context)this, (String)permission2) == 0;
    }

    public void requestPermission(String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)requestCode);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.onRequestPermissionCallBack(requestCode, grantResults);
    }

    protected void onRequestPermissionCallBack(int requestCode, int[] grantResults) {
    }

    protected abstract long getActivityExitDuration();

    protected abstract String getMainActivityName();

    protected void onParentBackPressed() {
        super.onBackPressed();
    }
}

