/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.activity;

import android.arch.lifecycle.LifecycleActivity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import me.xujichang.util.R;

public class SuperActionBarActivity
extends LifecycleActivity
implements View.OnClickListener {
    private ImageView actionbarLeftImg;
    private TextView actionbarLeftText;
    private TextView actionbarTitle;
    private TextView actionbarRightText;
    private ImageView actionbarRightImg;
    private LinearLayout actionBar;
    private ViewGroup root;

    public ImageView getActionbarLeftImg() {
        return this.actionbarLeftImg;
    }

    public void setActionbarLeftImg(ImageView actionbarLeftImg) {
        this.actionbarLeftImg = actionbarLeftImg;
    }

    public TextView getActionbarLeftText() {
        return this.actionbarLeftText;
    }

    public void setActionbarLeftText(TextView actionbarLeftText) {
        this.actionbarLeftText = actionbarLeftText;
    }

    public TextView getActionbarTitle() {
        return this.actionbarTitle;
    }

    public void setActionbarTitle(TextView actionbarTitle) {
        this.actionbarTitle = actionbarTitle;
    }

    public TextView getActionbarRightText() {
        return this.actionbarRightText;
    }

    public void setActionbarRightText(TextView actionbarRightText) {
        this.actionbarRightText = actionbarRightText;
    }

    public ImageView getActionbarRightImg() {
        return this.actionbarRightImg;
    }

    public void setActionbarRightImg(ImageView actionbarRightImg) {
        this.actionbarRightImg = actionbarRightImg;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        super.setContentView(R.layout.activity_layout_root);
    }

    public void setContentView(View view) {
        this.root = (ViewGroup)this.findViewById(R.id.activity_layout_root);
        View rootContainer = this.findViewById(R.id.activity_layout_root_container);
        if (null != this.root) {
            this.root.addView(view, -1, -1);
            this.actionBar = (LinearLayout)rootContainer.findViewById(R.id.activity_actionbar);
            LinearLayout statusBar = (LinearLayout)rootContainer.findViewById(R.id.status_bar);
            this.initBaseActionBar(this.actionBar);
        }
    }

    private void initBaseActionBar(LinearLayout actionBar) {
        if (null == actionBar) {
            return;
        }
        this.actionbarRightImg = (ImageView)actionBar.findViewById(R.id.actionbar_right_img);
        this.actionbarRightText = (TextView)actionBar.findViewById(R.id.actionbar_right_text);
        this.actionbarTitle = (TextView)actionBar.findViewById(R.id.actionbar_title);
        this.actionbarLeftText = (TextView)actionBar.findViewById(R.id.actionbar_left_text);
        this.actionbarLeftImg = (ImageView)actionBar.findViewById(R.id.actionbar_left_img);
    }

    public void setContentView(int layoutResID) {
        this.setContentView(View.inflate((Context)this, (int)layoutResID, null));
    }

    protected void setActionBarTitle(String title) {
        if (TextUtils.isEmpty((CharSequence)title)) {
            this.actionbarTitle.setVisibility(8);
        } else {
            this.actionbarTitle.setVisibility(0);
            this.actionbarTitle.setText((CharSequence)title);
            this.actionbarTitle.setOnClickListener((View.OnClickListener)this);
        }
    }

    protected void showBackArrow() {
        this.actionbarLeftImg.setVisibility(0);
        this.actionbarLeftImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    private void keepBalance() {
        if (this.actionbarLeftImg.getVisibility() == 0 && this.actionbarRightImg.getVisibility() == 8) {
            this.actionbarRightImg.setVisibility(4);
        }
        if (this.actionbarRightImg.getVisibility() == 0 && this.actionbarLeftImg.getVisibility() == 8) {
            this.actionbarLeftImg.setVisibility(4);
        }
    }

    protected void setLeftText(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            this.actionbarLeftText.setVisibility(8);
        } else {
            this.actionbarLeftText.setVisibility(0);
            this.actionbarLeftText.setText((CharSequence)str);
            this.actionbarLeftText.setOnClickListener((View.OnClickListener)this);
        }
        this.keepBalance();
    }

    protected void setLeftImg(@DrawableRes int id2) {
        this.actionbarLeftImg.setVisibility(0);
        this.actionbarLeftImg.setImageResource(id2);
        this.actionbarLeftImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    protected void showForwardArrow() {
        this.actionbarRightImg.setVisibility(0);
        this.actionbarRightImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    protected void setRightText(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            this.actionbarRightText.setVisibility(8);
        } else {
            this.actionbarRightText.setVisibility(0);
            this.actionbarRightText.setText((CharSequence)str);
            this.actionbarRightText.setOnClickListener((View.OnClickListener)this);
        }
        this.keepBalance();
    }

    protected void setRightImg(@DrawableRes int id2) {
        this.actionbarRightImg.setVisibility(0);
        this.actionbarRightImg.setImageResource(id2);
        this.actionbarRightImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.actionbar_left_img || id2 == R.id.actionbar_left_text) {
            this.onLeftAreaClick();
        } else if (id2 == R.id.actionbar_right_text || id2 == R.id.actionbar_right_img) {
            this.onRightAreaClick();
        } else if (id2 == R.id.actionbar_title) {
            this.onTitleClick();
        }
    }

    protected void onTitleClick() {
    }

    protected void onRightAreaClick() {
    }

    protected void onLeftAreaClick() {
        this.onBackPressed();
    }

    protected void hideActionBar() {
        if (null != this.actionBar) {
            this.actionBar.setVisibility(8);
        }
    }

    @Nullable
    protected LinearLayout getSuperActionBar() {
        return this.actionBar;
    }

    protected ViewGroup getSuperRoot() {
        return this.root;
    }

    protected boolean isActionBarShow() {
        return this.actionBar.getVisibility() == 0;
    }
}

