/*
 * Decompiled with CFR 0.152.
 */
package me.xiaosai.imagecompress;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import me.xiaosai.imagecompress.utils.BitmapUtil;

public class ImageCompress
implements Handler.Callback {
    private Builder mBuilder;
    private final int DEFAULT_SIZE = 150;
    private Handler mHandler;
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;

    private ImageCompress(Builder builder) {
        this.mBuilder = builder;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private void launch() {
        if (TextUtils.isEmpty((CharSequence)this.mBuilder.filePath) && this.mBuilder.listener != null) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)new NullPointerException("image file cannot be null")));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mBuilder.targetDir) && this.mBuilder.listener != null) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)new NullPointerException("targetDir cannot be null")));
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int ignoreSize = ImageCompress.this.mBuilder.ignoreSize == 0 ? 150 : ImageCompress.this.mBuilder.ignoreSize;
                    String targetCompressPath = ImageCompress.this.getImageCacheFile(ImageCompress.this.checkSuffix(ImageCompress.this.mBuilder.filePath));
                    String resultStr = BitmapUtil.compressBitmap(ImageCompress.this.mBuilder.filePath, targetCompressPath, ignoreSize);
                    if ("1".equals(resultStr)) {
                        ImageCompress.this.mHandler.sendMessage(ImageCompress.this.mHandler.obtainMessage(0, (Object)targetCompressPath));
                    } else {
                        ImageCompress.this.mHandler.sendMessage(ImageCompress.this.mHandler.obtainMessage(2, (Object)new RuntimeException(resultStr)));
                    }
                }
                catch (Exception e) {
                    ImageCompress.this.mHandler.sendMessage(ImageCompress.this.mHandler.obtainMessage(2, (Object)e));
                }
            }
        }).start();
    }

    public boolean handleMessage(Message msg) {
        if (this.mBuilder.listener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mBuilder.listener.onStart();
                break;
            }
            case 0: {
                this.mBuilder.listener.onSuccess(msg.obj + "");
                break;
            }
            case 2: {
                this.mBuilder.listener.onError((Throwable)msg.obj);
            }
        }
        return false;
    }

    private String checkSuffix(String path) {
        if (TextUtils.isEmpty((CharSequence)path) || !path.contains(".")) {
            return ".jpg";
        }
        return path.substring(path.lastIndexOf("."), path.length());
    }

    private String getImageCacheFile(String suffix) {
        return this.mBuilder.targetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + (TextUtils.isEmpty((CharSequence)suffix) ? ".jpg" : suffix);
    }

    public static interface OnCompressListener {
        public void onStart();

        public void onSuccess(String var1);

        public void onError(Throwable var1);
    }

    public static class Builder {
        private Context context;
        private String filePath;
        private int ignoreSize;
        private String targetDir;
        private OnCompressListener listener;

        private Builder(Context context) {
            this.context = context;
        }

        private ImageCompress build() {
            return new ImageCompress(this);
        }

        public Builder load(String localPath) {
            this.filePath = localPath;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.ignoreSize = size;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.targetDir = targetDir;
            return this;
        }

        public Builder setOnCompressListener(OnCompressListener listener) {
            this.listener = listener;
            return this;
        }

        public void launch() {
            this.build().launch();
        }
    }
}

