/*
 * Decompiled with CFR 0.152.
 */
package me.xiaosai.imagecompress.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import me.xiaosai.imagecompress.CompressCore;

public class BitmapUtil {
    private static final int DEFAULT_QUALITY = 95;

    public static String compressBitmap(Bitmap bit, String fileName, boolean optimize) {
        return CompressCore.saveBitmap(bit, 95, fileName, optimize);
    }

    public static String compressBitmap(Bitmap image, String filePath, int maxSize) {
        int ratio = BitmapUtil.getRatioSize(image.getWidth(), image.getHeight());
        Bitmap result = Bitmap.createBitmap((int)(image.getWidth() / ratio), (int)(image.getHeight() / ratio), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        Rect rect = new Rect(0, 0, image.getWidth() / ratio, image.getHeight() / ratio);
        canvas.drawBitmap(image, null, rect, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int options = 100;
        result.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
        while (baos.toByteArray().length / 1024 > maxSize) {
            baos.reset();
            result.compress(Bitmap.CompressFormat.JPEG, options -= 10, (OutputStream)baos);
        }
        String resultStr = CompressCore.saveBitmap(result, options, filePath, true);
        if (!result.isRecycled()) {
            result.recycle();
        }
        return resultStr;
    }

    public static String compressBitmap(String curFilePath, String targetFilePath, int maxSize) {
        Bitmap result = BitmapUtil.getBitmapFromFile(curFilePath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int quality = 100;
        result.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        while (baos.toByteArray().length / 1024 > maxSize) {
            baos.reset();
            result.compress(Bitmap.CompressFormat.JPEG, quality -= 10, (OutputStream)baos);
        }
        String resultStr = CompressCore.saveBitmap(result, quality, targetFilePath, true);
        if (!result.isRecycled()) {
            result.recycle();
        }
        return resultStr;
    }

    private static int getRatioSize(int bitWidth, int bitHeight) {
        int imageHeight = 1280;
        int imageWidth = 960;
        int ratio = 1;
        if (bitWidth > bitHeight && bitWidth > imageWidth) {
            ratio = bitWidth / imageWidth;
        } else if (bitWidth < bitHeight && bitHeight > imageHeight) {
            ratio = bitHeight / imageHeight;
        }
        if (ratio <= 0) {
            ratio = 1;
        }
        return ratio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap getBitmapFromFile(String filePath) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)newOpts);
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        newOpts.inSampleSize = BitmapUtil.getRatioSize(w, h);
        newOpts.inJustDecodeBounds = false;
        newOpts.inDither = false;
        newOpts.inPurgeable = true;
        newOpts.inInputShareable = true;
        newOpts.inTempStorage = new byte[32768];
        Bitmap bitmap = null;
        File file = new File(filePath);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            if (fs != null) {
                bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fs.getFD(), null, (BitmapFactory.Options)newOpts);
                int photoDegree = BitmapUtil.readPictureDegree(filePath);
                if (photoDegree != 0) {
                    Matrix matrix = new Matrix();
                    matrix.postRotate((float)photoDegree);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bitmap;
    }

    private static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }
}

