/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed.services;

import de.robv.android.xposed.services.BaseService;
import de.robv.android.xposed.services.FileResult;
import java.io.IOException;
import java.util.Arrays;

public final class ZygoteService
extends BaseService {
    @Override
    public native boolean checkFileAccess(String var1, int var2);

    @Override
    public native FileResult statFile(String var1) throws IOException;

    @Override
    public native byte[] readFile(String var1) throws IOException;

    @Override
    public FileResult readFile(String filename, long previousSize, long previousTime) throws IOException {
        FileResult stat = this.statFile(filename);
        if (previousSize == stat.size && previousTime == stat.mtime) {
            return stat;
        }
        return new FileResult(this.readFile(filename), stat.size, stat.mtime);
    }

    @Override
    public FileResult readFile(String filename, int offset, int length, long previousSize, long previousTime) throws IOException {
        FileResult stat = this.statFile(filename);
        if (previousSize == stat.size && previousTime == stat.mtime) {
            return stat;
        }
        if (offset <= 0 && length <= 0) {
            return new FileResult(this.readFile(filename), stat.size, stat.mtime);
        }
        if (offset > 0 && (long)offset >= stat.size) {
            throw new IllegalArgumentException("offset " + offset + " >= size " + stat.size + " for " + filename);
        }
        if (offset < 0) {
            offset = 0;
        }
        if (length > 0 && (long)(offset + length) > stat.size) {
            throw new IllegalArgumentException("offset " + offset + " + length " + length + " > size " + stat.size + " for " + filename);
        }
        if (length <= 0) {
            length = (int)(stat.size - (long)offset);
        }
        byte[] content = this.readFile(filename);
        return new FileResult(Arrays.copyOfRange(content, offset, offset + length), stat.size, stat.mtime);
    }
}

