/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed.services;

import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import de.robv.android.xposed.services.BaseService;
import de.robv.android.xposed.services.FileResult;
import java.io.IOException;

public final class BinderService
extends BaseService {
    public static final int TARGET_APP = 0;
    public static final int TARGET_SYSTEM = 1;
    private static final String INTERFACE_TOKEN = "de.robv.android.xposed.IXposedService";
    private static final int ACCESS_FILE_TRANSACTION = 3;
    private static final int STAT_FILE_TRANSACTION = 4;
    private static final int READ_FILE_TRANSACTION = 5;
    private static final String[] SERVICE_NAMES = new String[]{"user.xposed.app", "user.xposed.system"};
    private static final BinderService[] sServices = new BinderService[2];
    private final IBinder mRemote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinderService getService(int target) {
        if (target < 0 || target > sServices.length) {
            throw new IllegalArgumentException("Invalid service target " + target);
        }
        BinderService[] binderServiceArray = sServices;
        synchronized (sServices) {
            if (sServices[target] == null) {
                BinderService.sServices[target] = new BinderService(target);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sServices[target];
        }
    }

    @Override
    public boolean checkFileAccess(String filename, int mode) {
        BinderService.ensureAbsolutePath(filename);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken(INTERFACE_TOKEN);
        data.writeString(filename);
        data.writeInt(mode);
        try {
            this.mRemote.transact(3, data, reply, 0);
        }
        catch (RemoteException e) {
            data.recycle();
            reply.recycle();
            return false;
        }
        reply.readException();
        int result = reply.readInt();
        reply.recycle();
        data.recycle();
        return result == 0;
    }

    @Override
    public FileResult statFile(String filename) throws IOException {
        BinderService.ensureAbsolutePath(filename);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken(INTERFACE_TOKEN);
        data.writeString(filename);
        try {
            this.mRemote.transact(4, data, reply, 0);
        }
        catch (RemoteException e) {
            data.recycle();
            reply.recycle();
            throw new IOException(e);
        }
        reply.readException();
        int errno = reply.readInt();
        if (errno != 0) {
            BinderService.throwCommonIOException(errno, null, filename, " while retrieving attributes for ");
        }
        long size = reply.readLong();
        long time = reply.readLong();
        reply.recycle();
        data.recycle();
        return new FileResult(size, time);
    }

    @Override
    public byte[] readFile(String filename) throws IOException {
        return this.readFile((String)filename, (int)0, (int)0, (long)0L, (long)0L).content;
    }

    @Override
    public FileResult readFile(String filename, long previousSize, long previousTime) throws IOException {
        return this.readFile(filename, 0, 0, previousSize, previousTime);
    }

    @Override
    public FileResult readFile(String filename, int offset, int length, long previousSize, long previousTime) throws IOException {
        BinderService.ensureAbsolutePath(filename);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken(INTERFACE_TOKEN);
        data.writeString(filename);
        data.writeInt(offset);
        data.writeInt(length);
        data.writeLong(previousSize);
        data.writeLong(previousTime);
        try {
            this.mRemote.transact(5, data, reply, 0);
        }
        catch (RemoteException e) {
            data.recycle();
            reply.recycle();
            throw new IOException(e);
        }
        reply.readException();
        int errno = reply.readInt();
        String errorMsg = reply.readString();
        long size = reply.readLong();
        long time = reply.readLong();
        byte[] content = reply.createByteArray();
        reply.recycle();
        data.recycle();
        switch (errno) {
            case 0: {
                return new FileResult(content, size, time);
            }
            case 22: {
                if (errorMsg != null) {
                    IllegalArgumentException iae = new IllegalArgumentException(errorMsg);
                    if (offset == 0 && length == 0) {
                        throw new IOException(iae);
                    }
                    throw iae;
                }
                throw new IllegalArgumentException("Offset " + offset + " / Length " + length + " is out of range for " + filename + " with size " + size);
            }
        }
        BinderService.throwCommonIOException(errno, errorMsg, filename, " while reading ");
        throw new IllegalStateException();
    }

    private BinderService(int target) {
        IBinder binder = ServiceManager.getService((String)SERVICE_NAMES[target]);
        if (binder == null) {
            throw new IllegalStateException("Service " + SERVICE_NAMES[target] + " does not exist");
        }
        this.mRemote = binder;
    }
}

