/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed;

import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.app.AndroidAppHelper;
import android.app.Application;
import android.app.LoadedApk;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XResources;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.Process;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.os.ZygoteInit;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import de.robv.android.xposed.IXposedHookCmdInit;
import de.robv.android.xposed.IXposedHookInitPackageResources;
import de.robv.android.xposed.IXposedHookLoadPackage;
import de.robv.android.xposed.IXposedHookZygoteInit;
import de.robv.android.xposed.IXposedMod;
import de.robv.android.xposed.SELinuxHelper;
import de.robv.android.xposed.XC_MethodHook;
import de.robv.android.xposed.XC_MethodReplacement;
import de.robv.android.xposed.XposedBridge;
import de.robv.android.xposed.XposedHelpers;
import de.robv.android.xposed.callbacks.XC_InitPackageResources;
import de.robv.android.xposed.callbacks.XC_LoadPackage;
import de.robv.android.xposed.callbacks.XCallback;
import de.robv.android.xposed.services.BaseService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class XposedInit {
    private static final String TAG = "Xposed";
    private static final boolean startsSystemServer = XposedBridge.startsSystemServer();
    private static final String startClassName = XposedBridge.getStartClassName();
    private static final String INSTALLER_PACKAGE_NAME = "de.robv.android.xposed.installer";
    @SuppressLint(value={"SdCardPath"})
    private static final String BASE_DIR = Build.VERSION.SDK_INT >= 24 ? "/data/user_de/0/de.robv.android.xposed.installer/" : "/data/data/de.robv.android.xposed.installer/";
    private static final String INSTANT_RUN_CLASS = "com.android.tools.fd.runtime.BootstrapApplication";
    private static boolean disableResources = false;
    private static final String[] XRESOURCES_CONFLICTING_PACKAGES = new String[]{"com.sygic.aura"};

    private XposedInit() {
    }

    static void initForZygote() throws Throwable {
        Class<?> zygote;
        if (XposedInit.needsToCloseFilesForFork()) {
            XC_MethodHook callback = new XC_MethodHook(){

                @Override
                protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    XposedBridge.closeFilesBeforeForkNative();
                }

                @Override
                protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    XposedBridge.reopenFilesAfterForkNative();
                }
            };
            zygote = XposedHelpers.findClass("com.android.internal.os.Zygote", null);
            XposedBridge.hookAllMethods(zygote, "nativeForkAndSpecialize", callback);
            XposedBridge.hookAllMethods(zygote, "nativeForkSystemServer", callback);
        }
        final HashSet loadedPackagesInProcess = new HashSet(1);
        XposedHelpers.findAndHookMethod(ActivityThread.class, "handleBindApplication", "android.app.ActivityThread.AppBindData", new XC_MethodHook(){

            @Override
            protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                ActivityThread activityThread = (ActivityThread)param.thisObject;
                ApplicationInfo appInfo = (ApplicationInfo)XposedHelpers.getObjectField(param.args[0], "appInfo");
                String reportedPackageName = appInfo.packageName.equals("android") ? "system" : appInfo.packageName;
                SELinuxHelper.initForProcess(reportedPackageName);
                ComponentName instrumentationName = (ComponentName)XposedHelpers.getObjectField(param.args[0], "instrumentationName");
                if (instrumentationName != null) {
                    Log.w((String)XposedInit.TAG, (String)("Instrumentation detected, disabling framework for " + reportedPackageName));
                    XposedBridge.disableHooks = true;
                    return;
                }
                CompatibilityInfo compatInfo = (CompatibilityInfo)XposedHelpers.getObjectField(param.args[0], "compatInfo");
                if (appInfo.sourceDir == null) {
                    return;
                }
                XposedHelpers.setObjectField(activityThread, "mBoundApplication", param.args[0]);
                loadedPackagesInProcess.add(reportedPackageName);
                LoadedApk loadedApk = activityThread.getPackageInfoNoCheck(appInfo, compatInfo);
                XResources.setPackageNameForResDir(appInfo.packageName, loadedApk.getResDir());
                XC_LoadPackage.LoadPackageParam lpparam = new XC_LoadPackage.LoadPackageParam(XposedBridge.sLoadedPackageCallbacks);
                lpparam.packageName = reportedPackageName;
                lpparam.processName = (String)XposedHelpers.getObjectField(param.args[0], "processName");
                lpparam.classLoader = loadedApk.getClassLoader();
                lpparam.appInfo = appInfo;
                lpparam.isFirstApplication = true;
                XC_LoadPackage.callAll(lpparam);
                if (reportedPackageName.equals(XposedInit.INSTALLER_PACKAGE_NAME)) {
                    XposedInit.hookXposedInstaller(lpparam.classLoader);
                }
            }
        });
        if (Build.VERSION.SDK_INT < 21) {
            XposedHelpers.findAndHookMethod("com.android.server.ServerThread", null, Build.VERSION.SDK_INT < 19 ? "run" : "initAndLoop", new XC_MethodHook(){

                @Override
                protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    SELinuxHelper.initForProcess("android");
                    loadedPackagesInProcess.add("android");
                    XC_LoadPackage.LoadPackageParam lpparam = new XC_LoadPackage.LoadPackageParam(XposedBridge.sLoadedPackageCallbacks);
                    lpparam.packageName = "android";
                    lpparam.processName = "android";
                    lpparam.classLoader = XposedBridge.BOOTCLASSLOADER;
                    lpparam.appInfo = null;
                    lpparam.isFirstApplication = true;
                    XC_LoadPackage.callAll(lpparam);
                }
            });
        } else if (startsSystemServer) {
            XposedHelpers.findAndHookMethod(ActivityThread.class, "systemMain", new XC_MethodHook(){

                @Override
                protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    final ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    XposedHelpers.findAndHookMethod("com.android.server.SystemServer", cl, "startBootstrapServices", new XC_MethodHook(){

                        @Override
                        protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                            SELinuxHelper.initForProcess("android");
                            loadedPackagesInProcess.add("android");
                            XC_LoadPackage.LoadPackageParam lpparam = new XC_LoadPackage.LoadPackageParam(XposedBridge.sLoadedPackageCallbacks);
                            lpparam.packageName = "android";
                            lpparam.processName = "android";
                            lpparam.classLoader = cl;
                            lpparam.appInfo = null;
                            lpparam.isFirstApplication = true;
                            XC_LoadPackage.callAll(lpparam);
                            try {
                                XposedHelpers.findAndHookMethod("com.android.server.pm.HwPackageManagerService", cl, "isOdexMode", XC_MethodReplacement.returnConstant(false));
                            }
                            catch (XposedHelpers.ClassNotFoundError | NoSuchMethodError error) {
                                // empty catch block
                            }
                            try {
                                String className = "com.android.server.pm." + (Build.VERSION.SDK_INT >= 23 ? "PackageDexOptimizer" : "PackageManagerService");
                                XposedHelpers.findAndHookMethod(className, cl, "dexEntryExists", String.class, XC_MethodReplacement.returnConstant(true));
                            }
                            catch (XposedHelpers.ClassNotFoundError | NoSuchMethodError error) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
        }
        XposedBridge.hookAllConstructors(LoadedApk.class, new XC_MethodHook(){

            @Override
            protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                LoadedApk loadedApk = (LoadedApk)param.thisObject;
                String packageName = loadedApk.getPackageName();
                XResources.setPackageNameForResDir(packageName, loadedApk.getResDir());
                if (packageName.equals("android") || !loadedPackagesInProcess.add(packageName)) {
                    return;
                }
                if (!XposedHelpers.getBooleanField(loadedApk, "mIncludeCode")) {
                    return;
                }
                XC_LoadPackage.LoadPackageParam lpparam = new XC_LoadPackage.LoadPackageParam(XposedBridge.sLoadedPackageCallbacks);
                lpparam.packageName = packageName;
                lpparam.processName = AndroidAppHelper.currentProcessName();
                lpparam.classLoader = loadedApk.getClassLoader();
                lpparam.appInfo = loadedApk.getApplicationInfo();
                lpparam.isFirstApplication = false;
                XC_LoadPackage.callAll(lpparam);
            }
        });
        XposedHelpers.findAndHookMethod("android.app.ApplicationPackageManager", null, "getResourcesForApplication", ApplicationInfo.class, new XC_MethodHook(){

            @Override
            protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                ApplicationInfo app = (ApplicationInfo)param.args[0];
                XResources.setPackageNameForResDir(app.packageName, app.uid == Process.myUid() ? app.sourceDir : app.publicSourceDir);
            }
        });
        if (XposedHelpers.findFieldIfExists(ZygoteInit.class, "BOOT_START_TIME") != null) {
            XposedHelpers.setStaticLongField(ZygoteInit.class, "BOOT_START_TIME", XposedBridge.BOOT_START_TIME);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            zygote = XposedHelpers.findClass("com.android.internal.os.Zygote", null);
            try {
                XposedHelpers.setStaticBooleanField(zygote, "isEnhancedZygoteASLREnabled", false);
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static void hookResources() throws Throwable {
        Class<?> classResKey;
        Class classGTLR;
        if (SELinuxHelper.getAppDataFileService().checkFileExists(BASE_DIR + "conf/disable_resources")) {
            Log.w((String)TAG, (String)("Found " + BASE_DIR + "conf/disable_resources, not hooking resources"));
            disableResources = true;
            return;
        }
        if (!XposedBridge.initXResourcesNative()) {
            Log.e((String)TAG, (String)"Cannot hook resources");
            disableResources = true;
            return;
        }
        final ThreadLocal<Object> latestResKey = new ThreadLocal<Object>();
        if (Build.VERSION.SDK_INT <= 18) {
            classGTLR = ActivityThread.class;
            classResKey = Class.forName("android.app.ActivityThread$ResourcesKey");
        } else {
            classGTLR = Class.forName("android.app.ResourcesManager");
            classResKey = Class.forName("android.content.res.ResourcesKey");
        }
        if (Build.VERSION.SDK_INT >= 24) {
            XposedBridge.hookAllMethods(classGTLR, "getOrCreateResources", new XC_MethodHook(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    int activityTokenIdx = XposedHelpers.getParameterIndexByType(param.method, IBinder.class);
                    int resKeyIdx = XposedHelpers.getParameterIndexByType(param.method, classResKey);
                    String resDir = (String)XposedHelpers.getObjectField(param.args[resKeyIdx], "mResDir");
                    XResources newRes = XposedInit.cloneToXResources(param, resDir);
                    if (newRes == null) {
                        return;
                    }
                    Object activityToken = param.args[activityTokenIdx];
                    Object object = param.thisObject;
                    synchronized (object) {
                        ArrayList resourceReferences;
                        if (activityToken != null) {
                            Object activityResources = XposedHelpers.callMethod(param.thisObject, "getOrCreateActivityResourcesStructLocked", activityToken);
                            resourceReferences = (ArrayList)XposedHelpers.getObjectField(activityResources, "activityResources");
                        } else {
                            resourceReferences = (ArrayList)XposedHelpers.getObjectField(param.thisObject, "mResourceReferences");
                        }
                        resourceReferences.add(new WeakReference<XResources>(newRes));
                    }
                }
            });
        } else {
            XposedBridge.hookAllConstructors(classResKey, new XC_MethodHook(){

                @Override
                protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    latestResKey.set(param.thisObject);
                }
            });
            XposedBridge.hookAllMethods(classGTLR, "getTopLevelResources", new XC_MethodHook(){

                @Override
                protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    latestResKey.set(null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    Object lockObject;
                    Object key = latestResKey.get();
                    if (key == null) {
                        return;
                    }
                    latestResKey.set(null);
                    String resDir = (String)XposedHelpers.getObjectField(key, "mResDir");
                    XResources newRes = XposedInit.cloneToXResources(param, resDir);
                    if (newRes == null) {
                        return;
                    }
                    Map mActiveResources = (Map)XposedHelpers.getObjectField(param.thisObject, "mActiveResources");
                    Object object = lockObject = Build.VERSION.SDK_INT <= 18 ? XposedHelpers.getObjectField(param.thisObject, "mPackages") : param.thisObject;
                    synchronized (object) {
                        WeakReference<XResources> existing = mActiveResources.put(key, new WeakReference<XResources>(newRes));
                        if (existing != null && existing.get() != null && ((Resources)existing.get()).getAssets() != newRes.getAssets()) {
                            ((Resources)existing.get()).getAssets().close();
                        }
                    }
                }
            });
            if (Build.VERSION.SDK_INT >= 19) {
                XposedBridge.hookAllMethods(classGTLR, "getTopLevelThemedResources", new XC_MethodHook(){

                    @Override
                    protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                        String resDir = (String)param.args[0];
                        XposedInit.cloneToXResources(param, resDir);
                    }
                });
            }
        }
        if (Build.VERSION.SDK_INT >= 24) {
            Set<Method> methods = XposedHelpers.getOverriddenMethods(XResources.XTypedArray.class);
            XposedBridge.invalidateCallersNative(methods.toArray(new Member[methods.size()]));
        }
        XposedBridge.hookAllConstructors(TypedArray.class, new XC_MethodHook(){

            @Override
            protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                TypedArray typedArray = (TypedArray)param.thisObject;
                Resources res = typedArray.getResources();
                if (res instanceof XResources) {
                    XposedBridge.setObjectClass(typedArray, XResources.XTypedArray.class);
                }
            }
        });
        XResources systemRes = (XResources)((Object)XposedBridge.cloneToSubclass(Resources.getSystem(), XResources.class));
        systemRes.initObject(null);
        XposedHelpers.setStaticObjectField(Resources.class, "mSystem", (Object)systemRes);
        XResources.init(latestResKey);
    }

    private static XResources cloneToXResources(XC_MethodHook.MethodHookParam param, String resDir) {
        Object result = param.getResult();
        if (result == null || result instanceof XResources || Arrays.binarySearch(XRESOURCES_CONFLICTING_PACKAGES, AndroidAppHelper.currentPackageName()) == 0) {
            return null;
        }
        XResources newRes = (XResources)((Object)XposedBridge.cloneToSubclass(result, XResources.class));
        newRes.initObject(resDir);
        if (newRes.isFirstLoad()) {
            String packageName = newRes.getPackageName();
            XC_InitPackageResources.InitPackageResourcesParam resparam = new XC_InitPackageResources.InitPackageResourcesParam(XposedBridge.sInitPackageResourcesCallbacks);
            resparam.packageName = packageName;
            resparam.res = newRes;
            XCallback.callAll(resparam);
        }
        param.setResult((Object)newRes);
        return newRes;
    }

    private static boolean needsToCloseFilesForFork() {
        if (Build.VERSION.SDK_INT >= 24) {
            return true;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        File lib = new File(Environment.getRootDirectory(), "lib/libandroid_runtime.so");
        try {
            return XposedHelpers.fileContains(lib, "Unable to construct file descriptor table");
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Could not check whether " + lib + " has security patch level 5"));
            return true;
        }
    }

    private static void hookXposedInstaller(ClassLoader classLoader) {
        try {
            XposedHelpers.findAndHookMethod("de.robv.android.xposed.installer.XposedApp", classLoader, "getActiveXposedVersion", XC_MethodReplacement.returnConstant(XposedBridge.getXposedVersion()));
            XposedHelpers.findAndHookMethod("de.robv.android.xposed.installer.XposedApp", classLoader, "onCreate", new XC_MethodHook(){

                @Override
                protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                    Application application = (Application)param.thisObject;
                    Resources res = application.getResources();
                    if (res.getIdentifier("installer_needs_update", "string", XposedInit.INSTALLER_PACKAGE_NAME) == 0) {
                        Log.e((String)"XposedInstaller", (String)"Xposed Installer is outdated (resource string \"installer_needs_update\" is missing)");
                        Toast.makeText((Context)application, (CharSequence)"Please update Xposed Installer!", (int)1).show();
                    }
                }
            });
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"Could not hook Xposed Installer", (Throwable)t);
        }
    }

    static void loadModules() throws IOException {
        String apk;
        ClassLoader parent;
        String filename = BASE_DIR + "conf/modules.list";
        BaseService service = SELinuxHelper.getAppDataFileService();
        if (!service.checkFileExists(filename)) {
            Log.e((String)TAG, (String)("Cannot load any modules because " + filename + " was not found"));
            return;
        }
        ClassLoader topClassLoader = XposedBridge.BOOTCLASSLOADER;
        while ((parent = topClassLoader.getParent()) != null) {
            topClassLoader = parent;
        }
        InputStream stream = service.getFileInputStream(filename);
        BufferedReader apks = new BufferedReader(new InputStreamReader(stream));
        while ((apk = apks.readLine()) != null) {
            XposedInit.loadModule(apk, topClassLoader);
        }
        apks.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadModule(String apk, ClassLoader topClassLoader) {
        InputStream is;
        DexFile dexFile;
        Log.i((String)TAG, (String)("Loading modules from " + apk));
        if (!new File(apk).exists()) {
            Log.e((String)TAG, (String)"  File does not exist");
            return;
        }
        try {
            dexFile = new DexFile(apk);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"  Cannot load module", (Throwable)e);
            return;
        }
        if (dexFile.loadClass(INSTANT_RUN_CLASS, topClassLoader) != null) {
            Log.e((String)TAG, (String)"  Cannot load module, please disable \"Instant Run\" in Android Studio.");
            XposedHelpers.closeSilently(dexFile);
            return;
        }
        if (dexFile.loadClass(XposedBridge.class.getName(), topClassLoader) != null) {
            Log.e((String)TAG, (String)"  Cannot load module:");
            Log.e((String)TAG, (String)"  The Xposed API classes are compiled into the module's APK.");
            Log.e((String)TAG, (String)"  This may cause strange issues and must be fixed by the module developer.");
            Log.e((String)TAG, (String)"  For details, see: http://api.xposed.info/using.html");
            XposedHelpers.closeSilently(dexFile);
            return;
        }
        XposedHelpers.closeSilently(dexFile);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(apk);
            ZipEntry zipEntry = zipFile.getEntry("assets/xposed_init");
            if (zipEntry == null) {
                Log.e((String)TAG, (String)"  assets/xposed_init not found in the APK");
                XposedHelpers.closeSilently(zipFile);
                return;
            }
            is = zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"  Cannot read assets/xposed_init in the APK", (Throwable)e);
            XposedHelpers.closeSilently(zipFile);
            return;
        }
        PathClassLoader mcl = new PathClassLoader(apk, XposedBridge.BOOTCLASSLOADER);
        BufferedReader moduleClassesReader = new BufferedReader(new InputStreamReader(is));
        try {
            String moduleClassName;
            while ((moduleClassName = moduleClassesReader.readLine()) != null) {
                if ((moduleClassName = moduleClassName.trim()).isEmpty() || moduleClassName.startsWith("#")) continue;
                try {
                    Object param;
                    Log.i((String)TAG, (String)("  Loading class " + moduleClassName));
                    Class<?> moduleClass = mcl.loadClass(moduleClassName);
                    if (!IXposedMod.class.isAssignableFrom(moduleClass)) {
                        Log.e((String)TAG, (String)"    This class doesn't implement any sub-interface of IXposedMod, skipping it");
                        continue;
                    }
                    if (disableResources && IXposedHookInitPackageResources.class.isAssignableFrom(moduleClass)) {
                        Log.e((String)TAG, (String)"    This class requires resource-related hooks (which are disabled), skipping it.");
                        continue;
                    }
                    Object moduleInstance = moduleClass.newInstance();
                    if (XposedBridge.isZygote) {
                        if (moduleInstance instanceof IXposedHookZygoteInit) {
                            param = new IXposedHookZygoteInit.StartupParam();
                            ((IXposedHookZygoteInit.StartupParam)param).modulePath = apk;
                            ((IXposedHookZygoteInit.StartupParam)param).startsSystemServer = startsSystemServer;
                            ((IXposedHookZygoteInit)moduleInstance).initZygote((IXposedHookZygoteInit.StartupParam)param);
                        }
                        if (moduleInstance instanceof IXposedHookLoadPackage) {
                            XposedBridge.hookLoadPackage(new IXposedHookLoadPackage.Wrapper((IXposedHookLoadPackage)moduleInstance));
                        }
                        if (!(moduleInstance instanceof IXposedHookInitPackageResources)) continue;
                        XposedBridge.hookInitPackageResources(new IXposedHookInitPackageResources.Wrapper((IXposedHookInitPackageResources)moduleInstance));
                        continue;
                    }
                    if (!(moduleInstance instanceof IXposedHookCmdInit)) continue;
                    param = new IXposedHookCmdInit.StartupParam();
                    ((IXposedHookCmdInit.StartupParam)param).modulePath = apk;
                    ((IXposedHookCmdInit.StartupParam)param).startClassName = startClassName;
                    ((IXposedHookCmdInit)moduleInstance).initCmdApp((IXposedHookCmdInit.StartupParam)param);
                }
                catch (Throwable t) {
                    Log.e((String)TAG, (String)("    Failed to load class " + moduleClassName), (Throwable)t);
                }
            }
            return;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("  Failed to load module from " + apk), (Throwable)e);
            return;
        }
        finally {
            XposedHelpers.closeSilently(is);
            XposedHelpers.closeSilently(zipFile);
        }
    }
}

