/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.ZygoteInit;
import dalvik.system.PathClassLoader;
import de.robv.android.xposed.DexCreator;
import de.robv.android.xposed.SELinuxHelper;
import de.robv.android.xposed.XC_MethodHook;
import de.robv.android.xposed.XposedHelpers;
import de.robv.android.xposed.XposedInit;
import de.robv.android.xposed.callbacks.XC_InitPackageResources;
import de.robv.android.xposed.callbacks.XC_LoadPackage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class XposedBridge {
    public static final ClassLoader BOOTCLASSLOADER = ClassLoader.getSystemClassLoader();
    public static final String TAG = "Xposed";
    @Deprecated
    public static int XPOSED_BRIDGE_VERSION;
    static boolean isZygote;
    private static int runtime;
    private static final int RUNTIME_DALVIK = 1;
    private static final int RUNTIME_ART = 2;
    static boolean disableHooks;
    static long BOOT_START_TIME;
    private static final Object[] EMPTY_ARRAY;
    private static final Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> sHookedMethodCallbacks;
    static final CopyOnWriteSortedSet<XC_LoadPackage> sLoadedPackageCallbacks;
    static final CopyOnWriteSortedSet<XC_InitPackageResources> sInitPackageResourcesCallbacks;

    private XposedBridge() {
    }

    protected static void main(String[] args) {
        try {
            if (!XposedBridge.hadInitErrors()) {
                XposedBridge.initXResources();
                SELinuxHelper.initOnce();
                SELinuxHelper.initForProcess(null);
                runtime = XposedBridge.getRuntime();
                XPOSED_BRIDGE_VERSION = XposedBridge.getXposedVersion();
                if (isZygote) {
                    XposedInit.hookResources();
                    XposedInit.initForZygote();
                }
                XposedInit.loadModules();
            } else {
                Log.e((String)TAG, (String)"Not initializing Xposed because of previous errors");
            }
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"Errors during Xposed initialization", (Throwable)t);
            disableHooks = true;
        }
        if (isZygote) {
            ZygoteInit.main((String[])args);
        } else {
            RuntimeInit.main((String[])args);
        }
    }

    private static void initXResources() throws IOException {
        Resources res = Resources.getSystem();
        File resDexFile = XposedBridge.ensureSuperDexFile("XResources", res.getClass(), Resources.class);
        Class taClass = TypedArray.class;
        try {
            TypedArray ta = res.obtainTypedArray(res.getIdentifier("preloaded_drawables", "array", "android"));
            taClass = ta.getClass();
            ta.recycle();
        }
        catch (Resources.NotFoundException nfe) {
            XposedBridge.log(nfe);
        }
        Runtime.getRuntime().gc();
        File taDexFile = XposedBridge.ensureSuperDexFile("XTypedArray", taClass, TypedArray.class);
        ClassLoader myCL = XposedBridge.class.getClassLoader();
        String paths = resDexFile.getAbsolutePath() + File.pathSeparator + taDexFile.getAbsolutePath();
        PathClassLoader dummyCL = new PathClassLoader(paths, myCL.getParent());
        XposedHelpers.setObjectField(myCL, "parent", dummyCL);
    }

    @SuppressLint(value={"SetWorldReadable"})
    private static File ensureSuperDexFile(String clz, Class<?> realSuperClz, Class<?> topClz) throws IOException {
        XposedBridge.removeFinalFlagNative(realSuperClz);
        File dexFile = DexCreator.ensure(clz, realSuperClz, topClz);
        dexFile.setReadable(true, false);
        return dexFile;
    }

    private static native boolean hadInitErrors();

    private static native int getRuntime();

    static native boolean startsSystemServer();

    static native String getStartClassName();

    static native boolean initXResourcesNative();

    public static native int getXposedVersion();

    public static synchronized void log(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        Log.i((String)TAG, (String)text);
    }

    public static synchronized void log(Throwable t) {
        Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)t));
    }

    public static XC_MethodHook.Unhook hookMethod(Member hookMethod, XC_MethodHook callback) {
        Class<?> exposedBridge = XposedHelpers.findClass("me.weishu.exposed.ExposedBridge", XposedBridge.class.getClassLoader());
        return (XC_MethodHook.Unhook)XposedHelpers.callStaticMethod(exposedBridge, "hookMethod", hookMethod, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void unhookMethod(Member hookMethod, XC_MethodHook callback) {
        CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> map = sHookedMethodCallbacks;
        synchronized (map) {
            callbacks = sHookedMethodCallbacks.get(hookMethod);
            if (callbacks == null) {
                return;
            }
        }
        callbacks.remove(callback);
    }

    public static Set<XC_MethodHook.Unhook> hookAllMethods(Class<?> hookClass, String methodName, XC_MethodHook callback) {
        HashSet<XC_MethodHook.Unhook> unhooks = new HashSet<XC_MethodHook.Unhook>();
        for (Method method : hookClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            unhooks.add(XposedBridge.hookMethod(method, callback));
        }
        return unhooks;
    }

    public static Set<XC_MethodHook.Unhook> hookAllConstructors(Class<?> hookClass, XC_MethodHook callback) {
        HashSet<XC_MethodHook.Unhook> unhooks = new HashSet<XC_MethodHook.Unhook>();
        for (Constructor<?> constructor : hookClass.getDeclaredConstructors()) {
            unhooks.add(XposedBridge.hookMethod(constructor, callback));
        }
        return unhooks;
    }

    private static Object handleHookedMethod(Member method, int originalMethodId, Object additionalInfoObj, Object thisObject, Object[] args) throws Throwable {
        AdditionalHookInfo additionalInfo = (AdditionalHookInfo)additionalInfoObj;
        if (disableHooks) {
            try {
                return XposedBridge.invokeOriginalMethodNative(method, originalMethodId, additionalInfo.parameterTypes, additionalInfo.returnType, thisObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        Object[] callbacksSnapshot = additionalInfo.callbacks.getSnapshot();
        int callbacksLength = callbacksSnapshot.length;
        if (callbacksLength == 0) {
            try {
                return XposedBridge.invokeOriginalMethodNative(method, originalMethodId, additionalInfo.parameterTypes, additionalInfo.returnType, thisObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        XC_MethodHook.MethodHookParam param = new XC_MethodHook.MethodHookParam();
        param.method = method;
        param.thisObject = thisObject;
        param.args = args;
        int beforeIdx = 0;
        do {
            try {
                ((XC_MethodHook)callbacksSnapshot[beforeIdx]).beforeHookedMethod(param);
            }
            catch (Throwable t) {
                XposedBridge.log(t);
                param.setResult(null);
                param.returnEarly = false;
                continue;
            }
            if (!param.returnEarly) continue;
            ++beforeIdx;
            break;
        } while (++beforeIdx < callbacksLength);
        if (!param.returnEarly) {
            try {
                param.setResult(XposedBridge.invokeOriginalMethodNative(method, originalMethodId, additionalInfo.parameterTypes, additionalInfo.returnType, param.thisObject, param.args));
            }
            catch (InvocationTargetException e) {
                param.setThrowable(e.getCause());
            }
        }
        int afterIdx = beforeIdx - 1;
        do {
            Object lastResult = param.getResult();
            Throwable lastThrowable = param.getThrowable();
            try {
                ((XC_MethodHook)callbacksSnapshot[afterIdx]).afterHookedMethod(param);
            }
            catch (Throwable t) {
                XposedBridge.log(t);
                if (lastThrowable == null) {
                    param.setResult(lastResult);
                    continue;
                }
                param.setThrowable(lastThrowable);
            }
        } while (--afterIdx >= 0);
        if (param.hasThrowable()) {
            throw param.getThrowable();
        }
        return param.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hookLoadPackage(XC_LoadPackage callback) {
        CopyOnWriteSortedSet<XC_LoadPackage> copyOnWriteSortedSet = sLoadedPackageCallbacks;
        synchronized (copyOnWriteSortedSet) {
            sLoadedPackageCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hookInitPackageResources(XC_InitPackageResources callback) {
        CopyOnWriteSortedSet<XC_InitPackageResources> copyOnWriteSortedSet = sInitPackageResourcesCallbacks;
        synchronized (copyOnWriteSortedSet) {
            sInitPackageResourcesCallbacks.add(callback);
        }
    }

    private static synchronized native void hookMethodNative(Member var0, Class<?> var1, int var2, Object var3);

    private static native Object invokeOriginalMethodNative(Member var0, int var1, Class<?>[] var2, Class<?> var3, Object var4, Object[] var5) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public static Object invokeOriginalMethod(Member method, Object thisObject, Object[] args) throws NullPointerException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        Class<?> exposedBridge = XposedHelpers.findClass("me.weishu.exposed.ExposedBridge", XposedBridge.class.getClassLoader());
        return XposedHelpers.callStaticMethod(exposedBridge, "invokeOriginalMethod", method, thisObject, args);
    }

    static void setObjectClass(Object obj, Class<?> clazz) {
        if (clazz.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Cannot transfer object from " + obj.getClass() + " to " + clazz);
        }
        XposedBridge.setObjectClassNative(obj, clazz);
    }

    private static native void setObjectClassNative(Object var0, Class<?> var1);

    static native void dumpObjectNative(Object var0);

    static Object cloneToSubclass(Object obj, Class<?> targetClazz) {
        if (obj == null) {
            return null;
        }
        if (!obj.getClass().isAssignableFrom(targetClazz)) {
            throw new ClassCastException(targetClazz + " doesn't extend " + obj.getClass());
        }
        return XposedBridge.cloneToSubclassNative(obj, targetClazz);
    }

    private static native Object cloneToSubclassNative(Object var0, Class<?> var1);

    private static native void removeFinalFlagNative(Class<?> var0);

    static native void closeFilesBeforeForkNative();

    static native void reopenFilesAfterForkNative();

    static native void invalidateCallersNative(Member[] var0);

    static /* synthetic */ Object[] access$000() {
        return EMPTY_ARRAY;
    }

    static {
        isZygote = true;
        runtime = 0;
        disableHooks = false;
        EMPTY_ARRAY = new Object[0];
        sHookedMethodCallbacks = new HashMap<Member, CopyOnWriteSortedSet<XC_MethodHook>>();
        sLoadedPackageCallbacks = new CopyOnWriteSortedSet();
        sInitPackageResourcesCallbacks = new CopyOnWriteSortedSet();
    }

    private static class AdditionalHookInfo {
        final CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        final Class<?>[] parameterTypes;
        final Class<?> returnType;

        private AdditionalHookInfo(CopyOnWriteSortedSet<XC_MethodHook> callbacks, Class<?>[] parameterTypes, Class<?> returnType) {
            this.callbacks = callbacks;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }
    }

    public static final class CopyOnWriteSortedSet<E> {
        private volatile transient Object[] elements = XposedBridge.access$000();

        public synchronized boolean add(E e) {
            int index = this.indexOf(e);
            if (index >= 0) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length + 1];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            newElements[this.elements.length] = e;
            Arrays.sort(newElements);
            this.elements = newElements;
            return true;
        }

        public synchronized boolean remove(E e) {
            int index = this.indexOf(e);
            if (index == -1) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length - 1];
            System.arraycopy(this.elements, 0, newElements, 0, index);
            System.arraycopy(this.elements, index + 1, newElements, index, this.elements.length - index - 1);
            this.elements = newElements;
            return true;
        }

        private int indexOf(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
            return -1;
        }

        public Object[] getSnapshot() {
            return this.elements;
        }
    }

    protected static final class ToolEntryPoint {
        protected ToolEntryPoint() {
        }

        protected static void main(String[] args) {
            isZygote = false;
            XposedBridge.main(args);
        }
    }
}

