/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed;

import android.os.SELinux;
import de.robv.android.xposed.services.BaseService;
import de.robv.android.xposed.services.BinderService;
import de.robv.android.xposed.services.DirectAccessService;
import de.robv.android.xposed.services.ZygoteService;

public final class SELinuxHelper {
    private static boolean sIsSELinuxEnabled = false;
    private static BaseService sServiceAppDataFile = null;

    private SELinuxHelper() {
    }

    public static boolean isSELinuxEnabled() {
        return sIsSELinuxEnabled;
    }

    public static boolean isSELinuxEnforced() {
        return sIsSELinuxEnabled && SELinux.isSELinuxEnforced();
    }

    public static String getContext() {
        return sIsSELinuxEnabled ? SELinux.getContext() : null;
    }

    public static BaseService getAppDataFileService() {
        if (sServiceAppDataFile != null) {
            return sServiceAppDataFile;
        }
        throw new UnsupportedOperationException();
    }

    static void initOnce() {
        try {
            sIsSELinuxEnabled = SELinux.isSELinuxEnabled();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static void initForProcess(String packageName) {
        sServiceAppDataFile = sIsSELinuxEnabled ? (packageName == null ? new ZygoteService() : (packageName.equals("android") ? BinderService.getService(0) : new DirectAccessService())) : new DirectAccessService();
    }
}

