/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed;

import android.os.Environment;
import de.robv.android.xposed.XposedHelpers;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;

class DexCreator {
    public static File DALVIK_CACHE = new File(Environment.getDataDirectory(), "dalvik-cache");

    public static File getDefaultFile(String childClz) {
        return new File(DALVIK_CACHE, "xposed_" + childClz.substring(childClz.lastIndexOf(46) + 1) + ".dex");
    }

    public static File ensure(String clz, Class<?> realSuperClz, Class<?> topClz) throws IOException {
        if (!topClz.isAssignableFrom(realSuperClz)) {
            throw new ClassCastException("Cannot initialize " + clz + " because " + realSuperClz + " does not extend " + topClz);
        }
        try {
            return DexCreator.ensure("xposed.dummy." + clz + "SuperClass", realSuperClz);
        }
        catch (IOException e) {
            throw new IOException("Failed to create a superclass for " + clz, e);
        }
    }

    public static File ensure(String childClz, Class<?> superClz) throws IOException {
        return DexCreator.ensure(DexCreator.getDefaultFile(childClz), childClz, superClz.getName());
    }

    public static File ensure(File file, String childClz, String superClz) throws IOException {
        byte[] dex;
        try {
            dex = XposedHelpers.inputStreamToByteArray(new FileInputStream(file));
            if (DexCreator.matches(dex, childClz, superClz)) {
                return file;
            }
            file.delete();
        }
        catch (IOException e) {
            file.delete();
        }
        dex = DexCreator.create(childClz, superClz);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(dex);
        fos.close();
        return file;
    }

    public static boolean matches(byte[] dex, String childClz, String superClz) throws IOException {
        byte[] superBytes;
        boolean childFirst = childClz.compareTo(superClz) < 0;
        int pos = 160;
        byte[] childBytes = DexCreator.stringToBytes("L" + childClz.replace('.', '/') + ";");
        if (pos + childBytes.length + (superBytes = DexCreator.stringToBytes("L" + superClz.replace('.', '/') + ";")).length >= dex.length) {
            return false;
        }
        for (byte b : childFirst ? childBytes : superBytes) {
            if (dex[pos++] == b) continue;
            return false;
        }
        for (byte b : childFirst ? superBytes : childBytes) {
            if (dex[pos++] == b) continue;
            return false;
        }
        return true;
    }

    public static byte[] create(String childClz, String superClz) throws IOException {
        boolean childFirst = childClz.compareTo(superClz) < 0;
        byte[] childBytes = DexCreator.stringToBytes("L" + childClz.replace('.', '/') + ";");
        byte[] superBytes = DexCreator.stringToBytes("L" + superClz.replace('.', '/') + ";");
        int stringsSize = childBytes.length + superBytes.length;
        int padding = -stringsSize & 3;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("dex\n035\u0000".getBytes());
        out.write(new byte[24]);
        DexCreator.writeInt(out, 252 + (stringsSize += padding));
        DexCreator.writeInt(out, 112);
        DexCreator.writeInt(out, 305419896);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 164 + stringsSize);
        DexCreator.writeInt(out, 2);
        DexCreator.writeInt(out, 112);
        DexCreator.writeInt(out, 2);
        DexCreator.writeInt(out, 120);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 1);
        DexCreator.writeInt(out, 128);
        DexCreator.writeInt(out, 92 + stringsSize);
        DexCreator.writeInt(out, 160);
        DexCreator.writeInt(out, 160);
        DexCreator.writeInt(out, 160 + (childFirst ? childBytes.length : superBytes.length));
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 1);
        DexCreator.writeInt(out, childFirst ? 0 : 1);
        DexCreator.writeInt(out, 1);
        DexCreator.writeInt(out, childFirst ? 1 : 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, -1);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 0);
        out.write(childFirst ? childBytes : superBytes);
        out.write(childFirst ? superBytes : childBytes);
        out.write(new byte[padding]);
        DexCreator.writeInt(out, 0);
        DexCreator.writeInt(out, 7);
        DexCreator.writeMapItem(out, 0, 1, 0);
        DexCreator.writeMapItem(out, 1, 2, 112);
        DexCreator.writeMapItem(out, 2, 2, 120);
        DexCreator.writeMapItem(out, 6, 1, 128);
        DexCreator.writeMapItem(out, 8194, 2, 160);
        DexCreator.writeMapItem(out, 4099, 1, 160 + stringsSize);
        DexCreator.writeMapItem(out, 4096, 1, 164 + stringsSize);
        byte[] buf = out.toByteArray();
        DexCreator.updateSignature(buf);
        DexCreator.updateChecksum(buf);
        return buf;
    }

    private static void updateSignature(byte[] dex) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(dex, 32, dex.length - 32);
            md.digest(dex, 12, 20);
        }
        catch (DigestException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void updateChecksum(byte[] dex) {
        Adler32 a32 = new Adler32();
        a32.update(dex, 12, dex.length - 12);
        int chksum = (int)a32.getValue();
        dex[8] = (byte)(chksum & 0xFF);
        dex[9] = (byte)(chksum >> 8 & 0xFF);
        dex[10] = (byte)(chksum >> 16 & 0xFF);
        dex[11] = (byte)(chksum >> 24 & 0xFF);
    }

    private static void writeUleb128(OutputStream out, int value) throws IOException {
        while (value > 127) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value);
    }

    private static void writeInt(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >> 8);
        out.write(value >> 16);
        out.write(value >> 24);
    }

    private static void writeMapItem(OutputStream out, int type, int count, int offset) throws IOException {
        DexCreator.writeInt(out, type);
        DexCreator.writeInt(out, count);
        DexCreator.writeInt(out, offset);
    }

    private static byte[] stringToBytes(String s) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DexCreator.writeUleb128(bytes, s.length());
        bytes.write(s.getBytes("UTF-8"));
        bytes.write(0);
        return bytes.toByteArray();
    }

    private DexCreator() {
    }
}

