/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.Context;
import android.content.pm.PackageParser;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XResForwarder;
import android.content.res.XmlResourceParser;
import android.graphics.Movie;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import de.robv.android.xposed.XC_MethodHook;
import de.robv.android.xposed.XposedBridge;
import de.robv.android.xposed.XposedHelpers;
import de.robv.android.xposed.callbacks.XC_LayoutInflated;
import de.robv.android.xposed.callbacks.XCallback;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import xposed.dummy.XResourcesSuperClass;
import xposed.dummy.XTypedArraySuperClass;

public class XResources
extends XResourcesSuperClass {
    private static final SparseArray<HashMap<String, Object>> sReplacements = new SparseArray();
    private static final SparseArray<HashMap<String, ResourceNames>> sResourceNames = new SparseArray();
    private static final byte[] sSystemReplacementsCache = new byte[256];
    private byte[] mReplacementsCache;
    private static final HashMap<String, byte[]> sReplacementsCacheMap = new HashMap();
    private static final SparseArray<ColorStateList> sColorStateListCache = new SparseArray(0);
    private static final SparseArray<HashMap<String, XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated>>> sLayoutCallbacks = new SparseArray();
    private static final WeakHashMap<XmlResourceParser, XMLInstanceDetails> sXmlInstanceDetails = new WeakHashMap();
    private static final String EXTRA_XML_INSTANCE_DETAILS = "xmlInstanceDetails";
    private static final ThreadLocal<LinkedList<XC_MethodHook.MethodHookParam>> sIncludedLayouts = new ThreadLocal<LinkedList<XC_MethodHook.MethodHookParam>>(){

        @Override
        protected LinkedList<XC_MethodHook.MethodHookParam> initialValue() {
            return new LinkedList<XC_MethodHook.MethodHookParam>();
        }
    };
    private static final HashMap<String, Long> sResDirLastModified = new HashMap();
    private static final HashMap<String, String> sResDirPackageNames = new HashMap();
    private static ThreadLocal<Object> sLatestResKey = null;
    private boolean mIsObjectInited;
    private String mResDir;
    private String mPackageName;

    private XResources() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initObject(String resDir) {
        if (this.mIsObjectInited) {
            throw new IllegalStateException("Object has already been initialized");
        }
        this.mResDir = resDir;
        this.mPackageName = XResources.getPackageName(resDir);
        if (resDir != null) {
            HashMap<String, byte[]> hashMap = sReplacementsCacheMap;
            synchronized (hashMap) {
                this.mReplacementsCache = sReplacementsCacheMap.get(resDir);
                if (this.mReplacementsCache == null) {
                    this.mReplacementsCache = new byte[128];
                    sReplacementsCacheMap.put(resDir, this.mReplacementsCache);
                }
            }
        }
        this.mIsObjectInited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstLoad() {
        SparseArray<HashMap<String, Object>> sparseArray = sReplacements;
        synchronized (sparseArray) {
            Long oldModified;
            if (this.mResDir == null) {
                return false;
            }
            Long lastModification = new File(this.mResDir).lastModified();
            if (lastModification.equals(oldModified = sResDirLastModified.get(this.mResDir))) {
                return false;
            }
            sResDirLastModified.put(this.mResDir, lastModification);
            if (oldModified == null) {
                return true;
            }
            for (int i = 0; i < sReplacements.size(); ++i) {
                ((HashMap)sReplacements.valueAt(i)).remove(this.mResDir);
            }
            Arrays.fill(this.mReplacementsCache, (byte)0);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPackageNameForResDir(String packageName, String resDir) {
        HashMap<String, String> hashMap = sResDirPackageNames;
        synchronized (hashMap) {
            sResDirPackageNames.put(resDir, packageName);
        }
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPackageName(String resDir) {
        PackageParser.PackageLite pkgInfo;
        String packageName;
        if (resDir == null) {
            return "android";
        }
        HashMap<String, String> hashMap = sResDirPackageNames;
        synchronized (hashMap) {
            packageName = sResDirPackageNames.get(resDir);
        }
        if (packageName != null) {
            return packageName;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                pkgInfo = PackageParser.parsePackageLite((File)new File(resDir), (int)0);
            }
            catch (PackageParser.PackageParserException e) {
                throw new IllegalStateException("Could not determine package name for " + resDir, e);
            }
        } else {
            pkgInfo = PackageParser.parsePackageLite((String)resDir, (int)0);
        }
        if (pkgInfo != null && pkgInfo.packageName != null) {
            Log.w((String)"Xposed", (String)("Package name for " + resDir + " had to be retrieved via parser"));
            packageName = pkgInfo.packageName;
            XResources.setPackageNameForResDir(packageName, resDir);
            return packageName;
        }
        throw new IllegalStateException("Could not determine package name for " + resDir);
    }

    public static String getPackageNameDuringConstruction() {
        Object key;
        if (sLatestResKey == null || (key = sLatestResKey.get()) == null) {
            throw new IllegalStateException("This method can only be called during getTopLevelResources()");
        }
        String resDir = (String)XposedHelpers.getObjectField(key, "mResDir");
        return XResources.getPackageName(resDir);
    }

    public static void init(ThreadLocal<Object> latestResKey) throws Exception {
        sLatestResKey = latestResKey;
        XposedHelpers.findAndHookMethod(LayoutInflater.class, "inflate", XmlPullParser.class, ViewGroup.class, Boolean.TYPE, new XC_MethodHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                XMLInstanceDetails details;
                if (param.hasThrowable()) {
                    return;
                }
                WeakHashMap weakHashMap = sXmlInstanceDetails;
                synchronized (weakHashMap) {
                    details = (XMLInstanceDetails)sXmlInstanceDetails.get(param.args[0]);
                }
                if (details != null) {
                    XC_LayoutInflated.LayoutInflatedParam liparam = new XC_LayoutInflated.LayoutInflatedParam(details.callbacks);
                    liparam.view = (View)param.getResult();
                    liparam.resNames = details.resNames;
                    liparam.variant = details.variant;
                    liparam.res = details.res;
                    XCallback.callAll(liparam);
                }
            }
        });
        XC_MethodHook parseIncludeHook = new XC_MethodHook(){

            @Override
            protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                ((LinkedList)sIncludedLayouts.get()).push(param);
            }

            @Override
            protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
                ((LinkedList)sIncludedLayouts.get()).pop();
                if (param.hasThrowable()) {
                    return;
                }
                XMLInstanceDetails details = (XMLInstanceDetails)param.getObjectExtra(XResources.EXTRA_XML_INSTANCE_DETAILS);
                if (details != null) {
                    XC_LayoutInflated.LayoutInflatedParam liparam = new XC_LayoutInflated.LayoutInflatedParam(details.callbacks);
                    ViewGroup group = (ViewGroup)param.args[Build.VERSION.SDK_INT < 23 ? 1 : 2];
                    liparam.view = group.getChildAt(group.getChildCount() - 1);
                    liparam.resNames = details.resNames;
                    liparam.variant = details.variant;
                    liparam.res = details.res;
                    XCallback.callAll(liparam);
                }
            }
        };
        if (Build.VERSION.SDK_INT < 21) {
            XposedHelpers.findAndHookMethod(LayoutInflater.class, "parseInclude", XmlPullParser.class, View.class, AttributeSet.class, parseIncludeHook);
        } else if (Build.VERSION.SDK_INT < 23) {
            XposedHelpers.findAndHookMethod(LayoutInflater.class, "parseInclude", XmlPullParser.class, View.class, AttributeSet.class, Boolean.TYPE, parseIncludeHook);
        } else {
            XposedHelpers.findAndHookMethod(LayoutInflater.class, "parseInclude", XmlPullParser.class, Context.class, View.class, AttributeSet.class, parseIncludeHook);
        }
    }

    private ResourceNames getResourceNames(int id) {
        return new ResourceNames(id, this.getResourcePackageName(id), this.getResourceTypeName(id), this.getResourceEntryName(id));
    }

    private static ResourceNames getSystemResourceNames(int id) {
        Resources sysRes = XResources.getSystem();
        return new ResourceNames(id, sysRes.getResourcePackageName(id), sysRes.getResourceTypeName(id), sysRes.getResourceEntryName(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putResourceNames(String resDir, ResourceNames resNames) {
        int id = resNames.id;
        SparseArray<HashMap<String, ResourceNames>> sparseArray = sResourceNames;
        synchronized (sparseArray) {
            HashMap<String, ResourceNames> inner = (HashMap<String, ResourceNames>)sResourceNames.get(id);
            if (inner == null) {
                inner = new HashMap<String, ResourceNames>();
                sResourceNames.put(id, inner);
            }
            HashMap<String, ResourceNames> hashMap = inner;
            synchronized (hashMap) {
                inner.put(resDir, resNames);
            }
        }
    }

    public void setReplacement(int id, Object replacement) {
        XResources.setReplacement(id, replacement, this);
    }

    @Deprecated
    public void setReplacement(String fullName, Object replacement) {
        int id = this.getIdentifier(fullName, null, null);
        if (id == 0) {
            throw new Resources.NotFoundException(fullName);
        }
        XResources.setReplacement(id, replacement, this);
    }

    public void setReplacement(String pkg, String type, String name, Object replacement) {
        int id = this.getIdentifier(name, type, pkg);
        if (id == 0) {
            throw new Resources.NotFoundException(pkg + ":" + type + "/" + name);
        }
        XResources.setReplacement(id, replacement, this);
    }

    public static void setSystemWideReplacement(int id, Object replacement) {
        XResources.setReplacement(id, replacement, null);
    }

    @Deprecated
    public static void setSystemWideReplacement(String fullName, Object replacement) {
        int id = XResources.getSystem().getIdentifier(fullName, null, null);
        if (id == 0) {
            throw new Resources.NotFoundException(fullName);
        }
        XResources.setReplacement(id, replacement, null);
    }

    public static void setSystemWideReplacement(String pkg, String type, String name, Object replacement) {
        int id = XResources.getSystem().getIdentifier(name, type, pkg);
        if (id == 0) {
            throw new Resources.NotFoundException(pkg + ":" + type + "/" + name);
        }
        XResources.setReplacement(id, replacement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setReplacement(int id, Object replacement, XResources res) {
        byte[] byArray;
        int cacheKey;
        String resDir;
        String string = resDir = res != null ? res.mResDir : null;
        if (id == 0) {
            throw new IllegalArgumentException("id 0 is not an allowed resource identifier");
        }
        if (resDir == null && id >= 0x7F000000) {
            throw new IllegalArgumentException("ids >= 0x7f000000 are app specific and cannot be set for the framework");
        }
        if (replacement instanceof Drawable) {
            throw new IllegalArgumentException("Drawable replacements are deprecated since Xposed 2.1. Use DrawableLoader instead.");
        }
        if (id < 0x7F000000) {
            cacheKey = (id & 0x70000) >> 11 | (id & 0xF8) >> 3;
            byArray = sSystemReplacementsCache;
            synchronized (sSystemReplacementsCache) {
                int n = cacheKey;
                sSystemReplacementsCache[n] = (byte)(sSystemReplacementsCache[n] | 1 << (id & 7));
                // ** MonitorExit[var5_6] (shouldn't be in output)
            }
        }
        cacheKey = (id & 0x70000) >> 12 | (id & 0x78) >> 3;
        byArray = res.mReplacementsCache;
        synchronized (res.mReplacementsCache) {
            int n = cacheKey;
            res.mReplacementsCache[n] = (byte)(res.mReplacementsCache[n] | 1 << (id & 7));
            // ** MonitorExit[var5_6] (shouldn't be in output)
            {
                SparseArray<HashMap<String, Object>> sparseArray = sReplacements;
                synchronized (sparseArray) {
                    HashMap<String, Object> inner = (HashMap<String, Object>)sReplacements.get(id);
                    if (inner == null) {
                        inner = new HashMap<String, Object>();
                        sReplacements.put(id, inner);
                    }
                    inner.put(resDir, replacement);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getReplacement(int id) {
        HashMap inner;
        int cacheKey;
        if (id <= 0) {
            return null;
        }
        if (id < 0x7F000000 ? (sSystemReplacementsCache[cacheKey = (id & 0x70000) >> 11 | (id & 0xF8) >> 3] & 1 << (id & 7)) == 0 : this.mResDir != null && (this.mReplacementsCache[cacheKey = (id & 0x70000) >> 12 | (id & 0x78) >> 3] & 1 << (id & 7)) == 0) {
            return null;
        }
        Object object = sReplacements;
        synchronized (object) {
            inner = (HashMap)sReplacements.get(id);
        }
        if (inner == null) {
            return null;
        }
        object = inner;
        synchronized (object) {
            Object result = inner.get(this.mResDir);
            if (result != null || this.mResDir == null) {
                return result;
            }
            return inner.get(null);
        }
    }

    public XmlResourceParser getAnimation(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            boolean loadedFromCache = XResources.isXmlCached(repRes, repId);
            XmlResourceParser result = repRes.getAnimation(repId);
            if (!loadedFromCache) {
                long parseState = Build.VERSION.SDK_INT >= 21 ? XposedHelpers.getLongField(result, "mParseState") : (long)XposedHelpers.getIntField(result, "mParseState");
                XResources.rewriteXmlReferencesNative(parseState, this, repRes);
            }
            return result;
        }
        return super.getAnimation(id);
    }

    public boolean getBoolean(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof Boolean) {
            return (Boolean)replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getBoolean(repId);
        }
        return super.getBoolean(id);
    }

    public int getColor(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof Integer) {
            return (Integer)replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getColor(repId);
        }
        return super.getColor(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getColorStateList(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof ColorStateList) {
            return (ColorStateList)replacement;
        }
        if (replacement instanceof Integer) {
            int color = (Integer)replacement;
            SparseArray<ColorStateList> sparseArray = sColorStateListCache;
            synchronized (sparseArray) {
                ColorStateList result = (ColorStateList)sColorStateListCache.get(color);
                if (result == null) {
                    result = ColorStateList.valueOf((int)color);
                    sColorStateListCache.put(color, (Object)result);
                }
                return result;
            }
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getColorStateList(repId);
        }
        return super.getColorStateList(id);
    }

    public float getDimension(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof DimensionReplacement) {
            return ((DimensionReplacement)replacement).getDimension(this.getDisplayMetrics());
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getDimension(repId);
        }
        return super.getDimension(id);
    }

    public int getDimensionPixelOffset(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof DimensionReplacement) {
            return ((DimensionReplacement)replacement).getDimensionPixelOffset(this.getDisplayMetrics());
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getDimensionPixelOffset(repId);
        }
        return super.getDimensionPixelOffset(id);
    }

    public int getDimensionPixelSize(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof DimensionReplacement) {
            return ((DimensionReplacement)replacement).getDimensionPixelSize(this.getDisplayMetrics());
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getDimensionPixelSize(repId);
        }
        return super.getDimensionPixelSize(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawable(int id) throws Resources.NotFoundException {
        try {
            if (XposedHelpers.incrementMethodDepth("getDrawable") == 1) {
                Object replacement = this.getReplacement(id);
                if (replacement instanceof DrawableLoader) {
                    try {
                        Drawable result = ((DrawableLoader)replacement).newDrawable(this, id);
                        if (result != null) {
                            Drawable drawable = result;
                            return drawable;
                        }
                    }
                    catch (Throwable t) {
                        XposedBridge.log(t);
                    }
                } else {
                    if (replacement instanceof Integer) {
                        ColorDrawable t = new ColorDrawable(((Integer)replacement).intValue());
                        return t;
                    }
                    if (replacement instanceof XResForwarder) {
                        Resources repRes = ((XResForwarder)replacement).getResources();
                        int repId = ((XResForwarder)replacement).getId();
                        Drawable drawable = repRes.getDrawable(repId);
                        return drawable;
                    }
                }
            }
            Drawable drawable = super.getDrawable(id);
            return drawable;
        }
        finally {
            XposedHelpers.decrementMethodDepth("getDrawable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawable(int id, Resources.Theme theme) throws Resources.NotFoundException {
        try {
            if (XposedHelpers.incrementMethodDepth("getDrawable") == 1) {
                Object replacement = this.getReplacement(id);
                if (replacement instanceof DrawableLoader) {
                    try {
                        Drawable result = ((DrawableLoader)replacement).newDrawable(this, id);
                        if (result != null) {
                            Drawable drawable = result;
                            return drawable;
                        }
                    }
                    catch (Throwable t) {
                        XposedBridge.log(t);
                    }
                } else {
                    if (replacement instanceof Integer) {
                        ColorDrawable t = new ColorDrawable(((Integer)replacement).intValue());
                        return t;
                    }
                    if (replacement instanceof XResForwarder) {
                        Resources repRes = ((XResForwarder)replacement).getResources();
                        int repId = ((XResForwarder)replacement).getId();
                        Drawable drawable = repRes.getDrawable(repId);
                        return drawable;
                    }
                }
            }
            Drawable drawable = super.getDrawable(id, theme);
            return drawable;
        }
        finally {
            XposedHelpers.decrementMethodDepth("getDrawable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawable(int id, Resources.Theme theme, boolean supportComposedIcons) throws Resources.NotFoundException {
        try {
            if (XposedHelpers.incrementMethodDepth("getDrawable") == 1) {
                Object replacement = this.getReplacement(id);
                if (replacement instanceof DrawableLoader) {
                    try {
                        Drawable result = ((DrawableLoader)replacement).newDrawable(this, id);
                        if (result != null) {
                            Drawable drawable = result;
                            return drawable;
                        }
                    }
                    catch (Throwable t) {
                        XposedBridge.log(t);
                    }
                } else {
                    if (replacement instanceof Integer) {
                        ColorDrawable t = new ColorDrawable(((Integer)replacement).intValue());
                        return t;
                    }
                    if (replacement instanceof XResForwarder) {
                        Resources repRes = ((XResForwarder)replacement).getResources();
                        int repId = ((XResForwarder)replacement).getId();
                        Drawable drawable = repRes.getDrawable(repId);
                        return drawable;
                    }
                }
            }
            Drawable drawable = super.getDrawable(id, theme, supportComposedIcons);
            return drawable;
        }
        finally {
            XposedHelpers.decrementMethodDepth("getDrawable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawableForDensity(int id, int density) throws Resources.NotFoundException {
        try {
            if (XposedHelpers.incrementMethodDepth("getDrawableForDensity") == 1) {
                Object replacement = this.getReplacement(id);
                if (replacement instanceof DrawableLoader) {
                    try {
                        Drawable result = ((DrawableLoader)replacement).newDrawableForDensity(this, id, density);
                        if (result != null) {
                            Drawable drawable = result;
                            return drawable;
                        }
                    }
                    catch (Throwable t) {
                        XposedBridge.log(t);
                    }
                } else {
                    if (replacement instanceof Integer) {
                        ColorDrawable t = new ColorDrawable(((Integer)replacement).intValue());
                        return t;
                    }
                    if (replacement instanceof XResForwarder) {
                        Resources repRes = ((XResForwarder)replacement).getResources();
                        int repId = ((XResForwarder)replacement).getId();
                        Drawable drawable = repRes.getDrawableForDensity(repId, density);
                        return drawable;
                    }
                }
            }
            Drawable drawable = super.getDrawableForDensity(id, density);
            return drawable;
        }
        finally {
            XposedHelpers.decrementMethodDepth("getDrawableForDensity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawableForDensity(int id, int density, Resources.Theme theme) throws Resources.NotFoundException {
        try {
            if (XposedHelpers.incrementMethodDepth("getDrawableForDensity") == 1) {
                Object replacement = this.getReplacement(id);
                if (replacement instanceof DrawableLoader) {
                    try {
                        Drawable result = ((DrawableLoader)replacement).newDrawableForDensity(this, id, density);
                        if (result != null) {
                            Drawable drawable = result;
                            return drawable;
                        }
                    }
                    catch (Throwable t) {
                        XposedBridge.log(t);
                    }
                } else {
                    if (replacement instanceof Integer) {
                        ColorDrawable t = new ColorDrawable(((Integer)replacement).intValue());
                        return t;
                    }
                    if (replacement instanceof XResForwarder) {
                        Resources repRes = ((XResForwarder)replacement).getResources();
                        int repId = ((XResForwarder)replacement).getId();
                        Drawable drawable = repRes.getDrawableForDensity(repId, density);
                        return drawable;
                    }
                }
            }
            Drawable drawable = super.getDrawableForDensity(id, density, theme);
            return drawable;
        }
        finally {
            XposedHelpers.decrementMethodDepth("getDrawableForDensity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawableForDensity(int id, int density, Resources.Theme theme, boolean supportComposedIcons) throws Resources.NotFoundException {
        try {
            if (XposedHelpers.incrementMethodDepth("getDrawableForDensity") == 1) {
                Object replacement = this.getReplacement(id);
                if (replacement instanceof DrawableLoader) {
                    try {
                        Drawable result = ((DrawableLoader)replacement).newDrawableForDensity(this, id, density);
                        if (result != null) {
                            Drawable drawable = result;
                            return drawable;
                        }
                    }
                    catch (Throwable t) {
                        XposedBridge.log(t);
                    }
                } else {
                    if (replacement instanceof Integer) {
                        ColorDrawable t = new ColorDrawable(((Integer)replacement).intValue());
                        return t;
                    }
                    if (replacement instanceof XResForwarder) {
                        Resources repRes = ((XResForwarder)replacement).getResources();
                        int repId = ((XResForwarder)replacement).getId();
                        Drawable drawable = repRes.getDrawableForDensity(repId, density);
                        return drawable;
                    }
                }
            }
            Drawable drawable = super.getDrawableForDensity(id, density, theme, supportComposedIcons);
            return drawable;
        }
        finally {
            XposedHelpers.decrementMethodDepth("getDrawableForDensity");
        }
    }

    public float getFraction(int id, int base, int pbase) {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getFraction(repId, base, pbase);
        }
        return super.getFraction(id, base, pbase);
    }

    public int getInteger(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof Integer) {
            return (Integer)replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getInteger(repId);
        }
        return super.getInteger(id);
    }

    public int[] getIntArray(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof int[]) {
            return (int[])replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getIntArray(repId);
        }
        return super.getIntArray(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlResourceParser getLayout(int id) throws Resources.NotFoundException {
        HashMap inner;
        XmlResourceParser result;
        Object replacement = this.getReplacement(id);
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            boolean loadedFromCache = XResources.isXmlCached(repRes, repId);
            result = repRes.getLayout(repId);
            if (!loadedFromCache) {
                long parseState = Build.VERSION.SDK_INT >= 21 ? XposedHelpers.getLongField(result, "mParseState") : (long)XposedHelpers.getIntField(result, "mParseState");
                XResources.rewriteXmlReferencesNative(parseState, this, repRes);
            }
        } else {
            result = super.getLayout(id);
        }
        SparseArray<HashMap<String, XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated>>> repId = sLayoutCallbacks;
        synchronized (repId) {
            inner = (HashMap)sLayoutCallbacks.get(id);
        }
        if (inner != null) {
            XposedBridge.CopyOnWriteSortedSet callbacks;
            HashMap loadedFromCache = inner;
            synchronized (loadedFromCache) {
                callbacks = (XposedBridge.CopyOnWriteSortedSet)inner.get(this.mResDir);
                if (callbacks == null && this.mResDir != null) {
                    callbacks = (XposedBridge.CopyOnWriteSortedSet)inner.get(null);
                }
            }
            if (callbacks != null) {
                String variant = "layout";
                TypedValue value = (TypedValue)XposedHelpers.getObjectField((Object)this, "mTmpValue");
                this.getValue(id, value, true);
                if (value.type == 3) {
                    String[] components = value.string.toString().split("/", 3);
                    if (components.length == 3) {
                        variant = components[1];
                    } else {
                        XposedBridge.log("Unexpected resource path \"" + value.string.toString() + "\" for resource id 0x" + Integer.toHexString(id));
                    }
                } else {
                    XposedBridge.log(new Resources.NotFoundException("Could not find file name for resource id 0x") + Integer.toHexString(id));
                }
                WeakHashMap<XmlResourceParser, XMLInstanceDetails> weakHashMap = sXmlInstanceDetails;
                synchronized (weakHashMap) {
                    SparseArray<HashMap<String, ResourceNames>> sparseArray = sResourceNames;
                    synchronized (sparseArray) {
                        HashMap resNamesInner = (HashMap)sResourceNames.get(id);
                        if (resNamesInner != null) {
                            HashMap hashMap = resNamesInner;
                            synchronized (hashMap) {
                                XMLInstanceDetails details = new XMLInstanceDetails((ResourceNames)resNamesInner.get(this.mResDir), variant, callbacks);
                                sXmlInstanceDetails.put(result, details);
                                XC_MethodHook.MethodHookParam top = sIncludedLayouts.get().peek();
                                if (top != null) {
                                    top.setObjectExtra(EXTRA_XML_INSTANCE_DETAILS, details);
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public Movie getMovie(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getMovie(repId);
        }
        return super.getMovie(id);
    }

    public CharSequence getQuantityText(int id, int quantity) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getQuantityText(repId, quantity);
        }
        return super.getQuantityText(id, quantity);
    }

    public String[] getStringArray(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof String[]) {
            return (String[])replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getStringArray(repId);
        }
        return super.getStringArray(id);
    }

    public CharSequence getText(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof CharSequence) {
            return (CharSequence)replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getText(repId);
        }
        return super.getText(id);
    }

    public CharSequence getText(int id, CharSequence def) {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof CharSequence) {
            return (CharSequence)replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getText(repId, def);
        }
        return super.getText(id, def);
    }

    public CharSequence[] getTextArray(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof CharSequence[]) {
            return (CharSequence[])replacement;
        }
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            return repRes.getTextArray(repId);
        }
        return super.getTextArray(id);
    }

    public XmlResourceParser getXml(int id) throws Resources.NotFoundException {
        Object replacement = this.getReplacement(id);
        if (replacement instanceof XResForwarder) {
            Resources repRes = ((XResForwarder)replacement).getResources();
            int repId = ((XResForwarder)replacement).getId();
            boolean loadedFromCache = XResources.isXmlCached(repRes, repId);
            XmlResourceParser result = repRes.getXml(repId);
            if (!loadedFromCache) {
                long parseState = Build.VERSION.SDK_INT >= 21 ? XposedHelpers.getLongField(result, "mParseState") : (long)XposedHelpers.getIntField(result, "mParseState");
                XResources.rewriteXmlReferencesNative(parseState, this, repRes);
            }
            return result;
        }
        return super.getXml(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXmlCached(Resources res, int id) {
        int[] mCachedXmlBlockIds;
        int[] nArray = mCachedXmlBlockIds = (int[])XposedHelpers.getObjectField(res, "mCachedXmlBlockIds");
        synchronized (mCachedXmlBlockIds) {
            for (int cachedId : mCachedXmlBlockIds) {
                if (cachedId != id) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    private static native void rewriteXmlReferencesNative(long var0, XResources var2, Resources var3);

    private static int translateResId(int id, XResources origRes, Resources repRes) {
        try {
            String entryName = repRes.getResourceEntryName(id);
            String entryType = repRes.getResourceTypeName(id);
            String origPackage = origRes.mPackageName;
            int origResId = 0;
            try {
                origResId = origRes.getIdentifier(entryName, entryType, origPackage);
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
            boolean repResDefined = false;
            try {
                TypedValue tmpValue = new TypedValue();
                repRes.getValue(id, tmpValue, false);
                repResDefined = tmpValue.type != 18 || tmpValue.data != 0;
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
            if (!repResDefined && origResId == 0 && !entryType.equals("id")) {
                XposedBridge.log(entryType + "/" + entryName + " is neither defined in module nor in original resources");
                return 0;
            }
            if (origResId == 0) {
                origResId = XResources.getFakeResId(repRes, id);
            }
            if (repResDefined && !entryType.equals("id")) {
                origRes.setReplacement(origResId, (Object)new XResForwarder(repRes, id));
            }
            return origResId;
        }
        catch (Exception e) {
            XposedBridge.log(e);
            return id;
        }
    }

    public static int getFakeResId(String resName) {
        return 0x7E000000 | resName.hashCode() & 0xFFFFFF;
    }

    public static int getFakeResId(Resources res, int id) {
        return XResources.getFakeResId(res.getResourceName(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addResource(Resources res, int id) {
        int fakeId = XResources.getFakeResId(res, id);
        SparseArray<HashMap<String, Object>> sparseArray = sReplacements;
        synchronized (sparseArray) {
            if (sReplacements.indexOfKey(fakeId) < 0) {
                this.setReplacement(fakeId, (Object)new XResForwarder(res, id));
            }
        }
        return fakeId;
    }

    private static int translateAttrId(String attrName, XResources origRes) {
        String origPackage = origRes.mPackageName;
        int origAttrId = 0;
        try {
            origAttrId = origRes.getIdentifier(attrName, "attr", origPackage);
        }
        catch (Resources.NotFoundException e) {
            XposedBridge.log("Attribute " + attrName + " not found in original resources");
        }
        return origAttrId;
    }

    public XC_LayoutInflated.Unhook hookLayout(int id, XC_LayoutInflated callback) {
        return XResources.hookLayoutInternal(this.mResDir, id, this.getResourceNames(id), callback);
    }

    @Deprecated
    public XC_LayoutInflated.Unhook hookLayout(String fullName, XC_LayoutInflated callback) {
        int id = this.getIdentifier(fullName, null, null);
        if (id == 0) {
            throw new Resources.NotFoundException(fullName);
        }
        return this.hookLayout(id, callback);
    }

    public XC_LayoutInflated.Unhook hookLayout(String pkg, String type, String name, XC_LayoutInflated callback) {
        int id = this.getIdentifier(name, type, pkg);
        if (id == 0) {
            throw new Resources.NotFoundException(pkg + ":" + type + "/" + name);
        }
        return this.hookLayout(id, callback);
    }

    public static XC_LayoutInflated.Unhook hookSystemWideLayout(int id, XC_LayoutInflated callback) {
        if (id >= 0x7F000000) {
            throw new IllegalArgumentException("ids >= 0x7f000000 are app specific and cannot be set for the framework");
        }
        return XResources.hookLayoutInternal(null, id, XResources.getSystemResourceNames(id), callback);
    }

    @Deprecated
    public static XC_LayoutInflated.Unhook hookSystemWideLayout(String fullName, XC_LayoutInflated callback) {
        int id = XResources.getSystem().getIdentifier(fullName, null, null);
        if (id == 0) {
            throw new Resources.NotFoundException(fullName);
        }
        return XResources.hookSystemWideLayout(id, callback);
    }

    public static XC_LayoutInflated.Unhook hookSystemWideLayout(String pkg, String type, String name, XC_LayoutInflated callback) {
        int id = XResources.getSystem().getIdentifier(name, type, pkg);
        if (id == 0) {
            throw new Resources.NotFoundException(pkg + ":" + type + "/" + name);
        }
        return XResources.hookSystemWideLayout(id, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XC_LayoutInflated.Unhook hookLayoutInternal(String resDir, int id, ResourceNames resNames, XC_LayoutInflated callback) {
        XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated> callbacks;
        HashMap inner;
        if (id == 0) {
            throw new IllegalArgumentException("id 0 is not an allowed resource identifier");
        }
        SparseArray<HashMap<String, XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated>>> sparseArray = sLayoutCallbacks;
        synchronized (sparseArray) {
            inner = (HashMap)sLayoutCallbacks.get(id);
            if (inner == null) {
                inner = new HashMap();
                sLayoutCallbacks.put(id, inner);
            }
        }
        HashMap hashMap = inner;
        synchronized (hashMap) {
            callbacks = (XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated>)inner.get(resDir);
            if (callbacks == null) {
                callbacks = new XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated>();
                inner.put(resDir, callbacks);
            }
        }
        callbacks.add(callback);
        XResources.putResourceNames(resDir, resNames);
        XC_LayoutInflated xC_LayoutInflated = callback;
        xC_LayoutInflated.getClass();
        return new XC_LayoutInflated.Unhook(xC_LayoutInflated, resDir, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unhookLayout(String resDir, int id, XC_LayoutInflated callback) {
        XposedBridge.CopyOnWriteSortedSet callbacks;
        HashMap inner;
        SparseArray<HashMap<String, XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated>>> sparseArray = sLayoutCallbacks;
        synchronized (sparseArray) {
            inner = (HashMap)sLayoutCallbacks.get(id);
            if (inner == null) {
                return;
            }
        }
        HashMap hashMap = inner;
        synchronized (hashMap) {
            callbacks = (XposedBridge.CopyOnWriteSortedSet)inner.get(resDir);
            if (callbacks == null) {
                return;
            }
        }
        callbacks.remove(callback);
    }

    private class XMLInstanceDetails {
        public final ResourceNames resNames;
        public final String variant;
        public final XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated> callbacks;
        public final XResources res;

        private XMLInstanceDetails(ResourceNames resNames, String variant, XposedBridge.CopyOnWriteSortedSet<XC_LayoutInflated> callbacks) {
            this.res = XResources.this;
            this.resNames = resNames;
            this.variant = variant;
            this.callbacks = callbacks;
        }
    }

    public static class DimensionReplacement {
        private final float mValue;
        private final int mUnit;

        public DimensionReplacement(float value, int unit) {
            this.mValue = value;
            this.mUnit = unit;
        }

        public float getDimension(DisplayMetrics metrics) {
            return TypedValue.applyDimension((int)this.mUnit, (float)this.mValue, (DisplayMetrics)metrics);
        }

        public int getDimensionPixelOffset(DisplayMetrics metrics) {
            return (int)TypedValue.applyDimension((int)this.mUnit, (float)this.mValue, (DisplayMetrics)metrics);
        }

        public int getDimensionPixelSize(DisplayMetrics metrics) {
            float f = TypedValue.applyDimension((int)this.mUnit, (float)this.mValue, (DisplayMetrics)metrics);
            int res = (int)(f + 0.5f);
            if (res != 0) {
                return res;
            }
            if (this.mValue == 0.0f) {
                return 0;
            }
            if (this.mValue > 0.0f) {
                return 1;
            }
            return -1;
        }
    }

    public static abstract class DrawableLoader {
        public abstract Drawable newDrawable(XResources var1, int var2) throws Throwable;

        public Drawable newDrawableForDensity(XResources res, int id, int density) throws Throwable {
            return this.newDrawable(res, id);
        }
    }

    public static class XTypedArray
    extends XTypedArraySuperClass {
        private XTypedArray() {
            super(null, null, null, 0);
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean(int index, boolean defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof Boolean) {
                return (Boolean)replacement;
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getBoolean(repId);
            }
            return super.getBoolean(index, defValue);
        }

        public int getColor(int index, int defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof Integer) {
                return (Integer)replacement;
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getColor(repId);
            }
            return super.getColor(index, defValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColorStateList getColorStateList(int index) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof ColorStateList) {
                return (ColorStateList)replacement;
            }
            if (replacement instanceof Integer) {
                int color = (Integer)replacement;
                SparseArray sparseArray = sColorStateListCache;
                synchronized (sparseArray) {
                    ColorStateList result = (ColorStateList)sColorStateListCache.get(color);
                    if (result == null) {
                        result = ColorStateList.valueOf((int)color);
                        sColorStateListCache.put(color, (Object)result);
                    }
                    return result;
                }
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getColorStateList(repId);
            }
            return super.getColorStateList(index);
        }

        public float getDimension(int index, float defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getDimension(repId);
            }
            return super.getDimension(index, defValue);
        }

        public int getDimensionPixelOffset(int index, int defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getDimensionPixelOffset(repId);
            }
            return super.getDimensionPixelOffset(index, defValue);
        }

        public int getDimensionPixelSize(int index, int defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getDimensionPixelSize(repId);
            }
            return super.getDimensionPixelSize(index, defValue);
        }

        public Drawable getDrawable(int index) {
            int resId = this.getResourceId(index, 0);
            XResources xres = (XResources)this.getResources();
            Object replacement = xres.getReplacement(resId);
            if (replacement instanceof DrawableLoader) {
                try {
                    Drawable result = ((DrawableLoader)replacement).newDrawable(xres, resId);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Throwable t) {
                    XposedBridge.log(t);
                }
            } else {
                if (replacement instanceof Integer) {
                    return new ColorDrawable(((Integer)replacement).intValue());
                }
                if (replacement instanceof XResForwarder) {
                    Resources repRes = ((XResForwarder)replacement).getResources();
                    int repId = ((XResForwarder)replacement).getId();
                    return repRes.getDrawable(repId);
                }
            }
            return super.getDrawable(index);
        }

        public float getFloat(int index, float defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getDimension(repId);
            }
            return super.getFloat(index, defValue);
        }

        public float getFraction(int index, int base, int pbase, float defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getFraction(repId, base, pbase);
            }
            return super.getFraction(index, base, pbase, defValue);
        }

        public int getInt(int index, int defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof Integer) {
                return (Integer)replacement;
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getInteger(repId);
            }
            return super.getInt(index, defValue);
        }

        public int getInteger(int index, int defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof Integer) {
                return (Integer)replacement;
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getInteger(repId);
            }
            return super.getInteger(index, defValue);
        }

        public int getLayoutDimension(int index, int defValue) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getDimensionPixelSize(repId);
            }
            return super.getLayoutDimension(index, defValue);
        }

        public int getLayoutDimension(int index, String name) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getDimensionPixelSize(repId);
            }
            return super.getLayoutDimension(index, name);
        }

        public String getString(int index) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof CharSequence) {
                return replacement.toString();
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getString(repId);
            }
            return super.getString(index);
        }

        public CharSequence getText(int index) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof CharSequence) {
                return (CharSequence)replacement;
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getText(repId);
            }
            return super.getText(index);
        }

        public CharSequence[] getTextArray(int index) {
            Object replacement = ((XResources)this.getResources()).getReplacement(this.getResourceId(index, 0));
            if (replacement instanceof CharSequence[]) {
                return (CharSequence[])replacement;
            }
            if (replacement instanceof XResForwarder) {
                Resources repRes = ((XResForwarder)replacement).getResources();
                int repId = ((XResForwarder)replacement).getId();
                return repRes.getTextArray(repId);
            }
            return super.getTextArray(index);
        }
    }

    public static class ResourceNames {
        public final int id;
        public final String pkg;
        public final String name;
        public final String type;
        public final String fullName;

        private ResourceNames(int id, String pkg, String name, String type) {
            this.id = id;
            this.pkg = pkg;
            this.name = name;
            this.type = type;
            this.fullName = pkg + ":" + type + "/" + name;
        }

        public boolean equals(String pkg, String name, String type, int id) {
            return !(pkg != null && !pkg.equals(this.pkg) || name != null && !name.equals(this.name) || type != null && !type.equals(this.type) || id != 0 && id != this.id);
        }
    }
}

