/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.Application;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.IBinder;
import de.robv.android.xposed.XSharedPreferences;
import de.robv.android.xposed.XposedBridge;
import de.robv.android.xposed.XposedHelpers;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class AndroidAppHelper {
    private static final Class<?> CLASS_RESOURCES_KEY = Build.VERSION.SDK_INT < 19 ? XposedHelpers.findClass("android.app.ActivityThread$ResourcesKey", null) : XposedHelpers.findClass("android.content.res.ResourcesKey", null);
    private static final boolean HAS_IS_THEMEABLE = XposedHelpers.findFieldIfExists(CLASS_RESOURCES_KEY, "mIsThemeable") != null;
    private static final boolean HAS_THEME_CONFIG_PARAMETER = HAS_IS_THEMEABLE && Build.VERSION.SDK_INT >= 21 && XposedHelpers.findMethodExactIfExists("android.app.ResourcesManager", null, "getThemeConfig", new Object[0]) != null;

    private AndroidAppHelper() {
    }

    private static Map<Object, WeakReference> getResourcesMap(ActivityThread activityThread) {
        if (Build.VERSION.SDK_INT >= 24) {
            Object resourcesManager = XposedHelpers.getObjectField(activityThread, "mResourcesManager");
            return (Map)XposedHelpers.getObjectField(resourcesManager, "mResourceImpls");
        }
        if (Build.VERSION.SDK_INT >= 19) {
            Object resourcesManager = XposedHelpers.getObjectField(activityThread, "mResourcesManager");
            return (Map)XposedHelpers.getObjectField(resourcesManager, "mActiveResources");
        }
        return (Map)XposedHelpers.getObjectField(activityThread, "mActiveResources");
    }

    private static Object createResourcesKey(String resDir, float scale) {
        try {
            if (HAS_IS_THEMEABLE) {
                return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, Float.valueOf(scale), false);
            }
            return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, Float.valueOf(scale));
        }
        catch (Throwable t) {
            XposedBridge.log(t);
            return null;
        }
    }

    private static Object createResourcesKey(String resDir, int displayId, Configuration overrideConfiguration, float scale) {
        try {
            if (HAS_THEME_CONFIG_PARAMETER) {
                return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, displayId, overrideConfiguration, Float.valueOf(scale), false, null);
            }
            if (HAS_IS_THEMEABLE) {
                return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, displayId, overrideConfiguration, Float.valueOf(scale), false);
            }
            return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, displayId, overrideConfiguration, Float.valueOf(scale));
        }
        catch (Throwable t) {
            XposedBridge.log(t);
            return null;
        }
    }

    private static Object createResourcesKey(String resDir, int displayId, Configuration overrideConfiguration, float scale, IBinder token) {
        try {
            if (HAS_THEME_CONFIG_PARAMETER) {
                return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, displayId, overrideConfiguration, Float.valueOf(scale), false, null, token);
            }
            if (HAS_IS_THEMEABLE) {
                return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, displayId, overrideConfiguration, Float.valueOf(scale), false, token);
            }
            return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, displayId, overrideConfiguration, Float.valueOf(scale), token);
        }
        catch (Throwable t) {
            XposedBridge.log(t);
            return null;
        }
    }

    private static Object createResourcesKey(String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfiguration, CompatibilityInfo compatInfo) {
        try {
            return XposedHelpers.newInstance(CLASS_RESOURCES_KEY, resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfiguration, compatInfo);
        }
        catch (Throwable t) {
            XposedBridge.log(t);
            return null;
        }
    }

    public static void addActiveResource(String resDir, float scale, boolean isThemeable, Resources resources) {
        AndroidAppHelper.addActiveResource(resDir, resources);
    }

    public static void addActiveResource(String resDir, Resources resources) {
        Object resourcesKey;
        ActivityThread thread = ActivityThread.currentActivityThread();
        if (thread == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            CompatibilityInfo compatInfo = (CompatibilityInfo)XposedHelpers.newInstance(CompatibilityInfo.class, new Object[0]);
            XposedHelpers.setFloatField(compatInfo, "applicationScale", resources.hashCode());
            resourcesKey = AndroidAppHelper.createResourcesKey(resDir, null, null, null, 0, null, compatInfo);
        } else {
            resourcesKey = Build.VERSION.SDK_INT == 23 ? AndroidAppHelper.createResourcesKey(resDir, 0, null, resources.hashCode()) : (Build.VERSION.SDK_INT >= 19 ? AndroidAppHelper.createResourcesKey(resDir, 0, null, resources.hashCode(), null) : (Build.VERSION.SDK_INT >= 17 ? AndroidAppHelper.createResourcesKey(resDir, 0, null, resources.hashCode()) : AndroidAppHelper.createResourcesKey(resDir, resources.hashCode())));
        }
        if (resourcesKey != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                Object resImpl = XposedHelpers.getObjectField(resources, "mResourcesImpl");
                AndroidAppHelper.getResourcesMap(thread).put(resourcesKey, new WeakReference<Object>(resImpl));
            } else {
                AndroidAppHelper.getResourcesMap(thread).put(resourcesKey, new WeakReference<Resources>(resources));
            }
        }
    }

    public static String currentProcessName() {
        String processName = ActivityThread.currentPackageName();
        if (processName == null) {
            return "android";
        }
        return processName;
    }

    public static ApplicationInfo currentApplicationInfo() {
        ActivityThread am = ActivityThread.currentActivityThread();
        if (am == null) {
            return null;
        }
        Object boundApplication = XposedHelpers.getObjectField(am, "mBoundApplication");
        if (boundApplication == null) {
            return null;
        }
        return (ApplicationInfo)XposedHelpers.getObjectField(boundApplication, "appInfo");
    }

    public static String currentPackageName() {
        ApplicationInfo ai = AndroidAppHelper.currentApplicationInfo();
        return ai != null ? ai.packageName : "android";
    }

    public static Application currentApplication() {
        return ActivityThread.currentApplication();
    }

    @Deprecated
    public static SharedPreferences getSharedPreferencesForPackage(String packageName, String prefFileName, int mode) {
        return new XSharedPreferences(packageName, prefFileName);
    }

    @Deprecated
    public static SharedPreferences getDefaultSharedPreferencesForPackage(String packageName) {
        return new XSharedPreferences(packageName);
    }

    @Deprecated
    public static void reloadSharedPreferencesIfNeeded(SharedPreferences pref) {
        if (pref instanceof XSharedPreferences) {
            ((XSharedPreferences)pref).reload();
        }
    }
}

