/*
 * Decompiled with CFR 0.152.
 */
package com.vension.hotlableview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.vension.hotlableview.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b(\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0014J0\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0011H\u0002J(\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0011H\u0002J\u0006\u0010*\u001a\u00020\u0007J\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010,\u001a\u00020\u0014J\u0006\u0010-\u001a\u00020\u0014J\u0006\u0010.\u001a\u00020\u001cJ\u0006\u0010/\u001a\u00020\u0007J\u0006\u00100\u001a\u00020\u0014J\b\u00101\u001a\u00020\"H\u0002J\b\u00102\u001a\u00020\"H\u0002J\u0006\u00103\u001a\u00020\u0011J\u0006\u00104\u001a\u00020\u0011J\u0006\u00105\u001a\u00020\u0011J\u0010\u00106\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u00107\u001a\u00020\"2\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0014J\u000e\u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020\u0007J\u000e\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020\u0011J\u000e\u0010>\u001a\u00020\"2\u0006\u0010?\u001a\u00020\u0007J\u000e\u0010@\u001a\u00020\"2\u0006\u0010A\u001a\u00020\u0014J\u000e\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020\u0014J\u000e\u0010D\u001a\u00020\"2\u0006\u0010E\u001a\u00020\u001cJ\u000e\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020\u0011J\u000e\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u0011J\u000e\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020\u0014J\u000e\u0010L\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u0014R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/vension/hotlableview/HotLableView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_DEGREES", "getAttrs", "()Landroid/util/AttributeSet;", "mBackgroundColor", "mBackgroundPaint", "Landroid/graphics/Paint;", "mFillSize", "mFillTriangle", "", "mGravity", "mMinSize", "", "mPadding", "mPath", "Landroid/graphics/Path;", "mTextAllCaps", "mTextBold", "mTextColor", "mTextContent", "", "mTextPaint", "mTextSize", "dp2px", "dpVal", "drawText", "", "size", "degrees", "canvas", "Landroid/graphics/Canvas;", "textHeight", "isTop", "drawTextWhenFill", "getBgColor", "getGravity", "getMinSize", "getPadding", "getText", "getTextColor", "getTextSize", "initPaint", "initTypedArray", "isFillTriangle", "isTextAllCaps", "isTextBold", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setBgColor", "backgroundColor", "setFillTriangle", "fillTriangle", "setGravity", "gravity", "setMinSize", "minSize", "setPadding", "padding", "setText", "text", "setTextAllCaps", "textAllCaps", "setTextBold", "textBold", "setTextSize", "textSize", "sp2px", "spVal", "hotlableview_release"})
public final class HotLableView
extends View {
    private String mTextContent;
    private int mTextColor;
    private float mTextSize;
    private boolean mTextBold;
    private boolean mFillTriangle;
    private boolean mTextAllCaps;
    private int mBackgroundColor;
    private float mMinSize;
    private float mPadding;
    private int mGravity;
    private final int DEFAULT_DEGREES = 45;
    private final Paint mTextPaint;
    private final Paint mBackgroundPaint;
    private final Path mPath;
    private int mFillSize;
    @Nullable
    private final AttributeSet attrs;

    private final void initTypedArray() {
        TypedArray ta = this.getContext().obtainStyledAttributes(this.attrs, R.styleable.HotLabelView);
        this.mFillSize = ta.getInt(R.styleable.HotLabelView_hlv_fillSize, 0);
        String string = ta.getString(R.styleable.HotLabelView_hlv_text);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ta.getString(R.styleable.HotLabelView_hlv_text)");
        this.mTextContent = string;
        this.mTextColor = ta.getColor(R.styleable.HotLabelView_hlv_textColor, Color.parseColor((String)"#ffffff"));
        this.mTextSize = ta.getDimension(R.styleable.HotLabelView_hlv_textSize, (float)this.sp2px(11.0f));
        this.mTextBold = ta.getBoolean(R.styleable.HotLabelView_hlv_textBold, true);
        this.mTextAllCaps = ta.getBoolean(R.styleable.HotLabelView_hlv_textAllCaps, true);
        this.mFillTriangle = ta.getBoolean(R.styleable.HotLabelView_hlv_fillTriangle, false);
        this.mBackgroundColor = ta.getColor(R.styleable.HotLabelView_hlv_bgColor, Color.parseColor((String)"#FF4081"));
        this.mMinSize = ta.getDimension(R.styleable.HotLabelView_hlv_minSize, (float)(this.mFillTriangle ? this.dp2px(35.0f) : this.dp2px(50.0f)));
        this.mPadding = ta.getDimension(R.styleable.HotLabelView_hlv_padding, (float)this.dp2px(3.5f));
        this.mGravity = ta.getInt(R.styleable.HotLabelView_hlv_gravity, 51);
        ta.recycle();
    }

    private final void initPaint() {
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setFakeBoldText(this.mTextBold);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth;
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (specMode == 0x40000000) {
            measuredWidth = specSize;
        } else {
            int padding = this.getPaddingLeft() + this.getPaddingRight();
            this.mTextPaint.setTextSize(this.mTextSize);
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.mTextContent;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTextContent");
            }
            float textWidth = this.mTextPaint.measureText(stringBuilder.append(string).append("").toString());
            measuredWidth = (int)((double)(padding + (int)textWidth) * Math.sqrt(2.0));
            if (specMode == Integer.MIN_VALUE) {
                measuredWidth = Math.min(measuredWidth, specSize);
            }
            measuredWidth = Math.max((int)this.mMinSize, measuredWidth);
        }
        this.setMeasuredDimension(measuredWidth, measuredWidth);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int size = this.getHeight();
        float textHeight = this.mTextPaint.descent() - this.mTextPaint.ascent();
        int i = this.dp2px(this.mFillSize);
        if (this.mFillTriangle) {
            if (this.mGravity == 51) {
                this.mPath.reset();
                this.mPath.moveTo(0.0f, 0.0f);
                this.mPath.lineTo(0.0f, (float)size);
                this.mPath.lineTo((float)size, 0.0f);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawTextWhenFill(size, -this.DEFAULT_DEGREES, canvas, true);
            } else if (this.mGravity == 53) {
                this.mPath.reset();
                this.mPath.moveTo((float)size, 0.0f);
                this.mPath.lineTo(0.0f, 0.0f);
                this.mPath.lineTo((float)size, (float)size);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawTextWhenFill(size, this.DEFAULT_DEGREES, canvas, true);
            } else if (this.mGravity == 83) {
                this.mPath.reset();
                this.mPath.moveTo(0.0f, (float)size);
                this.mPath.lineTo(0.0f, 0.0f);
                this.mPath.lineTo((float)size, (float)size);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawTextWhenFill(size, this.DEFAULT_DEGREES, canvas, false);
            } else if (this.mGravity == 85) {
                this.mPath.reset();
                this.mPath.moveTo((float)size, (float)size);
                this.mPath.lineTo(0.0f, (float)size);
                this.mPath.lineTo((float)size, 0.0f);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawTextWhenFill(size, -this.DEFAULT_DEGREES, canvas, false);
            }
        } else {
            double delta = (double)(textHeight + this.mPadding * (float)2) * Math.sqrt(2.0);
            if (this.mGravity == 51) {
                this.mPath.reset();
                this.mPath.moveTo(0.0f, (float)((double)size - delta) - (float)i);
                this.mPath.lineTo(0.0f, (float)(size - i));
                this.mPath.lineTo((float)i, (float)size);
                this.mPath.lineTo((float)i, (float)(size - i * 2));
                this.mPath.lineTo((float)(size - i * 2), (float)i);
                this.mPath.lineTo((float)size, (float)i);
                this.mPath.lineTo((float)(size - i), 0.0f);
                this.mPath.lineTo((float)((double)size - delta) - (float)i, 0.0f);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawText(size, -this.DEFAULT_DEGREES, canvas, textHeight + (float)i, true);
            } else if (this.mGravity == 53) {
                this.mPath.reset();
                this.mPath.moveTo((float)(0 + i), 0.0f);
                this.mPath.lineTo((float)delta + (float)i, 0.0f);
                this.mPath.lineTo((float)size, (float)((double)size - delta - (double)i));
                this.mPath.lineTo((float)size, (float)(size - i));
                this.mPath.lineTo((float)(size - i), (float)size);
                this.mPath.lineTo((float)(size - i), (float)(size - i * 2));
                this.mPath.lineTo((float)(i * 2), (float)i);
                this.mPath.lineTo(0.0f, (float)i);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawText(size, this.DEFAULT_DEGREES, canvas, textHeight + (float)i, true);
            } else if (this.mGravity == 83) {
                this.mPath.reset();
                this.mPath.moveTo((float)i, 0.0f);
                this.mPath.lineTo(0.0f, (float)i);
                this.mPath.lineTo(0.0f, (float)delta + (float)i);
                this.mPath.lineTo((float)((double)size - delta) - (float)i, (float)size);
                this.mPath.lineTo((float)(size - i), (float)size);
                this.mPath.lineTo((float)size, (float)(size - i));
                this.mPath.lineTo((float)(size - i * 2), (float)(size - i));
                this.mPath.lineTo((float)i, (float)(i * 2));
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawText(size, this.DEFAULT_DEGREES, canvas, textHeight + (float)i, false);
            } else if (this.mGravity == 85) {
                this.mPath.reset();
                this.mPath.moveTo(0.0f, (float)(size - i));
                this.mPath.lineTo((float)i, (float)size);
                this.mPath.lineTo((float)delta + (float)i, (float)size);
                this.mPath.lineTo((float)size, (float)delta + (float)i);
                this.mPath.lineTo((float)size, (float)i);
                this.mPath.lineTo((float)(size - i), 0.0f);
                this.mPath.lineTo((float)(size - i), (float)(i * 2));
                this.mPath.lineTo((float)(i * 2), (float)(size - i));
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mBackgroundPaint);
                this.drawText(size, -this.DEFAULT_DEGREES, canvas, textHeight + (float)i, false);
            }
        }
    }

    private final void drawText(int size, float degrees, Canvas canvas, float textHeight, boolean isTop) {
        String string;
        canvas.save();
        canvas.rotate(degrees, (float)size / 2.0f, (float)size / 2.0f);
        float delta = isTop ? -(textHeight + this.mPadding * (float)2) / (float)2 : (textHeight + this.mPadding * (float)2) / (float)2;
        float textBaseY = (float)(size / 2) - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / (float)2 + delta;
        Canvas canvas2 = canvas;
        if (this.mTextAllCaps) {
            String string2 = this.mTextContent;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTextContent");
            }
            String string3 = string2;
            Canvas canvas3 = canvas2;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
            String string6 = string5;
            canvas2 = canvas3;
            string = string6;
        } else {
            string = this.mTextContent;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTextContent");
            }
        }
        canvas2.drawText(string, (float)(this.getPaddingLeft() + (size - this.getPaddingLeft() - this.getPaddingRight()) / 2), textBaseY, this.mTextPaint);
        canvas.restore();
    }

    private final void drawTextWhenFill(int size, float degrees, Canvas canvas, boolean isTop) {
        String string;
        canvas.save();
        canvas.rotate(degrees, (float)size / 2.0f, (float)size / 2.0f);
        float delta = isTop ? -size / 4 : size / 4;
        float textBaseY = (float)(size / 2) - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / (float)2 + delta;
        Canvas canvas2 = canvas;
        if (this.mTextAllCaps) {
            String string2 = this.mTextContent;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTextContent");
            }
            String string3 = string2;
            Canvas canvas3 = canvas2;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
            String string6 = string5;
            canvas2 = canvas3;
            string = string6;
        } else {
            string = this.mTextContent;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTextContent");
            }
        }
        canvas2.drawText(string, (float)(this.getPaddingLeft() + (size - this.getPaddingLeft() - this.getPaddingRight()) / 2), textBaseY, this.mTextPaint);
        canvas.restore();
    }

    public final int dp2px(float dpVal) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public final int sp2px(float spVal) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.mTextContent = text;
        this.invalidate();
    }

    public final void setTextSize(float textSize) {
        this.mTextSize = this.sp2px(textSize);
        this.invalidate();
    }

    public final void setTextBold(boolean textBold) {
        this.mTextBold = textBold;
        this.invalidate();
    }

    public final void setFillTriangle(boolean fillTriangle) {
        this.mFillTriangle = fillTriangle;
        this.invalidate();
    }

    public final void setTextAllCaps(boolean textAllCaps) {
        this.mTextAllCaps = textAllCaps;
        this.invalidate();
    }

    public final void setBgColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.invalidate();
    }

    public final void setMinSize(float minSize) {
        this.mMinSize = this.dp2px(minSize);
        this.invalidate();
    }

    public final void setPadding(float padding) {
        this.mPadding = this.dp2px(padding);
        this.invalidate();
    }

    public final void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    @NotNull
    public final String getText() {
        String string = this.mTextContent;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTextContent");
        }
        return string;
    }

    public final int getTextColor() {
        return this.mTextColor;
    }

    public final float getTextSize() {
        return this.mTextSize;
    }

    public final boolean isTextBold() {
        return this.mTextBold;
    }

    public final boolean isFillTriangle() {
        return this.mFillTriangle;
    }

    public final boolean isTextAllCaps() {
        return this.mTextAllCaps;
    }

    public final int getBgColor() {
        return this.mBackgroundColor;
    }

    public final float getMinSize() {
        return this.mMinSize;
    }

    public final float getPadding() {
        return this.mPadding;
    }

    public final int getGravity() {
        return this.mGravity;
    }

    @Nullable
    public final AttributeSet getAttrs() {
        return this.attrs;
    }

    @JvmOverloads
    public HotLableView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.attrs = attrs;
        this.DEFAULT_DEGREES = 45;
        this.mTextPaint = new Paint(1);
        this.mBackgroundPaint = new Paint(1);
        this.mPath = new Path();
        this.initTypedArray();
        this.initPaint();
    }

    @JvmOverloads
    public /* synthetic */ HotLableView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public HotLableView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public HotLableView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

