/*
 * Decompiled with CFR 0.152.
 */
package me.toxz.circularprogressview.library;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.View;
import me.toxz.circularprogressview.library.CircularProgressView;

class Circle
extends View {
    private Paint mStrokePaint;
    private float sweepAngle;
    private CircularProgressView mCircularProgressView;
    private RectF rect;
    private long startMillis;
    private long mDuration = 0L;

    public Circle(Context context, CircularProgressView circularProgressView) {
        super(context);
        this.mCircularProgressView = circularProgressView;
        this.init();
    }

    private void init() {
        this.mStrokePaint = new Paint(1);
        this.mStrokePaint.setColor(this.getResources().getColor(this.mCircularProgressView.getStokeColor()));
        this.mStrokePaint.setStrokeWidth(this.mCircularProgressView.getStrokeSize());
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.rect = new RectF();
    }

    void setProgress(int progress) {
        this.sweepAngle = (float)((double)progress * 3.6);
    }

    public void reset() {
        this.sweepAngle = 0.0f;
        this.mDuration = 0L;
        this.startMillis = 0L;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Log.i((String)"Circle", (String)("widthMeasureSpec: " + widthMeasureSpec + ", heightMeasureSpec: " + heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.rect.set(0.0f + this.mCircularProgressView.getStrokeSize() / 2.0f, 0.0f + this.mCircularProgressView.getStrokeSize() / 2.0f, (float)this.getMeasuredWidth() - this.mCircularProgressView.getStrokeSize() / 2.0f, (float)this.getMeasuredHeight() - this.mCircularProgressView.getStrokeSize() / 2.0f);
        canvas.drawArc(this.rect, -90.0f, this.sweepAngle, false, this.mStrokePaint);
        if (this.sweepAngle < 360.0f) {
            if (this.mDuration > 0L) {
                if (this.startMillis <= 0L) {
                    this.startMillis = System.currentTimeMillis();
                }
                this.sweepAngle = (float)(System.currentTimeMillis() - this.startMillis) / (float)this.mDuration * 360.0f;
            }
            this.invalidate();
        } else {
            this.sweepAngle = 0.0f;
            this.mCircularProgressView.finalAnimation();
        }
    }

    public void setDuration(long millis) {
        this.mDuration = millis;
    }
}

