/*
 * Decompiled with CFR 0.152.
 */
package me.toxz.circularprogressview.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import me.toxz.circularprogressview.library.Circle;
import me.toxz.circularprogressview.library.R;

public class CircularProgressView
extends FrameLayout {
    private int mStokeColor = R.color.default_stroke_color;
    private Circle mCircleView;
    private ImageView mFillView;
    private float mStrokeSize = this.getResources().getDimension(R.dimen.default_stroke_size);
    private int mStartDrawableMargins;
    private int mProgressDrawableMargins = this.mStartDrawableMargins = (int)this.getResources().getDimension(R.dimen.default_drawable_margins);
    private int mEndDrawableMargins = this.mStartDrawableMargins;
    private Drawable mStartDrawable = this.getResources().getDrawable(R.drawable.default_start_drawable);
    private Drawable mProgressDrawable = this.getResources().getDrawable(R.drawable.default_progress_drawable);
    private Drawable mEndDrawable = this.getResources().getDrawable(R.drawable.default_end_drawable);
    private Paint mFillPaint;
    private ImageView mCenterImage;
    private AnimationSet in;
    private AnimationSet out;
    private ScaleAnimation newScaleIn;
    private Status mStatus = Status.CREATING;
    private OnStatusListener mListener;
    private int mProgress = 0;
    private AnimationSet allOut;
    private AnimationSet allIn;
    FrameLayout.LayoutParams wrapLayoutParams;
    boolean isFirstDraw = true;

    public CircularProgressView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public CircularProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public CircularProgressView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    public int getStokeColor() {
        return this.mStokeColor;
    }

    public float getStrokeSize() {
        return this.mStrokeSize;
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.initResource(attrs, defStyle);
        this.initDrawable();
        this.initPaint();
        this.initAnimation();
        this.initView();
    }

    private void initResource(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircularProgressView, defStyle, 0);
        this.mStokeColor = a.getColor(R.styleable.CircularProgressView_strokeColor, this.mStokeColor);
        this.mStrokeSize = a.getDimension(R.styleable.CircularProgressView_strokeSize, this.mStrokeSize);
        this.mStartDrawableMargins = (int)a.getDimension(R.styleable.CircularProgressView_startDrawableMargins, (float)this.mStartDrawableMargins);
        this.mProgressDrawableMargins = (int)a.getDimension(R.styleable.CircularProgressView_progressDrawableMargins, (float)this.mProgressDrawableMargins);
        this.mEndDrawableMargins = (int)a.getDimension(R.styleable.CircularProgressView_endDrawableMargins, (float)this.mEndDrawableMargins);
        if (a.hasValue(R.styleable.CircularProgressView_startDrawable)) {
            this.mStartDrawable = a.getDrawable(R.styleable.CircularProgressView_startDrawable);
            this.mStartDrawable.setCallback((Drawable.Callback)this);
        }
        if (a.hasValue(R.styleable.CircularProgressView_progressDrawable)) {
            this.mProgressDrawable = a.getDrawable(R.styleable.CircularProgressView_progressDrawable);
            this.mProgressDrawable.setCallback((Drawable.Callback)this);
        }
        if (a.hasValue(R.styleable.CircularProgressView_endDrawable)) {
            this.mEndDrawable = a.getDrawable(R.styleable.CircularProgressView_endDrawable);
            this.mEndDrawable.setCallback((Drawable.Callback)this);
        }
        a.recycle();
    }

    private void initDrawable() {
        this.mCircleView = new Circle(this.getContext(), this);
        this.mCircleView.setClickable(false);
        this.mCenterImage = new ImageView(this.getContext());
        this.mCenterImage.setClickable(false);
        this.mFillView = new ImageView(this.getContext());
        this.mFillView.setClickable(false);
        this.setClickable(true);
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CircularProgressView.this.handleClick();
            }
        });
    }

    private void initPaint() {
        this.mFillPaint = new Paint(1);
        this.mFillPaint.setColor(this.getResources().getColor(this.mStokeColor));
        this.mFillPaint.setStyle(Paint.Style.FILL_AND_STROKE);
    }

    private void initAnimation() {
        ScaleAnimation scaleIn = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        ScaleAnimation scaleOut = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.newScaleIn = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        scaleIn.setDuration(150L);
        scaleOut.setDuration(150L);
        this.newScaleIn.setDuration(200L);
        AlphaAnimation fadeIn = new AlphaAnimation(0.0f, 1.0f);
        AlphaAnimation fadeOut = new AlphaAnimation(1.0f, 0.0f);
        fadeIn.setDuration(150L);
        fadeOut.setDuration(150L);
        this.in = new AnimationSet(true);
        this.out = new AnimationSet(true);
        this.in.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.out.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.in.addAnimation((Animation)scaleIn);
        this.in.addAnimation((Animation)fadeIn);
        this.out.addAnimation((Animation)fadeOut);
        this.out.addAnimation((Animation)scaleOut);
        this.out.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                CircularProgressView.this.mCenterImage.setVisibility(4);
                CircularProgressView.this.wrapLayoutParams.setMargins(CircularProgressView.this.mProgressDrawableMargins, CircularProgressView.this.mProgressDrawableMargins, CircularProgressView.this.mProgressDrawableMargins, CircularProgressView.this.mProgressDrawableMargins);
                CircularProgressView.this.mCenterImage.setLayoutParams((ViewGroup.LayoutParams)CircularProgressView.this.wrapLayoutParams);
                CircularProgressView.this.mCenterImage.setImageDrawable(CircularProgressView.this.mProgressDrawable);
                CircularProgressView.this.mCenterImage.setVisibility(0);
                CircularProgressView.this.mCenterImage.startAnimation((Animation)CircularProgressView.this.in);
                CircularProgressView.this.mCircleView.setVisibility(0);
                CircularProgressView.this.mStatus = Status.PROGRESS;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.newScaleIn.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                CircularProgressView.this.mCircleView.setVisibility(4);
                CircularProgressView.this.wrapLayoutParams.setMargins(CircularProgressView.this.mEndDrawableMargins, CircularProgressView.this.mEndDrawableMargins, CircularProgressView.this.mEndDrawableMargins, CircularProgressView.this.mEndDrawableMargins);
                CircularProgressView.this.mCenterImage.setLayoutParams((ViewGroup.LayoutParams)CircularProgressView.this.wrapLayoutParams);
                CircularProgressView.this.mCenterImage.setImageDrawable(CircularProgressView.this.mEndDrawable);
                CircularProgressView.this.mCenterImage.setVisibility(0);
                CircularProgressView.this.mStatus = Status.END;
                CircularProgressView.this.mCenterImage.startAnimation((Animation)CircularProgressView.this.in);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.allOut = new AnimationSet(true);
        this.allOut.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.allOut.addAnimation((Animation)fadeOut);
        this.allOut.addAnimation((Animation)scaleOut);
        this.allOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                CircularProgressView.this.wrapLayoutParams.setMargins(CircularProgressView.this.mStartDrawableMargins, CircularProgressView.this.mStartDrawableMargins, CircularProgressView.this.mStartDrawableMargins, CircularProgressView.this.mStartDrawableMargins);
                CircularProgressView.this.mCenterImage.setLayoutParams((ViewGroup.LayoutParams)CircularProgressView.this.wrapLayoutParams);
                CircularProgressView.this.mCenterImage.setImageDrawable(CircularProgressView.this.mStartDrawable);
                CircularProgressView.this.mFillView.setVisibility(4);
                CircularProgressView.this.startAnimation((Animation)CircularProgressView.this.allIn);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.allIn = new AnimationSet(true);
        this.allIn.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.allIn.addAnimation((Animation)scaleIn);
        this.allIn.addAnimation((Animation)fadeIn);
        this.allIn.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                CircularProgressView.this.mStatus = Status.START;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void initView() {
        Log.i((String)"CircularProgressView", (String)("width: " + this.getWidth() + ", height: " + this.getHeight()));
        Log.i((String)"CircularProgressView", (String)("measureWidth: " + this.getMeasuredWidth() + ", measureHeight: " + this.getMeasuredHeight()));
        this.wrapLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.wrapLayoutParams.setMargins(this.mStartDrawableMargins, this.mStartDrawableMargins, this.mStartDrawableMargins, this.mStartDrawableMargins);
        this.mCenterImage.setImageDrawable(this.mStartDrawable);
        this.mStatus = Status.START;
        this.addView((View)this.mCenterImage, (ViewGroup.LayoutParams)this.wrapLayoutParams);
    }

    public void setOnClickListener(View.OnClickListener l) {
        throw new UnsupportedOperationException("You must use setOnStateListener(OnStatusListener) instead.");
    }

    public void setOnStateListener(OnStatusListener listener) {
        this.mListener = listener;
    }

    private void handleClick() {
        if (this.mListener != null) {
            this.mListener.onStatus(this.mStatus);
        }
        switch (this.mStatus) {
            case START: {
                this.startAnimation();
                break;
            }
            case PROGRESS: {
                break;
            }
            case END: {
                break;
            }
            case CREATING: {
                this.mStatus = Status.START;
                break;
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.isFirstDraw) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            int width = this.getWidth();
            int height = this.getHeight();
            int r = Math.min(width, height);
            Bitmap.Config conf = Bitmap.Config.ARGB_8888;
            Bitmap bgCircleBitmap = Bitmap.createBitmap((int)r, (int)r, (Bitmap.Config)conf);
            Canvas bgCircleCanvas = new Canvas(bgCircleBitmap);
            RectF rect0 = new RectF(0.0f, 0.0f, (float)r, (float)r);
            bgCircleCanvas.drawArc(rect0, 0.0f, 360.0f, false, this.mFillPaint);
            this.mFillView.setImageBitmap(bgCircleBitmap);
            this.mCircleView.setVisibility(4);
            this.mFillView.setVisibility(4);
            this.addView((View)this.mFillView, 0, (ViewGroup.LayoutParams)lp);
            this.addView(this.mCircleView, (ViewGroup.LayoutParams)lp);
            this.isFirstDraw = false;
        }
        super.dispatchDraw(canvas);
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
        this.mCircleView.setProgress(progress);
    }

    public int getProgress() {
        return this.mProgress;
    }

    void finalAnimation() {
        this.mCenterImage.setVisibility(4);
        this.mFillView.setVisibility(0);
        this.mFillView.startAnimation((Animation)this.newScaleIn);
    }

    private void startAnimation() {
        this.mFillView.setVisibility(4);
        this.mCircleView.setVisibility(4);
        this.mCenterImage.startAnimation((Animation)this.out);
    }

    public void reset() {
        this.mCircleView.reset();
        this.mProgress = 0;
        this.mCircleView.setVisibility(4);
        this.wrapLayoutParams.setMargins(this.mStartDrawableMargins, this.mStartDrawableMargins, this.mStartDrawableMargins, this.mStartDrawableMargins);
        this.mCenterImage.setLayoutParams((ViewGroup.LayoutParams)this.wrapLayoutParams);
        this.mCenterImage.setImageDrawable(this.mStartDrawable);
        this.mFillView.setVisibility(4);
        this.mCenterImage.clearAnimation();
        this.mStatus = Status.CREATING;
    }

    public void resetSmoothly() {
        this.mCircleView.reset();
        this.mProgress = 0;
        this.mCircleView.setVisibility(4);
        this.mStatus = Status.CREATING;
        this.mCenterImage.clearAnimation();
        this.startAnimation((Animation)this.allOut);
    }

    public void setDuration(long millis) {
        this.mCircleView.setDuration(millis);
    }

    public static interface OnStatusListener {
        public void onStatus(Status var1);
    }

    public static enum Status {
        CREATING,
        START,
        PROGRESS,
        END;

    }
}

