/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Iterator;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.ProgressThread;
import me.tongfei.progressbar.Util;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedInputStream;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterable;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterator;

public class ProgressBar
implements AutoCloseable {
    private ProgressState progress;
    private ProgressThread target;
    private Thread thread;

    public ProgressBar(String task, long initialMax) {
        this(task, initialMax, 1000, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L);
    }

    public ProgressBar(String task, long initialMax, ProgressBarStyle style) {
        this(task, initialMax, 1000, System.err, style, "", 1L);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis) {
        this(task, initialMax, updateIntervalMillis, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, PrintStream os, ProgressBarStyle style, String unitName, long unitSize) {
        this.progress = new ProgressState(task, initialMax);
        this.target = new ProgressThread(this.progress, style, updateIntervalMillis, os, unitName, unitSize);
        this.thread = new Thread((Runnable)this.target, this.getClass().getName());
        this.progress.startTime = Instant.now();
        this.thread.start();
    }

    @Deprecated
    public ProgressBar start() {
        this.progress.startTime = Instant.now();
        this.thread.start();
        return this;
    }

    public ProgressBar stepBy(long n) {
        this.progress.stepBy(n);
        return this;
    }

    public ProgressBar stepTo(long n) {
        this.progress.stepTo(n);
        return this;
    }

    public ProgressBar step() {
        this.progress.stepBy(1L);
        return this;
    }

    public ProgressBar maxHint(long n) {
        if (n < 0L) {
            this.progress.setAsIndefinite();
        } else {
            this.progress.setAsDefinite();
            this.progress.maxHint(n);
        }
        return this;
    }

    @Deprecated
    public ProgressBar stop() {
        this.close();
        return this;
    }

    @Override
    public void close() {
        this.target.kill();
        try {
            this.thread.join();
            this.target.consoleStream.print("\n");
            this.target.consoleStream.flush();
            this.target.terminal.close();
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    public ProgressBar setExtraMessage(String msg) {
        this.progress.setExtraMessage(msg);
        return this;
    }

    public long getCurrent() {
        return this.progress.getCurrent();
    }

    public long getMax() {
        return this.progress.getMax();
    }

    public String getTask() {
        return this.progress.getTask();
    }

    public String getExtraMessage() {
        return this.progress.getExtraMessage();
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, String task) {
        return ProgressBar.wrap(it, new ProgressBarBuilder().setTaskName(task).setInitialMax(-1L));
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedIterator<T>(it, pbb.build());
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, String task) {
        return ProgressBar.wrap(ts, new ProgressBarBuilder().setTaskName(task));
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedIterable<T>(ts, pbb);
    }

    public static InputStream wrap(InputStream is, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task).setInitialMax(Util.getInputStreamSize(is));
        return ProgressBar.wrap(is, pbb);
    }

    public static InputStream wrap(InputStream is, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedInputStream(is, pbb.setInitialMax(Util.getInputStreamSize(is)).build());
    }
}

