/*
 * Decompiled with CFR 0.152.
 */
package me.timos.thuanle.universaladapter;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import me.timos.thuanle.universaladapter.Categorizer;
import me.timos.thuanle.universaladapter.Param;
import me.timos.thuanle.universaladapter.binder.ImageViewBinder;
import me.timos.thuanle.universaladapter.binder.TextViewBinder;
import me.timos.thuanle.universaladapter.binder.ViewBinder;

public class UniversalAdapter<D>
extends RecyclerView.Adapter<VH> {
    private static final int VIEW_TYPE_ELEMENT = 0;
    private static final int VIEW_TYPE_HEADER = 1;
    private final Param<D> mParam;
    private List<D> mDataWrapper;
    private SparseArray<String> mHeaderMap;

    UniversalAdapter(Param<D> param) {
        this.mParam = param;
        this.prepareData(param.data);
    }

    public void add(D data) {
        this.mDataWrapper.add(data);
        this.notifyItemInserted(this.mDataWrapper.size() - 1);
    }

    public RecyclerView.LayoutManager createLayoutManager(Context context, final int column, int orientation, boolean reverseLayout) {
        if (column == 1) {
            return new LinearLayoutManager(context, orientation, reverseLayout);
        }
        GridLayoutManager glm = new GridLayoutManager(context, column, orientation, reverseLayout);
        glm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                Object datum = UniversalAdapter.this.mDataWrapper.get(position);
                if (datum == null) {
                    return column;
                }
                return 1;
            }
        });
        return glm;
    }

    public RecyclerView.LayoutManager createLayoutManager(Context context, int column) {
        return this.createLayoutManager(context, column, 1, false);
    }

    public int getItemCount() {
        return this.mDataWrapper.size();
    }

    public int getItemViewType(int position) {
        if (this.isHeaderPosition(position)) {
            return 1;
        }
        return 0;
    }

    private boolean isHeaderPosition(int position) {
        return this.mParam.hasHeader() && this.mHeaderMap.indexOfKey(position) >= 0;
    }

    public void onBindViewHolder(VH holder, int position) {
        if (!this.isHeaderPosition(position)) {
            D value = this.mDataWrapper.get(position);
            for (ViewBinder<D, ?, ?> binder : this.mParam.binders) {
                int id = binder.getId();
                View v = (View)holder.mViews.get(id);
                binder.bind(position, value, v);
            }
        } else {
            String header = (String)this.mHeaderMap.get(position);
            for (ViewBinder<String, ?, ?> binder : this.mParam.groupHeaderBinders) {
                int id = binder.getId();
                View v = (View)holder.mViews.get(id);
                binder.bind(position, header, v);
            }
        }
    }

    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.mParam.layoutResId, parent, false);
            return new VH(v, this.mParam.getIds());
        }
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.mParam.groupHeaderLayoutResId, parent, false);
        return new VH(v, this.mParam.getIds());
    }

    private void prepareData(List<D> data) {
        if (this.mParam.hasHeader()) {
            ArrayListMultimap mmap = ArrayListMultimap.create();
            ArrayList<String> headers = new ArrayList<String>();
            for (D d : data) {
                String cate = this.mParam.groupCategorizer.getCategory(d);
                if (!mmap.containsKey((Object)cate)) {
                    headers.add(cate);
                }
                mmap.put((Object)cate, d);
            }
            if (this.mParam.groupHeaderComparator != null) {
                Collections.sort(headers, this.mParam.groupHeaderComparator);
            }
            this.mDataWrapper = new ArrayList<D>(headers.size() + data.size());
            this.mHeaderMap = new SparseArray(headers.size());
            int hIdx = 0;
            for (String header : headers) {
                this.mHeaderMap.put(hIdx, (Object)header);
                this.mDataWrapper.add(null);
                List group = mmap.get((Object)header);
                if (this.mParam.groupMemberComparator != null) {
                    Collections.sort(group, this.mParam.groupMemberComparator);
                }
                this.mDataWrapper.addAll(group);
                hIdx += group.size() + 1;
            }
        } else {
            this.mDataWrapper = data;
            this.mHeaderMap = new SparseArray();
            if (this.mParam.comparator != null) {
                Collections.sort(this.mDataWrapper, this.mParam.comparator);
            }
        }
    }

    public void setData(List<D> data) {
        this.prepareData(data);
        this.notifyDataSetChanged();
    }

    public static class Builder<T> {
        Param<T> mParam;

        Builder(List<T> data) {
            this.mParam = new Param<T>(data);
        }

        private Builder(Builder<T> src) {
            this.mParam = src.mParam.cloneBinders();
        }

        public static <T> Builder<T> with(Class<T> classOfData) {
            return Builder.with(new ArrayList());
        }

        public static <T> Builder<T> with(T ... data) {
            return Builder.with(Arrays.asList(data));
        }

        public static <T> Builder<T> with(List<T> data) {
            return new Builder<T>(data);
        }

        public Builder<T> bind(ViewBinder<T, ?, ?> binder) {
            this.mParam.binders.add(binder);
            return this;
        }

        public Builder<T> bind(ViewBinder.Builder<T, ?> builder) {
            return this.bind(builder.build());
        }

        public ImageViewBinder.Builder<T> bindImageView(@IdRes int resId) {
            ImageViewBinder.Builder binder = new ImageViewBinder.Builder(resId);
            this.mParam.binders.add(binder.build());
            return binder;
        }

        public TextViewBinder.Builder<T> bindTextView(@IdRes int resId) {
            TextViewBinder.Builder binder = new TextViewBinder.Builder(resId);
            this.mParam.binders.add(binder.build());
            return binder;
        }

        public <V extends View> ViewBinder.Builder<T, V> bindView(@IdRes int resId, Class<V> classOfView) {
            ViewBinder.Builder binder = new ViewBinder.Builder(resId);
            this.mParam.binders.add(binder.build());
            return binder;
        }

        public UniversalAdapter<T> build() {
            return new UniversalAdapter<T>(this.mParam);
        }

        public Builder<T> cloneBuilders() {
            return new Builder<T>(this);
        }

        public Param<T> getParam() {
            return this.mParam;
        }

        public Builder<T> groupBy(Categorizer<T> categorizer) {
            this.mParam.groupCategorizer = categorizer;
            return this;
        }

        public Builder<T> groupHeaderBind(ViewBinder<String, ?, ?> binder) {
            this.mParam.groupHeaderBinders.add(binder);
            return this;
        }

        public Builder<T> groupHeaderBind(ViewBinder.Builder<String, ?> builder) {
            return this.groupHeaderBind(builder.build());
        }

        public Builder<T> groupHeaderLayout(@LayoutRes int layoutResId) {
            this.mParam.groupHeaderLayoutResId = layoutResId;
            return this;
        }

        public Builder<T> groupHeaderSortBy(Comparator<String> groupHeaderSortBy) {
            this.mParam.groupHeaderComparator = groupHeaderSortBy;
            return this;
        }

        public Builder<T> groupdMemberSortBy(Comparator<T> groupMemberSortBy) {
            this.mParam.groupMemberComparator = groupMemberSortBy;
            return this;
        }

        public Builder<T> itemLayout(@LayoutRes int layoutResId) {
            this.mParam.layoutResId = layoutResId;
            return this;
        }

        public Builder<T> sortBy(Comparator<T> comparator) {
            this.mParam.comparator = comparator;
            return this;
        }
    }

    static class VH
    extends RecyclerView.ViewHolder {
        SparseArray<View> mViews = new SparseArray();

        VH(View itemView, Set<Integer> ids) {
            super(itemView);
            for (int id : ids) {
                this.mViews.put(id, (Object)itemView.findViewById(id));
            }
        }
    }
}

