/*
 * Decompiled with CFR 0.152.
 */
package me.timos.thuanle.fbnativeadadapter;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.facebook.ads.AbstractAdListener;
import com.facebook.ads.Ad;
import com.facebook.ads.AdChoicesView;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.rockerhieu.rvadapter.RecyclerViewAdapterWrapper;
import java.util.ArrayList;
import me.timos.thuanle.fbnativeadadapter.R;

public class FBNativeAdAdapter
extends RecyclerViewAdapterWrapper {
    public static final int TYPE_FB_NATIVE_ADS = 900;
    public static final int DEFAULT_AD_ITEM_INTERVAL = 10;
    private final Param mParam;

    private FBNativeAdAdapter(Param param) {
        super(param.adapter);
        this.mParam = param;
        this.assertConfig();
        this.setSpanAds();
    }

    private void assertConfig() {
        int nCol;
        if (this.mParam.gridLayoutManager != null && this.mParam.adItemInterval % (nCol = this.mParam.gridLayoutManager.getSpanCount()) != 0) {
            throw new IllegalArgumentException(String.format("The adItemInterval (%d) is not divisible by number of columns in GridLayoutManager (%d)", this.mParam.adItemInterval, nCol));
        }
    }

    private int convertAdPosition2OrgPosition(int position) {
        return position - (position + 1) / (this.mParam.adItemInterval + 1);
    }

    public int getItemCount() {
        int realCount = super.getItemCount();
        return realCount + realCount / this.mParam.adItemInterval;
    }

    public int getItemViewType(int position) {
        if (this.isAdPosition(position)) {
            return 900;
        }
        return super.getItemViewType(this.convertAdPosition2OrgPosition(position));
    }

    private boolean isAdPosition(int position) {
        return (position + 1) % (this.mParam.adItemInterval + 1) == 0;
    }

    public void onBindAdViewHolder(RecyclerView.ViewHolder holder) {
        final AdViewHolder adHolder = (AdViewHolder)holder;
        if (this.mParam.forceReloadAdOnBind || !adHolder.loaded) {
            final NativeAd nativeAd = new NativeAd(adHolder.getContext(), this.mParam.facebookPlacementId);
            nativeAd.setAdListener((AdListener)new AbstractAdListener(){

                public void onAdLoaded(Ad ad) {
                    if (ad != nativeAd) {
                        return;
                    }
                    adHolder.nativeAdContainer.setVisibility(0);
                    adHolder.nativeAdTitle.setText((CharSequence)nativeAd.getAdTitle());
                    adHolder.nativeAdSocialContext.setText((CharSequence)nativeAd.getAdSocialContext());
                    adHolder.nativeAdBody.setText((CharSequence)nativeAd.getAdBody());
                    adHolder.nativeAdCallToAction.setText((CharSequence)nativeAd.getAdCallToAction());
                    NativeAd.Image adIcon = nativeAd.getAdIcon();
                    NativeAd.downloadAndDisplayImage((NativeAd.Image)adIcon, (ImageView)adHolder.nativeAdIcon);
                    adHolder.nativeAdMedia.setNativeAd(nativeAd);
                    AdChoicesView adChoicesView = new AdChoicesView(adHolder.getContext(), nativeAd, true);
                    adHolder.adChoicesContainer.removeAllViews();
                    adHolder.adChoicesContainer.addView((View)adChoicesView);
                    ArrayList<Object> clickableViews = new ArrayList<Object>();
                    clickableViews.add(adHolder.nativeAdTitle);
                    clickableViews.add(adHolder.nativeAdCallToAction);
                    nativeAd.registerViewForInteraction((View)adHolder.nativeAdContainer, clickableViews);
                    adHolder.loaded = true;
                }

                public void onError(Ad ad, AdError adError) {
                    adHolder.nativeAdContainer.setVisibility(8);
                }
            });
            nativeAd.loadAd();
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.getItemViewType(position) == 900) {
            this.onBindAdViewHolder(holder);
        } else {
            super.onBindViewHolder(holder, this.convertAdPosition2OrgPosition(position));
        }
    }

    public RecyclerView.ViewHolder onCreateAdViewHolder(ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View adLayoutOutline = inflater.inflate(this.mParam.itemContainerLayoutRes, parent, false);
        ViewGroup vg = (ViewGroup)adLayoutOutline.findViewById(this.mParam.itemContainerId);
        LinearLayout adLayoutContent = (LinearLayout)inflater.inflate(R.layout.item_facebook_native_ad, parent, false);
        vg.addView((View)adLayoutContent);
        return new AdViewHolder(adLayoutOutline);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 900) {
            return this.onCreateAdViewHolder(parent);
        }
        return super.onCreateViewHolder(parent, viewType);
    }

    private void setSpanAds() {
        if (this.mParam.gridLayoutManager == null) {
            return;
        }
        final GridLayoutManager.SpanSizeLookup spl = this.mParam.gridLayoutManager.getSpanSizeLookup();
        this.mParam.gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                if (FBNativeAdAdapter.this.isAdPosition(position)) {
                    return spl.getSpanSize(FBNativeAdAdapter.this.convertAdPosition2OrgPosition(position));
                }
                return 1;
            }
        });
    }

    private static class AdViewHolder
    extends RecyclerView.ViewHolder {
        ImageView nativeAdIcon;
        TextView nativeAdTitle;
        MediaView nativeAdMedia;
        TextView nativeAdSocialContext;
        TextView nativeAdBody;
        Button nativeAdCallToAction;
        LinearLayout adChoicesContainer;
        LinearLayout nativeAdContainer;
        boolean loaded;

        AdViewHolder(View view) {
            super(view);
            this.nativeAdContainer = (LinearLayout)view.findViewById(R.id.fb_native_ad_container);
            this.nativeAdIcon = (ImageView)view.findViewById(R.id.native_ad_icon);
            this.nativeAdTitle = (TextView)view.findViewById(R.id.native_ad_title);
            this.nativeAdMedia = (MediaView)view.findViewById(R.id.native_ad_media);
            this.nativeAdSocialContext = (TextView)view.findViewById(R.id.native_ad_social_context);
            this.nativeAdBody = (TextView)view.findViewById(R.id.native_ad_body);
            this.nativeAdCallToAction = (Button)view.findViewById(R.id.native_ad_call_to_action);
            this.adChoicesContainer = (LinearLayout)view.findViewById(R.id.ad_choices_container);
            this.loaded = false;
        }

        public Context getContext() {
            return this.nativeAdContainer.getContext();
        }
    }

    public static class Builder {
        private final Param mParam;

        private Builder(Param param) {
            this.mParam = param;
        }

        public static Builder with(String placementId, RecyclerView.Adapter wrapped) {
            Param param = new Param();
            param.facebookPlacementId = placementId;
            param.adapter = wrapped;
            param.adItemInterval = 10;
            param.itemContainerLayoutRes = R.layout.item_facebook_native_ad_outline;
            param.itemContainerId = R.id.ad_container;
            param.forceReloadAdOnBind = true;
            return new Builder(param);
        }

        public Builder adItemIterval(int interval) {
            this.mParam.adItemInterval = interval;
            return this;
        }

        public Builder adLayout(@LayoutRes int layoutContainerRes, @IdRes int itemContainerId) {
            this.mParam.itemContainerLayoutRes = layoutContainerRes;
            this.mParam.itemContainerId = itemContainerId;
            return this;
        }

        public FBNativeAdAdapter build() {
            return new FBNativeAdAdapter(this.mParam);
        }

        public Builder enableSpanRow(GridLayoutManager layoutManager) {
            this.mParam.gridLayoutManager = layoutManager;
            return this;
        }

        public Builder forceReloadAdOnBind(boolean forced) {
            this.mParam.forceReloadAdOnBind = forced;
            return this;
        }
    }

    private static class Param {
        String facebookPlacementId;
        RecyclerView.Adapter adapter;
        int adItemInterval;
        boolean forceReloadAdOnBind;
        @LayoutRes
        int itemContainerLayoutRes;
        @IdRes
        int itemContainerId;
        GridLayoutManager gridLayoutManager;

        private Param() {
        }
    }
}

