/*
 * Decompiled with CFR 0.152.
 */
package me.staufer.textools;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.Base64;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import me.staufer.textools.MathViewInterface;
import me.staufer.textools.R;
import org.json.JSONException;
import org.json.JSONObject;

public class MathView
extends WebView {
    private JSONObject options;
    private String tex;
    private String buffer;
    private boolean loaded = false;

    public MathView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.loadAttributes(context, attrs);
        this.initialize(context);
        if (this.tex != null) {
            this.loadWithTeX();
        } else {
            this.load();
        }
    }

    public MathView(Context context, Map options) {
        super(context);
        this.loadOptions(options);
        this.initialize(context);
        if (this.tex != null) {
            this.loadWithTeX();
        } else {
            this.load();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initialize(Context context) {
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(1);
        webSettings.setDatabaseEnabled(false);
        webSettings.setSupportZoom(false);
        webSettings.setDisplayZoomControls(false);
        webSettings.setGeolocationEnabled(false);
        try {
            webSettings.setDefaultFontSize(this.options.getInt("fontSize"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                MathView.this.loaded = true;
                if (MathView.this.buffer != null) {
                    MathView.this.render(MathView.this.buffer);
                }
            }
        });
        this.addJavascriptInterface(new MathViewInterface(context), "MathViewInterface");
    }

    private void load() {
        URI uri = URI.create("file:///android_asset/index.html");
        try {
            uri = new URI("file", null, "///android_asset/index.html", "options=" + this.options.toString(), null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.loadUrl(uri.toString());
    }

    private void loadWithTeX() {
        URI uri = URI.create("file:///android_asset/index.html");
        try {
            uri = new URI("file", null, "///android_asset/index.html", "options=" + this.options.toString() + "&tex=" + MathView.encodeTeX(this.tex), null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.loadUrl(uri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(Context context, AttributeSet attrs) {
        this.options = new JSONObject();
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MathView, 0, 0);
        try {
            this.options.put("color", (Object)String.format("#%06X", 0xFFFFFF & styledAttributes.getColor(R.styleable.MathView_color, -16777216)));
            this.options.put("background", (Object)String.format("#%06X", 0xFFFFFF & styledAttributes.getColor(R.styleable.MathView_colorBackground, -1)));
            this.options.put("errorColor", (Object)String.format("#%06X", 0xFFFFFF & styledAttributes.getColor(R.styleable.MathView_colorError, Color.rgb((int)204, (int)0, (int)0))));
            this.options.put("displayMode", styledAttributes.getBoolean(R.styleable.MathView_displayMode, false));
            this.options.put("fleqn", styledAttributes.getBoolean(R.styleable.MathView_fleqn, false));
            this.options.put("leqno", styledAttributes.getBoolean(R.styleable.MathView_leqno, false));
            this.options.put("throwOnError", styledAttributes.getBoolean(R.styleable.MathView_throwOnError, false));
            this.options.put("fontSize", styledAttributes.getInt(R.styleable.MathView_fontSize, 16));
            this.tex = styledAttributes.getString(R.styleable.MathView_tex);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            styledAttributes.recycle();
        }
    }

    private void loadOptions(Map options) {
        this.options = new JSONObject();
        try {
            this.options.put("color", (Object)String.format("#%06X", 0xFFFFFF & MathView.getOrDefault(options, "color", -16777216)));
            this.options.put("background", (Object)String.format("#%06X", 0xFFFFFF & MathView.getOrDefault(options, "backgroundColor", -1)));
            this.options.put("errorColor", (Object)String.format("#%06X", 0xFFFFFF & MathView.getOrDefault(options, "colorError", Color.rgb((int)204, (int)0, (int)0))));
            this.options.put("displayMode", (Object)MathView.getOrDefault(options, "displayMode", false));
            this.options.put("fleqn", (Object)MathView.getOrDefault(options, "fleqn", false));
            this.options.put("leqno", (Object)MathView.getOrDefault(options, "leqno", false));
            this.options.put("throwOnError", (Object)MathView.getOrDefault(options, "throwOnError", false));
            this.options.put("fontSize", (Object)MathView.getOrDefault(options, "fontSize", 16));
            this.tex = MathView.getOrDefault(options, "tex", null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void render(String tex) {
        if (!this.loaded) {
            this.buffer = tex;
            return;
        }
        tex = MathView.encodeTeX(tex);
        this.loadUrl("javascript:update('" + tex + "')");
    }

    private static <T> T getOrDefault(Map map, String key, T def) {
        return (T)(map.containsKey(key) ? map.get(key) : def);
    }

    private static String encodeTeX(String tex) {
        return Base64.encodeToString((byte[])tex.getBytes(), (int)8);
    }
}

