/*
 * Decompiled with CFR 0.152.
 */
package me.staufer.textools;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.Html;
import android.util.AttributeSet;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.net.URI;
import java.net.URISyntaxException;
import me.staufer.textools.MathViewInterface;
import me.staufer.textools.R;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MathView
extends WebView {
    private JSONObject options;
    private String tex;

    public MathView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.loadAttributes(context, attrs);
        this.initialize(context);
        if (this.tex != null) {
            this.loadWithTeX();
        } else {
            this.load();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initialize(Context context) {
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        this.addJavascriptInterface(new MathViewInterface(context), "MathViewInterface");
    }

    private void load() {
        URI uri = URI.create("file:///android_asset/index.html");
        try {
            uri = new URI("file", null, "///android_asset/index.html", "options=" + this.options.toString(), null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.loadUrl(uri.toString());
    }

    private void loadWithTeX() {
        URI uri = URI.create("file:///android_asset/index.html");
        try {
            uri = new URI("file", null, "///android_asset/index.html", "options=" + this.options.toString() + "&tex=" + this.tex, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.loadUrl(uri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(Context context, AttributeSet attrs) {
        this.options = new JSONObject();
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MathView, 0, 0);
        try {
            this.options.put("color", (Object)String.format("#%06X", 0xFFFFFF & styledAttributes.getColor(R.styleable.MathView_color, -16777216)));
            this.options.put("background", (Object)String.format("#%06X", 0xFFFFFF & styledAttributes.getColor(R.styleable.MathView_colorBackground, -1)));
            this.options.put("errorColor", (Object)String.format("#%06X", 0xFFFFFF & styledAttributes.getColor(R.styleable.MathView_colorError, Color.rgb((int)204, (int)0, (int)0))));
            this.options.put("displayMode", styledAttributes.getBoolean(R.styleable.MathView_displayMode, false));
            this.options.put("fleqn", styledAttributes.getBoolean(R.styleable.MathView_fleqn, false));
            this.options.put("leqno", styledAttributes.getBoolean(R.styleable.MathView_leqno, false));
            this.options.put("throwOnError", styledAttributes.getBoolean(R.styleable.MathView_throwOnError, false));
            this.tex = styledAttributes.getString(R.styleable.MathView_tex);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            styledAttributes.recycle();
        }
    }

    public void render(String tex) {
        tex = Html.escapeHtml((CharSequence)tex);
        tex = StringEscapeUtils.escapeEcmaScript((String)tex);
        this.loadUrl("javascript:update('" + tex + "')");
    }
}

