/*
 * Decompiled with CFR 0.152.
 */
package me.simple.state_adapter;

import android.content.Context;
import android.database.Observable;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.simple.state_adapter.StateViewHolder;
import me.simple.state_adapter.abs.StateEmptyView;
import me.simple.state_adapter.abs.StateErrorView;
import me.simple.state_adapter.abs.StateLoadingView;
import me.simple.state_adapter.abs.StateRetryView;
import me.simple.state_adapter.abs.StateView;

public class StateAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private RecyclerView.Adapter mRealAdapter;
    public static final int TYPE_STATE_NORMAL = -111;
    public static final int TYPE_STATE_LOADING = 111;
    public static final int TYPE_STATE_EMPTY = 222;
    public static final int TYPE_STATE_ERROR = 333;
    public static final int TYPE_STATE_RETRY = 444;
    public static final int TYPE_STATE_CONTENT = 555;
    private int mTypeState = -111;
    private SparseArray<StateView> mStateViewMap = new SparseArray();
    private SparseArray<View.OnClickListener> mViewClicks = new SparseArray();
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            StateAdapter.this.mTypeState = 555;
            StateAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            StateAdapter.this.mTypeState = 555;
            StateAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            StateAdapter.this.mTypeState = 555;
            StateAdapter.this.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            StateAdapter.this.mTypeState = 555;
            StateAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            StateAdapter.this.mTypeState = 555;
            StateAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            StateAdapter.this.mTypeState = 555;
            StateAdapter.this.notifyItemRangeChanged(fromPosition, toPosition, itemCount);
        }
    };

    private StateAdapter(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter can not be null");
        }
        this.mRealAdapter = adapter;
    }

    public static StateAdapter wrap(RecyclerView.Adapter adapter) {
        return new StateAdapter(adapter);
    }

    public int getItemCount() {
        if (this.isTypeState()) {
            return 1;
        }
        return this.mRealAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.isTypeState()) {
            return this.mTypeState;
        }
        return this.mRealAdapter.getItemViewType(position);
    }

    public long getItemId(int position) {
        if (position == 0 && this.isTypeState()) {
            return super.getItemId(position);
        }
        return this.mRealAdapter.getItemId(position);
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        if (this.isTypeState()) {
            StateView stateView = this.getStateView(this.mTypeState);
            LayoutInflater inflater = LayoutInflater.from((Context)viewGroup.getContext());
            View stateItemView = inflater.inflate(stateView.setLayoutRes(), viewGroup, false);
            StateViewHolder stateViewHolder = new StateViewHolder(stateItemView);
            stateView.onCreate(stateItemView);
            this.setClick(stateItemView, stateViewHolder);
            return stateViewHolder;
        }
        return this.mRealAdapter.onCreateViewHolder(viewGroup, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        this.onBindViewHolder(viewHolder, position, Collections.emptyList());
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position, List<Object> payloads) {
        if (viewHolder instanceof StateViewHolder) {
            StateViewHolder stateViewHolder = (StateViewHolder)viewHolder;
        } else {
            this.mRealAdapter.onBindViewHolder(viewHolder, position, payloads);
        }
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            return false;
        }
        return this.mRealAdapter.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            StateViewHolder stateViewHolder = (StateViewHolder)holder;
            stateViewHolder.setState(this.mTypeState);
            this.getStateView(this.mTypeState).onAttachedToWindow(stateViewHolder);
            return;
        }
        this.mRealAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            StateViewHolder stateViewHolder = (StateViewHolder)holder;
            int typeSate = stateViewHolder.getTypeSate();
            this.getStateView(typeSate).onDetachedFromWindow(stateViewHolder);
            return;
        }
        this.mRealAdapter.onViewDetachedFromWindow(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            return;
        }
        this.mRealAdapter.onViewRecycled(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.setFullSpan(recyclerView);
        if (!this.isRegistered()) {
            this.mRealAdapter.registerAdapterDataObserver(this.mDataObserver);
        }
        this.mRealAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (this.isRegistered()) {
            this.mRealAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mRealAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    private void setFullSpan(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager == null) {
            return;
        }
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gm = (GridLayoutManager)layoutManager;
            gm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int viewType = StateAdapter.this.getItemViewType(position);
                    if (StateAdapter.this.isTypeState()) {
                        return gm.getSpanCount();
                    }
                    return 1;
                }
            });
        }
    }

    private boolean isRegistered() {
        boolean isRegistered = false;
        try {
            Class<RecyclerView.Adapter> clazz = RecyclerView.Adapter.class;
            Field field = clazz.getDeclaredField("mObservable");
            field.setAccessible(true);
            Observable observable = (Observable)field.get(this.mRealAdapter);
            Field observersField = Observable.class.getDeclaredField("mObservers");
            observersField.setAccessible(true);
            ArrayList list = (ArrayList)observersField.get(observable);
            isRegistered = list.contains(this.mDataObserver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isRegistered;
    }

    public StateAdapter register(StateView stateView) {
        if (stateView instanceof StateEmptyView) {
            this.mStateViewMap.put(222, (Object)stateView);
        } else if (stateView instanceof StateLoadingView) {
            this.mStateViewMap.put(111, (Object)stateView);
        } else if (stateView instanceof StateErrorView) {
            this.mStateViewMap.put(333, (Object)stateView);
        } else if (stateView instanceof StateRetryView) {
            this.mStateViewMap.put(444, (Object)stateView);
        }
        return this;
    }

    private StateView getStateView(int type) {
        StateView stateView = (StateView)this.mStateViewMap.get(type);
        if (stateView == null) {
            throw new NullPointerException("do you have register this type? type is" + this.getTypeName(this.mTypeState));
        }
        return stateView;
    }

    private String getTypeName(int type) {
        String typeName = "";
        switch (type) {
            case 222: {
                typeName = "EMPTY";
                break;
            }
            case 111: {
                typeName = "LOADING";
                break;
            }
            case 333: {
                typeName = "ERROR";
                break;
            }
            case 444: {
                typeName = "RETRY";
            }
        }
        return typeName;
    }

    public void showLoading() {
        this.mTypeState = 111;
        this.notifyStateVH();
    }

    public void showEmpty() {
        this.mTypeState = 222;
        this.notifyStateVH();
    }

    public void showError() {
        this.mTypeState = 333;
        this.notifyStateVH();
    }

    public void showRetry() {
        this.mTypeState = 444;
        this.notifyStateVH();
    }

    public void showContent() {
        this.mTypeState = 555;
        this.notifyDataSetChanged();
    }

    private void notifyStateVH() {
        this.notifyDataSetChanged();
    }

    private boolean isTypeState() {
        return this.mTypeState == 111 || this.mTypeState == 222 || this.mTypeState == 333 || this.mTypeState == 444;
    }

    private void setClick(View itemView, StateViewHolder stateViewHolder) {
        for (int i = 0; i < this.mViewClicks.size(); ++i) {
            int viewId = this.mViewClicks.keyAt(i);
            View.OnClickListener clickListener = (View.OnClickListener)this.mViewClicks.valueAt(i);
            View child = itemView.findViewById(viewId);
            if (child == null) continue;
            child.setOnClickListener(clickListener);
        }
    }

    public StateAdapter setOnItemViewClickListener(int viewId, View.OnClickListener listener) {
        this.mViewClicks.put(viewId, (Object)listener);
        return this;
    }
}

