package me.simple.state_adapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import android.view.View;
import android.view.ViewGroup;

public class StateViewHolder extends RecyclerView.ViewHolder {

    private int mTypeState;

    public StateViewHolder(@NonNull View itemView) {
        super(itemView);
        ViewGroup.LayoutParams params = itemView.getLayoutParams();
        if (params instanceof StaggeredGridLayoutManager.LayoutParams) {
            ((StaggeredGridLayoutManager.LayoutParams) params).setFullSpan(true);
        }
    }

    public void setState(int typeState) {
        this.mTypeState = typeState;
    }

    public int getTypeSate() {
        return mTypeState;
    }
}
