/*
 * Decompiled with CFR 0.152.
 */
package me.shaohui.advancedluban;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.support.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import me.shaohui.advancedluban.LubanBuilder;
import me.shaohui.advancedluban.Preconditions;
import rx.Observable;
import rx.functions.FuncN;
import rx.schedulers.Schedulers;

class LubanCompresser {
    private static final String TAG = "Luban Compress";
    private final LubanBuilder mLuban;
    private ByteArrayOutputStream mByteArrayOutputStream;

    LubanCompresser(LubanBuilder luban) {
        this.mLuban = luban;
    }

    Observable<File> singleAction(final File file) {
        return Observable.fromCallable((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return LubanCompresser.this.compressImage(((LubanCompresser)LubanCompresser.this).mLuban.gear, file);
            }
        }).subscribeOn(Schedulers.computation());
    }

    Observable<List<File>> multiAction(List<File> files) {
        ArrayList<Observable> observables = new ArrayList<Observable>(files.size());
        for (final File file : files) {
            observables.add(Observable.fromCallable((Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return LubanCompresser.this.compressImage(((LubanCompresser)LubanCompresser.this).mLuban.gear, file);
                }
            }));
        }
        return Observable.zip(observables, (FuncN)new FuncN<List<File>>(){

            public List<File> call(Object ... args) {
                ArrayList<File> files = new ArrayList<File>(args.length);
                for (Object o : args) {
                    files.add((File)o);
                }
                return files;
            }
        }).subscribeOn(Schedulers.computation());
    }

    private File compressImage(int gear, File file) throws IOException {
        switch (gear) {
            case 3: {
                return this.thirdCompress(file);
            }
            case 4: {
                return this.customCompress(file);
            }
            case 1: {
                return this.firstCompress(file);
            }
        }
        return file;
    }

    private File thirdCompress(@NonNull File file) throws IOException {
        double size;
        int thumbH;
        int height;
        String thumb = this.getCacheFilePath();
        String filePath = file.getAbsolutePath();
        int angle = this.getImageSpinAngle(filePath);
        int width = LubanCompresser.getImageSize(filePath)[0];
        boolean flip = width > (height = LubanCompresser.getImageSize(filePath)[1]);
        int thumbW = width % 2 == 1 ? width + 1 : width;
        double scale = (double)(width = thumbW > (thumbH = height % 2 == 1 ? height + 1 : height) ? thumbH : thumbW) / (double)(height = thumbW > thumbH ? thumbW : thumbH);
        if (scale <= 1.0 && scale > 0.5625) {
            if (height < 1664) {
                if (file.length() / 1024L < 150L) {
                    return file;
                }
                size = (double)(width * height) / Math.pow(1664.0, 2.0) * 150.0;
                size = size < 60.0 ? 60.0 : size;
            } else if (height >= 1664 && height < 4990) {
                thumbW = width / 2;
                thumbH = height / 2;
                size = (double)(thumbW * thumbH) / Math.pow(2495.0, 2.0) * 300.0;
                size = size < 60.0 ? 60.0 : size;
            } else if (height >= 4990 && height < 10240) {
                thumbW = width / 4;
                thumbH = height / 4;
                size = (double)(thumbW * thumbH) / Math.pow(2560.0, 2.0) * 300.0;
                size = size < 100.0 ? 100.0 : size;
            } else {
                int multiple = height / 1280 == 0 ? 1 : height / 1280;
                thumbW = width / multiple;
                thumbH = height / multiple;
                size = (double)(thumbW * thumbH) / Math.pow(2560.0, 2.0) * 300.0;
                size = size < 100.0 ? 100.0 : size;
            }
        } else if (scale <= 0.5625 && scale > 0.5) {
            if (height < 1280 && file.length() / 1024L < 200L) {
                return file;
            }
            int multiple = height / 1280 == 0 ? 1 : height / 1280;
            thumbW = width / multiple;
            thumbH = height / multiple;
            size = (double)(thumbW * thumbH) / 3686400.0 * 400.0;
            size = size < 100.0 ? 100.0 : size;
        } else {
            int multiple = (int)Math.ceil((double)height / (1280.0 / scale));
            thumbW = width / multiple;
            size = (double)(thumbW * (thumbH = height / multiple)) / (1280.0 * (1280.0 / scale)) * 500.0;
            size = size < 100.0 ? 100.0 : size;
        }
        return this.compress(filePath, thumb, flip ? thumbH : thumbW, flip ? thumbW : thumbH, angle, (long)size);
    }

    private File firstCompress(@NonNull File file) throws IOException {
        int minSize = 60;
        int longSide = 720;
        int shortSide = 1280;
        String thumbFilePath = this.getCacheFilePath();
        String filePath = file.getAbsolutePath();
        long size = 0L;
        long maxSize = file.length() / 5L;
        int angle = this.getImageSpinAngle(filePath);
        int[] imgSize = LubanCompresser.getImageSize(filePath);
        int width = 0;
        int height = 0;
        if (imgSize[0] <= imgSize[1]) {
            double scale = (double)imgSize[0] / (double)imgSize[1];
            if (scale <= 1.0 && scale > 0.5625) {
                width = imgSize[0] > shortSide ? shortSide : imgSize[0];
                height = width * imgSize[1] / imgSize[0];
                size = minSize;
            } else if (scale <= 0.5625) {
                height = imgSize[1] > longSide ? longSide : imgSize[1];
                width = height * imgSize[0] / imgSize[1];
                size = maxSize;
            }
        } else {
            double scale = (double)imgSize[1] / (double)imgSize[0];
            if (scale <= 1.0 && scale > 0.5625) {
                height = imgSize[1] > shortSide ? shortSide : imgSize[1];
                width = height * imgSize[0] / imgSize[1];
                size = minSize;
            } else if (scale <= 0.5625) {
                width = imgSize[0] > longSide ? longSide : imgSize[0];
                height = width * imgSize[1] / imgSize[0];
                size = maxSize;
            }
        }
        return this.compress(filePath, thumbFilePath, width, height, angle, size);
    }

    private File customCompress(@NonNull File file) throws IOException {
        float scale;
        String thumbFilePath = this.getCacheFilePath();
        String filePath = file.getAbsolutePath();
        int angle = this.getImageSpinAngle(filePath);
        long fileSize = this.mLuban.maxSize > 0 && (long)this.mLuban.maxSize < file.length() / 1024L ? (long)this.mLuban.maxSize : file.length() / 1024L;
        int[] size = LubanCompresser.getImageSize(filePath);
        int width = size[0];
        int height = size[1];
        if (this.mLuban.maxSize > 0 && (float)this.mLuban.maxSize < (float)file.length() / 1024.0f) {
            scale = (float)Math.sqrt((float)file.length() / 1024.0f / (float)this.mLuban.maxSize);
            width = (int)((float)width / scale);
            height = (int)((float)height / scale);
        }
        if (this.mLuban.maxWidth > 0) {
            width = Math.min(width, this.mLuban.maxWidth);
        }
        if (this.mLuban.maxHeight > 0) {
            height = Math.min(height, this.mLuban.maxHeight);
        }
        scale = Math.min((float)width / (float)size[0], (float)height / (float)size[1]);
        width = (int)((float)size[0] * scale);
        height = (int)((float)size[1] * scale);
        if ((float)this.mLuban.maxSize > (float)file.length() / 1024.0f && scale == 1.0f) {
            return file;
        }
        return this.compress(filePath, thumbFilePath, width, height, angle, fileSize);
    }

    private String getCacheFilePath() {
        StringBuilder name = new StringBuilder("Luban_" + System.currentTimeMillis());
        if (this.mLuban.compressFormat == Bitmap.CompressFormat.WEBP) {
            name.append(".webp");
        } else {
            name.append(".jpg");
        }
        return this.mLuban.cacheDir.getAbsolutePath() + File.separator + name;
    }

    public static int[] getImageSize(String imagePath) {
        int[] res = new int[2];
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        res[0] = options.outWidth;
        res[1] = options.outHeight;
        return res;
    }

    private Bitmap compress(String imagePath, int width, int height) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        int outH = options.outHeight;
        int outW = options.outWidth;
        int inSampleSize = 1;
        while (outH / inSampleSize > height || outW / inSampleSize > width) {
            inSampleSize *= 2;
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
    }

    private int getImageSpinAngle(String path) throws IOException {
        int degree = 0;
        ExifInterface exifInterface = new ExifInterface(path);
        int orientation = exifInterface.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                degree = 90;
                break;
            }
            case 3: {
                degree = 180;
                break;
            }
            case 8: {
                degree = 270;
            }
        }
        return degree;
    }

    private File compress(String largeImagePath, String thumbFilePath, int width, int height, int angle, long size) throws IOException {
        Bitmap thbBitmap = this.compress(largeImagePath, width, height);
        thbBitmap = LubanCompresser.rotatingImage(angle, thbBitmap);
        return this.saveImage(thumbFilePath, thbBitmap, size);
    }

    private static Bitmap rotatingImage(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private File saveImage(String filePath, Bitmap bitmap, long size) throws IOException {
        Preconditions.checkNotNull(bitmap, "Luban Compressbitmap cannot be null");
        File result = new File(filePath.substring(0, filePath.lastIndexOf("/")));
        if (!result.exists() && !result.mkdirs()) {
            return null;
        }
        if (this.mByteArrayOutputStream == null) {
            this.mByteArrayOutputStream = new ByteArrayOutputStream(bitmap.getWidth() * bitmap.getHeight());
        } else {
            this.mByteArrayOutputStream.reset();
        }
        int options = 100;
        bitmap.compress(this.mLuban.compressFormat, options, (OutputStream)this.mByteArrayOutputStream);
        while ((long)(this.mByteArrayOutputStream.size() / 1024) > size && options > 6) {
            this.mByteArrayOutputStream.reset();
            bitmap.compress(this.mLuban.compressFormat, options -= 6, (OutputStream)this.mByteArrayOutputStream);
        }
        bitmap.recycle();
        FileOutputStream fos = new FileOutputStream(filePath);
        this.mByteArrayOutputStream.writeTo(fos);
        fos.close();
        return new File(filePath);
    }
}

