/*
 * Decompiled with CFR 0.152.
 */
package me.saket.telephoto.subsamplingimage;

import android.content.Context;
import android.graphics.BitmapRegionDecoder;
import android.os.ParcelFileDescriptor;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.ImageBitmap;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import me.saket.telephoto.subsamplingimage.SubSamplingImageSource;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bH\u00c6\u0001J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0019\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lme/saket/telephoto/subsamplingimage/FileImageSource;", "Lme/saket/telephoto/subsamplingimage/SubSamplingImageSource;", "path", "Lokio/Path;", "preview", "Landroidx/compose/ui/graphics/ImageBitmap;", "onClose", "Ljava/io/Closeable;", "Lokio/Closeable;", "(Lokio/Path;Landroidx/compose/ui/graphics/ImageBitmap;Ljava/io/Closeable;)V", "getOnClose", "()Ljava/io/Closeable;", "getPath", "()Lokio/Path;", "getPreview", "()Landroidx/compose/ui/graphics/ImageBitmap;", "close", "", "component1", "component2", "component3", "copy", "decoder", "Landroid/graphics/BitmapRegionDecoder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "toString", "", "sub-sampling-image_release"})
@Immutable
public final class FileImageSource
implements SubSamplingImageSource {
    @NotNull
    private final Path path;
    @Nullable
    private final ImageBitmap preview;
    @Nullable
    private final Closeable onClose;
    public static final int $stable;

    public FileImageSource(@NotNull Path path, @Nullable ImageBitmap preview, @Nullable Closeable onClose) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.preview = preview;
        this.onClose = onClose;
        if (!this.path.isAbsolute()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public ImageBitmap getPreview() {
        return this.preview;
    }

    @Nullable
    public final Closeable getOnClose() {
        return this.onClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object decoder(@NotNull Context context, @NotNull Continuation<? super BitmapRegionDecoder> $completion) {
        BitmapRegionDecoder bitmapRegionDecoder;
        Closeable closeable = (Closeable)ParcelFileDescriptor.open((File)this.path.toFile(), (int)0x10000000);
        Throwable throwable = null;
        try {
            ParcelFileDescriptor fd = (ParcelFileDescriptor)closeable;
            boolean bl = false;
            BitmapRegionDecoder bitmapRegionDecoder2 = BitmapRegionDecoder.newInstance((FileDescriptor)fd.getFileDescriptor(), (boolean)false);
            bitmapRegionDecoder = bitmapRegionDecoder2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmapRegionDecoder, (String)"use(...)");
        return bitmapRegionDecoder;
    }

    @Override
    public void close() {
        block0: {
            Closeable closeable = this.onClose;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    @NotNull
    public final Path component1() {
        return this.path;
    }

    @Nullable
    public final ImageBitmap component2() {
        return this.preview;
    }

    @Nullable
    public final Closeable component3() {
        return this.onClose;
    }

    @NotNull
    public final FileImageSource copy(@NotNull Path path, @Nullable ImageBitmap preview, @Nullable Closeable onClose) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new FileImageSource(path, preview, onClose);
    }

    public static /* synthetic */ FileImageSource copy$default(FileImageSource fileImageSource, Path path, ImageBitmap imageBitmap, Closeable closeable, int n, Object object) {
        if ((n & 1) != 0) {
            path = fileImageSource.path;
        }
        if ((n & 2) != 0) {
            imageBitmap = fileImageSource.preview;
        }
        if ((n & 4) != 0) {
            closeable = fileImageSource.onClose;
        }
        return fileImageSource.copy(path, imageBitmap, closeable);
    }

    @NotNull
    public String toString() {
        return "FileImageSource(path=" + this.path + ", preview=" + this.preview + ", onClose=" + this.onClose + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + (this.preview == null ? 0 : this.preview.hashCode());
        result = result * 31 + (this.onClose == null ? 0 : this.onClose.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileImageSource)) {
            return false;
        }
        FileImageSource fileImageSource = (FileImageSource)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)fileImageSource.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preview, (Object)fileImageSource.preview)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.onClose, (Object)fileImageSource.onClose);
    }
}

