/*
 * Decompiled with CFR 0.152.
 */
package me.rosuh.filepicker.utils;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.rosuh.filepicker.R;
import me.rosuh.filepicker.bean.BeanSubscriber;
import me.rosuh.filepicker.bean.FileItemBeanImpl;
import me.rosuh.filepicker.bean.FileNavBeanImpl;
import me.rosuh.filepicker.config.AbstractFileFilter;
import me.rosuh.filepicker.config.AbstractFileType;
import me.rosuh.filepicker.config.FilePickerManager;
import me.rosuh.filepicker.utils.FileUtils;
import me.rosuh.filepicker.utils.FileUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lme/rosuh/filepicker/utils/FileUtils;", "", "()V", "Companion", "filepicker_release"})
public final class FileUtils {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J&\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ>\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0006j\b\u0012\u0004\u0012\u00020\r`\b2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0006j\b\u0012\u0004\u0012\u00020\r`\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lme/rosuh/filepicker/utils/FileUtils$Companion;", "", "()V", "getRootFile", "Ljava/io/File;", "produceListDataSource", "Ljava/util/ArrayList;", "Lme/rosuh/filepicker/bean/FileItemBeanImpl;", "Lkotlin/collections/ArrayList;", "rootFile", "beanSubscriber", "Lme/rosuh/filepicker/bean/BeanSubscriber;", "produceNavDataSource", "Lme/rosuh/filepicker/bean/FileNavBeanImpl;", "currentDataSource", "nextPath", "", "context", "Landroid/content/Context;", "filepicker_release"})
    public static final class Companion {
        @NotNull
        public final File getRootFile() {
            File file;
            switch (FilePickerManager.INSTANCE.getConfig$filepicker_release().getMediaStorageType$filepicker_release()) {
                case "STORAGE_EXTERNAL_STORAGE": {
                    File file2 = Environment.getExternalStorageDirectory();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"Environment.getExternalStorageDirectory()");
                    file = new File(file2.getAbsoluteFile().toURI());
                    break;
                }
                case "STORAGE_CUSTOM_ROOT_PATH": {
                    CharSequence charSequence = FilePickerManager.INSTANCE.getConfig$filepicker_release().getCustomRootPath$filepicker_release();
                    boolean bl = false;
                    if (charSequence.length() == 0) {
                        File file3 = Environment.getExternalStorageDirectory();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"Environment.getExternalStorageDirectory()");
                        file = new File(file3.getAbsoluteFile().toURI());
                        break;
                    }
                    file = new File(FilePickerManager.INSTANCE.getConfig$filepicker_release().getCustomRootPath$filepicker_release());
                    break;
                }
                default: {
                    File file4 = Environment.getExternalStorageDirectory();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"Environment.getExternalStorageDirectory()");
                    file = new File(file4.getAbsoluteFile().toURI());
                }
            }
            return file;
        }

        @NotNull
        public final ArrayList<FileItemBeanImpl> produceListDataSource(@NotNull File rootFile, @NotNull BeanSubscriber beanSubscriber) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"rootFile");
            Intrinsics.checkParameterIsNotNull((Object)beanSubscriber, (String)"beanSubscriber");
            ArrayList<FileItemBeanImpl> listData = new ArrayList<FileItemBeanImpl>();
            File[] fileArray = rootFile.listFiles();
            int n2 = fileArray.length;
            for (n = 0; n < n2; ++n) {
                File file;
                File file2 = file = fileArray[n];
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                String string2 = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
                boolean isHiddenFile = StringsKt.startsWith$default((String)string2, (String)".", (boolean)false, (int)2, null);
                if (file.isDirectory()) {
                    String string3 = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.name");
                    String string4 = file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"file.path");
                    listData.add(new FileItemBeanImpl(string3, string4, false, null, true, isHiddenFile, beanSubscriber));
                    continue;
                }
                String string5 = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"file.name");
                String string6 = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"file.path");
                FileItemBeanImpl itemBean = new FileItemBeanImpl(string5, string6, false, null, false, isHiddenFile, beanSubscriber);
                Object object = FilePickerManager.INSTANCE.getConfig$filepicker_release().getSelfFileType$filepicker_release();
                if (object == null || (object = ((AbstractFileType)object).fillFileType(itemBean)) == null) {
                    object = FilePickerManager.INSTANCE.getConfig$filepicker_release().getDefaultFileType$filepicker_release().fillFileType(itemBean);
                }
                listData.add(itemBean);
            }
            ArrayList<FileItemBeanImpl> arrayList = listData;
            n = 0;
            boolean bl = false;
            ArrayList<FileItemBeanImpl> $this$run = arrayList;
            boolean bl2 = false;
            FileUtilsKt.access$hideFiles($this$run, !FilePickerManager.INSTANCE.getConfig$filepicker_release().isShowHiddenFiles$filepicker_release());
            CollectionsKt.sortWith((List)$this$run, (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{produceListDataSource.1.1.INSTANCE, produceListDataSource.1.2.INSTANCE}));
            Object object = FilePickerManager.INSTANCE.getConfig$filepicker_release().getSelfFilter$filepicker_release();
            if (object == null || (object = ((AbstractFileFilter)object).doFilter(listData)) == null) {
                object = listData;
            }
            return object;
        }

        @NotNull
        public final ArrayList<FileNavBeanImpl> produceNavDataSource(@NotNull ArrayList<FileNavBeanImpl> currentDataSource, @NotNull String nextPath, @NotNull Context context) {
            Intrinsics.checkParameterIsNotNull(currentDataSource, (String)"currentDataSource");
            Intrinsics.checkParameterIsNotNull((Object)nextPath, (String)"nextPath");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (currentDataSource.isEmpty()) {
                String string2;
                CharSequence charSequence = FilePickerManager.INSTANCE.getConfig$filepicker_release().getMediaStorageName$filepicker_release();
                ArrayList<FileNavBeanImpl> arrayList = currentDataSource;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = charSequence == null || charSequence.length() == 0;
                ArrayList<FileNavBeanImpl> arrayList2 = arrayList;
                if (!bl3) {
                    string2 = FilePickerManager.INSTANCE.getConfig$filepicker_release().getMediaStorageName$filepicker_release();
                } else {
                    charSequence = FilePickerManager.INSTANCE.getConfig$filepicker_release().getCustomRootPath$filepicker_release();
                    arrayList = arrayList2;
                    bl = false;
                    bl3 = charSequence.length() == 0;
                    arrayList2 = arrayList;
                    string2 = !bl3 ? FilePickerManager.INSTANCE.getConfig$filepicker_release().getCustomRootPath$filepicker_release() : context.getString(R.string.file_picker_tv_sd_card);
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (!FilePickerManager.c\u2026                        }");
                String string3 = nextPath;
                String string4 = string2;
                arrayList2.add(new FileNavBeanImpl(string4, string3));
                return currentDataSource;
            }
            for (FileNavBeanImpl data : currentDataSource) {
                if (Intrinsics.areEqual((Object)nextPath, (Object)((FileNavBeanImpl)CollectionsKt.first((List)currentDataSource)).getDirPath())) {
                    return new ArrayList<FileNavBeanImpl>((Collection)currentDataSource.subList(0, 1));
                }
                boolean isCurrent = Intrinsics.areEqual((Object)nextPath, (Object)currentDataSource.get(currentDataSource.size() - 1).getDirPath());
                if (isCurrent) {
                    return currentDataSource;
                }
                boolean isBackToAbove = Intrinsics.areEqual((Object)nextPath, (Object)data.getDirPath());
                if (!isBackToAbove) continue;
                return new ArrayList<FileNavBeanImpl>((Collection)currentDataSource.subList(0, currentDataSource.indexOf(data) + 1));
            }
            String string5 = nextPath;
            int n = StringsKt.lastIndexOf$default((CharSequence)nextPath, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
            ArrayList<FileNavBeanImpl> arrayList = currentDataSource;
            boolean bl = false;
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String string7 = string6;
            String string8 = nextPath;
            String string9 = string7;
            arrayList.add(new FileNavBeanImpl(string9, string8));
            return currentDataSource;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

