/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import me.relex.circleindicator.Config;
import me.relex.circleindicator.R;

class BaseCircleIndicator
extends LinearLayout {
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    protected int mIndicatorMargin = -1;
    protected int mIndicatorWidth = -1;
    protected int mIndicatorHeight = -1;
    protected int mIndicatorBackgroundResId;
    protected int mIndicatorUnselectedBackgroundResId;
    protected ColorStateList mIndicatorTintColor;
    protected ColorStateList mIndicatorTintUnselectedColor;
    protected Animator mAnimatorOut;
    protected Animator mAnimatorIn;
    protected Animator mImmediateAnimatorOut;
    protected Animator mImmediateAnimatorIn;
    protected int mLastPosition = -1;
    @Nullable
    private IndicatorCreatedListener mIndicatorCreatedListener;

    public BaseCircleIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public BaseCircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BaseCircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public BaseCircleIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        Config config = this.handleTypedArray(context, attrs);
        this.initialize(config);
        if (this.isInEditMode()) {
            this.createIndicators(3, 1);
        }
    }

    private Config handleTypedArray(Context context, AttributeSet attrs) {
        Config config = new Config();
        if (attrs == null) {
            return config;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BaseCircleIndicator);
        config.width = typedArray.getDimensionPixelSize(R.styleable.BaseCircleIndicator_ci_width, -1);
        config.height = typedArray.getDimensionPixelSize(R.styleable.BaseCircleIndicator_ci_height, -1);
        config.margin = typedArray.getDimensionPixelSize(R.styleable.BaseCircleIndicator_ci_margin, -1);
        config.animatorResId = typedArray.getResourceId(R.styleable.BaseCircleIndicator_ci_animator, R.animator.scale_with_alpha);
        config.animatorReverseResId = typedArray.getResourceId(R.styleable.BaseCircleIndicator_ci_animator_reverse, 0);
        config.backgroundResId = typedArray.getResourceId(R.styleable.BaseCircleIndicator_ci_drawable, R.drawable.white_radius);
        config.unselectedBackgroundId = typedArray.getResourceId(R.styleable.BaseCircleIndicator_ci_drawable_unselected, config.backgroundResId);
        config.orientation = typedArray.getInt(R.styleable.BaseCircleIndicator_ci_orientation, -1);
        config.gravity = typedArray.getInt(R.styleable.BaseCircleIndicator_ci_gravity, -1);
        typedArray.recycle();
        return config;
    }

    public void initialize(Config config) {
        int miniSize = (int)(TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) + 0.5f);
        this.mIndicatorWidth = config.width < 0 ? miniSize : config.width;
        this.mIndicatorHeight = config.height < 0 ? miniSize : config.height;
        this.mIndicatorMargin = config.margin < 0 ? miniSize : config.margin;
        this.mAnimatorOut = this.createAnimatorOut(config);
        this.mImmediateAnimatorOut = this.createAnimatorOut(config);
        this.mImmediateAnimatorOut.setDuration(0L);
        this.mAnimatorIn = this.createAnimatorIn(config);
        this.mImmediateAnimatorIn = this.createAnimatorIn(config);
        this.mImmediateAnimatorIn.setDuration(0L);
        this.mIndicatorBackgroundResId = config.backgroundResId == 0 ? R.drawable.white_radius : config.backgroundResId;
        this.mIndicatorUnselectedBackgroundResId = config.unselectedBackgroundId == 0 ? config.backgroundResId : config.unselectedBackgroundId;
        this.setOrientation(config.orientation == 1 ? 1 : 0);
        this.setGravity(config.gravity >= 0 ? config.gravity : 17);
    }

    public void tintIndicator(@ColorInt int indicatorColor) {
        this.tintIndicator(indicatorColor, indicatorColor);
    }

    public void tintIndicator(@ColorInt int indicatorColor, @ColorInt int unselectedIndicatorColor) {
        this.mIndicatorTintColor = ColorStateList.valueOf((int)indicatorColor);
        this.mIndicatorTintUnselectedColor = ColorStateList.valueOf((int)unselectedIndicatorColor);
        this.changeIndicatorBackground();
    }

    public void changeIndicatorResource(@DrawableRes int indicatorResId) {
        this.changeIndicatorResource(indicatorResId, indicatorResId);
    }

    public void changeIndicatorResource(@DrawableRes int indicatorResId, @DrawableRes int indicatorUnselectedResId) {
        this.mIndicatorBackgroundResId = indicatorResId;
        this.mIndicatorUnselectedBackgroundResId = indicatorUnselectedResId;
        this.changeIndicatorBackground();
    }

    public void setIndicatorCreatedListener(@Nullable IndicatorCreatedListener indicatorCreatedListener) {
        this.mIndicatorCreatedListener = indicatorCreatedListener;
    }

    protected Animator createAnimatorOut(Config config) {
        return AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.animatorResId);
    }

    protected Animator createAnimatorIn(Config config) {
        Animator animatorIn;
        if (config.animatorReverseResId == 0) {
            animatorIn = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.animatorResId);
            animatorIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
        } else {
            animatorIn = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.animatorReverseResId);
        }
        return animatorIn;
    }

    public void createIndicators(int count, int currentPosition) {
        int childViewCount;
        if (this.mImmediateAnimatorOut.isRunning()) {
            this.mImmediateAnimatorOut.end();
            this.mImmediateAnimatorOut.cancel();
        }
        if (this.mImmediateAnimatorIn.isRunning()) {
            this.mImmediateAnimatorIn.end();
            this.mImmediateAnimatorIn.cancel();
        }
        if (count < (childViewCount = this.getChildCount())) {
            this.removeViews(count, childViewCount - count);
        } else if (count > childViewCount) {
            int addCount = count - childViewCount;
            int orientation = this.getOrientation();
            for (int i = 0; i < addCount; ++i) {
                this.addIndicator(orientation);
            }
        }
        for (int i = 0; i < count; ++i) {
            View indicator = this.getChildAt(i);
            if (currentPosition == i) {
                this.bindIndicatorBackground(indicator, this.mIndicatorBackgroundResId, this.mIndicatorTintColor);
                this.mImmediateAnimatorOut.setTarget((Object)indicator);
                this.mImmediateAnimatorOut.start();
                this.mImmediateAnimatorOut.end();
            } else {
                this.bindIndicatorBackground(indicator, this.mIndicatorUnselectedBackgroundResId, this.mIndicatorTintUnselectedColor);
                this.mImmediateAnimatorIn.setTarget((Object)indicator);
                this.mImmediateAnimatorIn.start();
                this.mImmediateAnimatorIn.end();
            }
            if (this.mIndicatorCreatedListener == null) continue;
            this.mIndicatorCreatedListener.onIndicatorCreated(indicator, i);
        }
        this.mLastPosition = currentPosition;
    }

    protected void addIndicator(int orientation) {
        View indicator = new View(this.getContext());
        LinearLayout.LayoutParams params = this.generateDefaultLayoutParams();
        params.width = this.mIndicatorWidth;
        params.height = this.mIndicatorHeight;
        if (orientation == 0) {
            params.leftMargin = this.mIndicatorMargin;
            params.rightMargin = this.mIndicatorMargin;
        } else {
            params.topMargin = this.mIndicatorMargin;
            params.bottomMargin = this.mIndicatorMargin;
        }
        this.addView(indicator, (ViewGroup.LayoutParams)params);
    }

    public void animatePageSelected(int position) {
        View selectedIndicator;
        View currentIndicator;
        if (this.mLastPosition == position) {
            return;
        }
        if (this.mAnimatorIn.isRunning()) {
            this.mAnimatorIn.end();
            this.mAnimatorIn.cancel();
        }
        if (this.mAnimatorOut.isRunning()) {
            this.mAnimatorOut.end();
            this.mAnimatorOut.cancel();
        }
        if (this.mLastPosition >= 0 && (currentIndicator = this.getChildAt(this.mLastPosition)) != null) {
            this.bindIndicatorBackground(currentIndicator, this.mIndicatorUnselectedBackgroundResId, this.mIndicatorTintUnselectedColor);
            this.mAnimatorIn.setTarget((Object)currentIndicator);
            this.mAnimatorIn.start();
        }
        if ((selectedIndicator = this.getChildAt(position)) != null) {
            this.bindIndicatorBackground(selectedIndicator, this.mIndicatorBackgroundResId, this.mIndicatorTintColor);
            this.mAnimatorOut.setTarget((Object)selectedIndicator);
            this.mAnimatorOut.start();
        }
        this.mLastPosition = position;
    }

    protected void changeIndicatorBackground() {
        int count = this.getChildCount();
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            View currentIndicator = this.getChildAt(i);
            if (i == this.mLastPosition) {
                this.bindIndicatorBackground(currentIndicator, this.mIndicatorBackgroundResId, this.mIndicatorTintColor);
                continue;
            }
            this.bindIndicatorBackground(currentIndicator, this.mIndicatorUnselectedBackgroundResId, this.mIndicatorTintUnselectedColor);
        }
    }

    private void bindIndicatorBackground(View view, @DrawableRes int drawableRes, @Nullable ColorStateList tintColor) {
        if (tintColor != null) {
            Drawable indicatorDrawable = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)this.getContext(), (int)drawableRes).mutate());
            DrawableCompat.setTintList((Drawable)indicatorDrawable, (ColorStateList)tintColor);
            ViewCompat.setBackground((View)view, (Drawable)indicatorDrawable);
        } else {
            view.setBackgroundResource(drawableRes);
        }
    }

    protected static class ReverseInterpolator
    implements Interpolator {
        protected ReverseInterpolator() {
        }

        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }

    public static interface IndicatorCreatedListener {
        public void onIndicatorCreated(View var1, int var2);
    }
}

