/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AnimatorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import me.relex.circleindicator.R;

public class CircleIndicator
extends LinearLayout
implements ViewPager.OnPageChangeListener {
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    private ViewPager mViewpager;
    private int mIndicatorMargin = -1;
    private int mIndicatorWidth = -1;
    private int mIndicatorHeight = -1;
    private int mAnimatorResId = R.animator.scale_with_alpha;
    private int mAnimatorReverseResId = 0;
    private int mIndicatorBackgroundResId = R.drawable.white_radius;
    private int mIndicatorUnselectedBackgroundResId = R.drawable.white_radius;
    private int mCurrentPosition = 0;
    private Animator mAnimationOut;
    private Animator mAnimationIn;

    public CircleIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setOrientation(0);
        this.setGravity(17);
        this.handleTypedArray(context, attrs);
        this.checkIndicatorConfig(context);
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleIndicator);
        this.mIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_width, -1);
        this.mIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_height, -1);
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_margin, -1);
        this.mAnimatorResId = typedArray.getResourceId(R.styleable.CircleIndicator_ci_animator, R.animator.scale_with_alpha);
        this.mAnimatorReverseResId = typedArray.getResourceId(R.styleable.CircleIndicator_ci_animator_reverse, 0);
        this.mIndicatorBackgroundResId = typedArray.getResourceId(R.styleable.CircleIndicator_ci_drawable, R.drawable.white_radius);
        this.mIndicatorUnselectedBackgroundResId = typedArray.getResourceId(R.styleable.CircleIndicator_ci_drawable_unselected, this.mIndicatorBackgroundResId);
        typedArray.recycle();
    }

    public void configureIndicator(int indicatorWidth, int indicatorHeight, int indicatorMargin) {
        this.configureIndicator(indicatorWidth, indicatorHeight, indicatorMargin, R.animator.scale_with_alpha, 0, R.drawable.white_radius, R.drawable.white_radius);
    }

    public void configureIndicator(int indicatorWidth, int indicatorHeight, int indicatorMargin, @AnimatorRes int animatorId, @AnimatorRes int animatorReverseId, @DrawableRes int indicatorBackgroundId, @DrawableRes int indicatorUnselectedBackgroundId) {
        this.mIndicatorWidth = indicatorWidth;
        this.mIndicatorHeight = indicatorHeight;
        this.mIndicatorMargin = indicatorMargin;
        this.mAnimatorResId = animatorId;
        this.mAnimatorReverseResId = animatorReverseId;
        this.mIndicatorBackgroundResId = indicatorBackgroundId;
        this.mIndicatorUnselectedBackgroundResId = indicatorUnselectedBackgroundId;
        this.checkIndicatorConfig(this.getContext());
    }

    private void checkIndicatorConfig(Context context) {
        this.mIndicatorWidth = this.mIndicatorWidth < 0 ? this.dip2px(5.0f) : this.mIndicatorWidth;
        this.mIndicatorHeight = this.mIndicatorHeight < 0 ? this.dip2px(5.0f) : this.mIndicatorHeight;
        this.mIndicatorMargin = this.mIndicatorMargin < 0 ? this.dip2px(5.0f) : this.mIndicatorMargin;
        this.mAnimatorResId = this.mAnimatorResId == 0 ? R.animator.scale_with_alpha : this.mAnimatorResId;
        this.mAnimationOut = AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorResId);
        if (this.mAnimatorReverseResId == 0) {
            this.mAnimationIn = AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorResId);
            this.mAnimationIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
        } else {
            this.mAnimationIn = AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorReverseResId);
        }
        this.mIndicatorBackgroundResId = this.mIndicatorBackgroundResId == 0 ? R.drawable.white_radius : this.mIndicatorBackgroundResId;
        this.mIndicatorUnselectedBackgroundResId = this.mIndicatorUnselectedBackgroundResId == 0 ? this.mIndicatorBackgroundResId : this.mIndicatorUnselectedBackgroundResId;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewpager = viewPager;
        this.mCurrentPosition = this.mViewpager.getCurrentItem();
        this.createIndicators(viewPager);
        this.mViewpager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mViewpager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.onPageSelected(this.mCurrentPosition);
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        if (this.mViewpager == null) {
            throw new NullPointerException("can not find Viewpager , setViewPager first");
        }
        this.mViewpager.removeOnPageChangeListener(onPageChangeListener);
        this.mViewpager.addOnPageChangeListener(onPageChangeListener);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (this.mViewpager.getAdapter() == null || this.mViewpager.getAdapter().getCount() <= 0) {
            return;
        }
        if (this.mAnimationIn.isRunning()) {
            this.mAnimationIn.end();
        }
        if (this.mAnimationOut.isRunning()) {
            this.mAnimationOut.end();
        }
        View currentIndicator = this.getChildAt(this.mCurrentPosition);
        currentIndicator.setBackgroundResource(this.mIndicatorUnselectedBackgroundResId);
        this.mAnimationIn.setTarget((Object)currentIndicator);
        this.mAnimationIn.start();
        View selectedIndicator = this.getChildAt(position);
        selectedIndicator.setBackgroundResource(this.mIndicatorBackgroundResId);
        this.mAnimationOut.setTarget((Object)selectedIndicator);
        this.mAnimationOut.start();
        this.mCurrentPosition = position;
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void createIndicators(ViewPager viewPager) {
        this.removeAllViews();
        if (viewPager.getAdapter() == null) {
            return;
        }
        int count = viewPager.getAdapter().getCount();
        if (count <= 0) {
            return;
        }
        this.addIndicator(this.mIndicatorBackgroundResId, this.mAnimationOut);
        for (int i = 1; i < count; ++i) {
            this.addIndicator(this.mIndicatorUnselectedBackgroundResId, this.mAnimationIn);
        }
    }

    private void addIndicator(@DrawableRes int backgroundDrawableId, Animator animator2) {
        if (animator2.isRunning()) {
            animator2.end();
        }
        View Indicator = new View(this.getContext());
        Indicator.setBackgroundResource(backgroundDrawableId);
        this.addView(Indicator, this.mIndicatorWidth, this.mIndicatorHeight);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)Indicator.getLayoutParams();
        lp.leftMargin = this.mIndicatorMargin;
        lp.rightMargin = this.mIndicatorMargin;
        Indicator.setLayoutParams((ViewGroup.LayoutParams)lp);
        animator2.setTarget((Object)Indicator);
        animator2.start();
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private class ReverseInterpolator
    implements Interpolator {
        private ReverseInterpolator() {
        }

        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }
}

