/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import me.relex.circleindicator.R;

public class CircleIndicator
extends LinearLayout
implements ViewPager.OnPageChangeListener {
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    private ViewPager mViewpager;
    private ViewPager.OnPageChangeListener mViewPagerOnPageChangeListener;
    private int mIndicatorMargin;
    private int mIndicatorWidth;
    private int mIndicatorHeight;
    private int mAnimatorResId = R.animator.scale_with_alpha;
    private int mIndicatorBackground = R.drawable.white_radius;
    private int mCurrentPosition = 0;
    private AnimatorSet mAnimationOut;
    private AnimatorSet mAnimationIn;

    public CircleIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setOrientation(0);
        this.setGravity(17);
        this.handleTypedArray(context, attrs);
        this.mAnimationOut = (AnimatorSet)AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorResId);
        this.mAnimationOut.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimationIn = (AnimatorSet)AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorResId);
        this.mAnimationIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleIndicator);
            this.mIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_width, -1);
            this.mIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_height, -1);
            this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_margin, -1);
            this.mAnimatorResId = typedArray.getResourceId(R.styleable.CircleIndicator_ci_animator, R.animator.scale_with_alpha);
            this.mIndicatorBackground = typedArray.getResourceId(R.styleable.CircleIndicator_ci_drawable, R.drawable.white_radius);
            typedArray.recycle();
        }
        this.mIndicatorWidth = this.mIndicatorWidth == -1 ? this.dip2px(5.0f) : this.mIndicatorWidth;
        this.mIndicatorHeight = this.mIndicatorHeight == -1 ? this.dip2px(5.0f) : this.mIndicatorHeight;
        this.mIndicatorMargin = this.mIndicatorMargin == -1 ? this.dip2px(5.0f) : this.mIndicatorMargin;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewpager = viewPager;
        this.createIndicators(viewPager);
        this.mViewpager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        if (this.mViewpager == null) {
            throw new NullPointerException("can not find Viewpager , setViewPager first");
        }
        this.mViewPagerOnPageChangeListener = onPageChangeListener;
        this.mViewpager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mViewPagerOnPageChangeListener != null) {
            this.mViewPagerOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mViewPagerOnPageChangeListener != null) {
            this.mViewPagerOnPageChangeListener.onPageSelected(position);
        }
        this.mAnimationIn.setTarget((Object)this.getChildAt(this.mCurrentPosition));
        this.mAnimationIn.start();
        this.mAnimationOut.setTarget((Object)this.getChildAt(position));
        this.mAnimationOut.start();
        this.mCurrentPosition = position;
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mViewPagerOnPageChangeListener != null) {
            this.mViewPagerOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    private void createIndicators(ViewPager viewPager) {
        this.removeAllViews();
        int count = viewPager.getAdapter().getCount();
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            View Indicator = new View(this.getContext());
            Indicator.setBackgroundResource(this.mIndicatorBackground);
            this.addView(Indicator, this.mIndicatorWidth, this.mIndicatorHeight);
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)Indicator.getLayoutParams();
            lp.leftMargin = this.mIndicatorMargin;
            lp.rightMargin = this.mIndicatorMargin;
            Indicator.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.mAnimationOut.setTarget((Object)Indicator);
            this.mAnimationOut.start();
        }
        this.mAnimationOut.setTarget((Object)this.getChildAt(this.mCurrentPosition));
        this.mAnimationOut.start();
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private class ReverseInterpolator
    implements Interpolator {
        private ReverseInterpolator() {
        }

        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }
}

