/*
 * Decompiled with CFR 0.152.
 */
package me.ramendev.expokert;

import java.util.EnumSet;
import me.ramendev.expokert.exception.IllegalCardException;

public enum Pip {
    TWO('2'),
    THREE('3'),
    FOUR('4'),
    FIVE('5'),
    SIX('6'),
    SEVEN('7'),
    EIGHT('8'),
    NINE('9'),
    TEN('T'),
    JACK('J'),
    QUEEN('Q'),
    KING('K'),
    ACE('A'),
    WILD('!');

    private final char character;

    private Pip(char character) {
        this.character = character;
    }

    public static Pip from(char character) {
        character = Character.toUpperCase(character);
        for (Pip pip : Pip.values()) {
            if (pip.getCharacter() != character) continue;
            return pip;
        }
        throw new IllegalCardException("Unexpected pip character: " + character);
    }

    public final char getCharacter() {
        return this.character;
    }

    public final int getValue() {
        return this.ordinal() + 2;
    }

    public final boolean isNextTo(Pip pip) {
        return !EnumSet.of(this, pip).contains((Object)WILD) && (Math.abs(this.ordinal() - pip.ordinal()) == 1 || EnumSet.of(this, pip).containsAll(EnumSet.of(TWO, ACE)));
    }
}

