/*
 * Decompiled with CFR 0.152.
 */
package me.ramendev.expokert;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.ramendev.expokert.Card;
import me.ramendev.expokert.Pip;
import me.ramendev.expokert.Suit;
import me.ramendev.expokert.Wildcard;
import me.ramendev.expokert.exception.DeckSizeException;
import me.ramendev.expokert.exception.DuplicateCardException;

public final class Deck {
    public static final int DEFAULT_DECK_SIZE = (Pip.values().length - 1) * (Suit.values().length - 1);
    private final LinkedHashSet<Card> cards;

    public Deck(List<Card> cards) {
        this.cards = new LinkedHashSet<Card>(cards);
    }

    public Deck() {
        this.cards = new LinkedHashSet(DEFAULT_DECK_SIZE);
    }

    public Deck(Optional<Wildcard> wildcard) {
        this(Card.getAllCards());
        wildcard.ifPresent(this::addCard);
    }

    public Deck(String cards) {
        this(Arrays.stream(cards.split("[ ,]+")).map(Card::new).toList());
    }

    public String toString() {
        return this.cards.stream().map(Card::toString).collect(Collectors.joining(" "));
    }

    public int getSize() {
        return this.getCards().size();
    }

    public void addCard(Card card) {
        if (this.getSize() >= DEFAULT_DECK_SIZE + 1) {
            throw new DeckSizeException("Deck size exceeded " + DEFAULT_DECK_SIZE);
        }
        if (!this.getCards().add(card)) {
            throw new DuplicateCardException("Card " + card + "already exists in the deck");
        }
    }

    public Card popCard() {
        if (this.getSize() == 0) {
            throw new DeckSizeException("Nothing to pop from deck with size 0");
        }
        Card card = ((Card[])this.getCards().toArray(Card[]::new))[this.getSize() - 1];
        this.getCards().remove(card);
        return card;
    }

    public LinkedHashSet<Card> getCards() {
        return this.cards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deck)) {
            return false;
        }
        Deck other = (Deck)o;
        LinkedHashSet<Card> this$cards = this.getCards();
        LinkedHashSet<Card> other$cards = other.getCards();
        return !(this$cards == null ? other$cards != null : !((Object)this$cards).equals(other$cards));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LinkedHashSet<Card> $cards = this.getCards();
        result = result * 59 + ($cards == null ? 43 : ((Object)$cards).hashCode());
        return result;
    }
}

