package me.ramendev.expokert;

import me.ramendev.expokert.exception.IllegalCardException;

/**
 * The suit of a {@link Card}. A notable difference from the {@link Pip} property is that
 * a majority of card games don't compare have a {@link Suit} order to compare.
 *
 * @see Pip
 * @see Card
 */
public enum Suit {
	/**
	 * The clubs suit.
	 */
	CLUBS,
	
	/**
	 * The spades suit.
	 */
	SPADES,
	
	/**
	 * The diamonds suit.
	 */
	DIAMONDS,
	
	/**
	 * The hearts suit.
	 */
	HEARTS,
	
	/**
	 * The wild suit, only unique to {@link Wildcard}s.
	 */
	WILD;
	
	/**
	 * Returns the suit that is notated with the provided character.
	 *
	 * @param  character The character of the pip to be returned.
	 * @return The suit with the provided character.
	 */
	public static Suit from(char character) {
		character = Character.toUpperCase(character);
		for (final Suit suit : values()) {
			if (suit.getCharacter() == character) {
				return suit;
			}
		}
		throw new IllegalCardException("Unexpected suit character: " + character);
	}
	
	/**
	 * Returns the character the represents this suit. This "character" in question
	 * is actually just <code>name().charAt(0)</code>.
	 *
	 * @return The character of the suit.
	 */
	public final char getCharacter() {
		return this == WILD ? '!' : name().charAt(0);
	}
}
