/*
 * Decompiled with CFR 0.152.
 */
package me.ramendev.expokert;

import java.util.ArrayList;
import java.util.List;
import me.ramendev.expokert.Deck;
import me.ramendev.expokert.Pip;
import me.ramendev.expokert.Suit;
import me.ramendev.expokert.Wildcard;
import me.ramendev.expokert.exception.IllegalCardException;

public class Card {
    private final Pip pip;
    private final Suit suit;

    public Card(Pip pip, Suit suit) {
        if (!(pip != Pip.WILD && suit != Suit.WILD || this instanceof Wildcard)) {
            throw new IllegalCardException("Card instance cannot have any properties as WILD, use Wildcard implementations instead");
        }
        this.pip = pip;
        this.suit = suit;
    }

    public Card(String string) {
        this(Pip.from(string.charAt(0)), Suit.from(Character.toLowerCase(string.charAt(1))));
        if (string.length() != 2) {
            throw new IllegalCardException("Invalid string for card: " + string);
        }
    }

    public static List<Card> getAllCards() {
        ArrayList<Card> cards = new ArrayList<Card>(Deck.DEFAULT_DECK_SIZE - 1);
        for (Pip pip : Pip.values()) {
            if (pip == Pip.WILD) continue;
            for (Suit suit : Suit.values()) {
                if (suit == Suit.WILD) continue;
                cards.add(new Card(pip, suit));
            }
        }
        return cards;
    }

    public String toString() {
        return "" + this.getPip().getCharacter() + this.getSuit().getCharacter();
    }

    public Pip getPip() {
        return this.pip;
    }

    public Suit getSuit() {
        return this.suit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Card)) {
            return false;
        }
        Card other = (Card)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pip this$pip = this.getPip();
        Pip other$pip = other.getPip();
        if (this$pip == null ? other$pip != null : !((Object)((Object)this$pip)).equals((Object)other$pip)) {
            return false;
        }
        Suit this$suit = this.getSuit();
        Suit other$suit = other.getSuit();
        return !(this$suit == null ? other$suit != null : !((Object)((Object)this$suit)).equals((Object)other$suit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Card;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pip $pip = this.getPip();
        result = result * 59 + ($pip == null ? 43 : ((Object)((Object)$pip)).hashCode());
        Suit $suit = this.getSuit();
        result = result * 59 + ($suit == null ? 43 : ((Object)((Object)$suit)).hashCode());
        return result;
    }
}

