package me.ramendev.expokert;

import java.util.Set;

import me.ramendev.expokert.exception.IllegalCardException;

/**
 * The "fixed" {@link Wildcard}, which has no dynamic behavior that depends on
 * additional game state, and has a constant set of {@link Card}s it can convert to.
 */
public class FixedWildcard extends Wildcard {
	/**
	 * The fixed set of conversions this card can convert to.
	 */
	private final Set<Card> conversions;
	
	/**
	 * Constructor for a fixed wildcard.
	 *
	 * @param  conversions The set of {@link Card}s that this wildcard can convert to.
	 * @throws IllegalCardException If the given set of conversions is empty. This
	 *                              entirely defeats the purpose of making a wildcard.
	 */
	public FixedWildcard(final Set<Card> conversions) {
		if (conversions.isEmpty()) {
			throw new IllegalCardException("Why are you making a wildcard that can't convert to anything!?");
		}
		this.conversions = conversions;
	}
	
	/**
	 * Gets all the {@link Card}s that this wildcard can convert to. In this case,
	 * it is a trivial getter of {@link #conversions}.
	 *
	 * @return The set of all cards that this wildcard can convert to.
	 */
	@Override
	public final Set<Card> getConversions() {
		return conversions;
	}
}
