/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;

public class GAV {
    private final String groupId;
    private final String artifactId;
    private final String version;

    GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProjectId() {
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GAV gav = (GAV)o;
        return Objects.equals(this.groupId, gav.groupId) && Objects.equals(this.artifactId, gav.artifactId) && Objects.equals(this.version, gav.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }

    public static GAV of(Model model) {
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        Parent parent = model.getParent();
        if (parent != null) {
            if (groupId == null) {
                groupId = parent.getGroupId();
            }
            if (version == null) {
                version = parent.getVersion();
            }
        }
        return new GAV(groupId, artifactId, version);
    }

    public static GAV of(Parent parent) {
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        return new GAV(groupId, artifactId, version);
    }

    public static GAV of(Dependency dependency) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String version = dependency.getVersion();
        return new GAV(groupId, artifactId, version);
    }

    public static GAV of(Plugin plugin) {
        String groupId = plugin.getGroupId();
        String artifactId = plugin.getArtifactId();
        String version = plugin.getVersion();
        return new GAV(groupId, artifactId, version);
    }

    public static GAV of(ReportPlugin plugin) {
        String groupId = plugin.getGroupId();
        String artifactId = plugin.getArtifactId();
        String version = plugin.getVersion();
        return new GAV(groupId, artifactId, version);
    }
}

