/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.TagComparator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public final class GitUtil {
    public static String NO_COMMIT = "0000000000000000000000000000000000000000";

    public static Status status(Repository repository) throws GitAPIException {
        return Git.wrap((Repository)repository).status().call();
    }

    public static String branch(Repository repository) throws IOException {
        String branch = repository.getBranch();
        if (ObjectId.isId((String)branch)) {
            return null;
        }
        return branch;
    }

    public static List<String> tagsPointAt(ObjectId revObjectId, Repository repository) throws IOException {
        return GitUtil.reverseTagRefMap(repository).getOrDefault(revObjectId, Collections.emptyList());
    }

    public static GitDescription describe(ObjectId revObjectId, Pattern tagPattern, Repository repository, boolean firstParent) throws IOException {
        Repository commonRepository = GitUtil.worktreesFix_getCommonRepository(repository);
        if (revObjectId == null) {
            return new GitDescription(NO_COMMIT, "root", 0);
        }
        Map<ObjectId, List<String>> objectIdListMap = GitUtil.reverseTagRefMap(repository);
        try (RevWalk walk = new RevWalk(commonRepository);){
            walk.setRetainBody(false);
            walk.setFirstParent(firstParent);
            walk.markStart(walk.parseCommit((AnyObjectId)revObjectId));
            Iterator walkIterator = walk.iterator();
            int depth = 0;
            while (walkIterator.hasNext()) {
                RevCommit rev = (RevCommit)walkIterator.next();
                Optional<String> matchingTag = objectIdListMap.getOrDefault(rev, Collections.emptyList()).stream().filter(tag -> tagPattern.matcher((CharSequence)tag).matches()).findFirst();
                if (matchingTag.isPresent()) {
                    GitDescription gitDescription = new GitDescription(revObjectId.getName(), matchingTag.get(), depth);
                    return gitDescription;
                }
                ++depth;
            }
            if (GitUtil.isShallowRepository(repository)) {
                throw new IllegalStateException("couldn't find matching tag in shallow git repository");
            }
            GitDescription gitDescription = new GitDescription(revObjectId.getName(), "root", depth);
            return gitDescription;
        }
    }

    public static boolean isShallowRepository(Repository repository) {
        return new File(repository.getDirectory(), "shallow").isFile();
    }

    public static List<Ref> tags(Repository repository) throws IOException {
        Repository commonRepository = GitUtil.worktreesFix_getCommonRepository(repository);
        return commonRepository.getRefDatabase().getRefsByPrefix("refs/tags/");
    }

    public static Map<ObjectId, List<String>> reverseTagRefMap(Repository repository) throws IOException {
        Repository commonRepository = GitUtil.worktreesFix_getCommonRepository(repository);
        TagComparator tagComparator = new TagComparator(commonRepository);
        return GitUtil.tags(commonRepository).stream().collect(Collectors.groupingBy(r -> {
            try {
                Ref peel = commonRepository.getRefDatabase().peel(r);
                return peel.getPeeledObjectId() != null ? peel.getPeeledObjectId() : peel.getObjectId();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().sorted(tagComparator).map(v -> Repository.shortenRefName((String)v.getName())).collect(Collectors.toList())));
    }

    public static ZonedDateTime revTimestamp(Repository repository, ObjectId rev) throws IOException {
        Repository commonRepository = GitUtil.worktreesFix_getCommonRepository(repository);
        Instant commitTime = Instant.ofEpochSecond(commonRepository.parseCommit((AnyObjectId)rev).getCommitTime());
        return ZonedDateTime.ofInstant(commitTime, ZoneOffset.UTC);
    }

    public static File worktreesFix_getWorkTree(Repository repository) throws IOException {
        try {
            return repository.getWorkTree();
        }
        catch (NoWorkTreeException e) {
            File gitDirFile = new File(repository.getDirectory(), "gitdir");
            if (gitDirFile.exists()) {
                String gitDirPath = Files.readAllLines(gitDirFile.toPath()).get(0);
                return new File(gitDirPath).getParentFile();
            }
            throw e;
        }
    }

    public static Repository worktreesFix_getCommonRepository(Repository repository) throws IOException {
        try {
            repository.getWorkTree();
            return repository;
        }
        catch (NoWorkTreeException e) {
            File commonDirFile = new File(repository.getDirectory(), "commondir");
            if (!commonDirFile.exists()) {
                throw e;
            }
            String commonDirPath = Files.readAllLines(commonDirFile.toPath()).get(0);
            File commonGitDir = new File(repository.getDirectory(), commonDirPath);
            return ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(commonGitDir)).build();
        }
    }

    public static ObjectId worktreesFix_resolveHead(Repository repository) throws IOException {
        try {
            repository.getWorkTree();
            return repository.resolve("HEAD");
        }
        catch (NoWorkTreeException e) {
            File headFile = new File(repository.getDirectory(), "HEAD");
            if (!headFile.exists()) {
                throw e;
            }
            String head = Files.readAllLines(headFile.toPath()).get(0);
            if (head.startsWith("ref:")) {
                String refPath = head.replaceFirst("^ref: *", "");
                File commonDirFile = new File(repository.getDirectory(), "commondir");
                String commonDirPath = Files.readAllLines(commonDirFile.toPath()).get(0);
                File commonGitDir = new File(repository.getDirectory(), commonDirPath);
                File refFile = new File(commonGitDir, refPath);
                head = Files.readAllLines(refFile.toPath()).get(0);
            }
            return repository.resolve(head);
        }
    }
}

