/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gradle.gitversioning;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.GitRefType;
import me.qoomon.gitversioning.commons.GitSituation;
import me.qoomon.gitversioning.commons.Lazy;
import me.qoomon.gitversioning.commons.StringUtil;
import me.qoomon.gradle.gitversioning.GitVersionDetails;
import me.qoomon.gradle.gitversioning.GitVersioningPluginConfig;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public abstract class GitVersioningPluginExtension {
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*?(?<version>(?<core>(?<major>\\d+)(?:\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?)?)(?:-(?<label>.*))?)|");
    private static final String OPTION_NAME_GIT_REF = "git.ref";
    private static final String OPTION_NAME_GIT_TAG = "git.tag";
    private static final String OPTION_NAME_GIT_BRANCH = "git.branch";
    private static final String OPTION_NAME_DISABLE = "versioning.disable";
    private static final String OPTION_UPDATE_GRADLE_PROPERTIES = "versioning.updateGradleProperties";
    private final Project project;
    private GitVersioningPluginConfig config;
    public GitVersionDetails gitVersionDetails;
    public Map<String, Supplier<String>> globalFormatPlaceholderMap;

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    public GitVersioningPluginExtension(Project project) {
        this.project = project;
    }

    public void apply(Action<GitVersioningPluginConfig> action) throws IOException {
        GitVersioningPluginConfig config = (GitVersioningPluginConfig)this.getObjectFactory().newInstance(GitVersioningPluginConfig.class, new Object[0]);
        action.execute((Object)config);
        this.apply(config);
    }

    public void apply(GitVersioningPluginConfig config) throws IOException {
        this.config = config;
        this.normalizeConfig(config);
        this.apply();
    }

    private void apply() throws IOException {
        boolean updateGradleProperties;
        GitSituation gitSituation;
        String commandOptionDisable = this.getCommandOption(OPTION_NAME_DISABLE);
        if (commandOptionDisable != null) {
            boolean disabled = Boolean.parseBoolean(commandOptionDisable);
            if (disabled) {
                this.project.getLogger().warn("skip - versioning is disabled by command option");
                return;
            }
        } else if (this.config.disable.booleanValue()) {
            this.project.getLogger().warn("skip - versioning is disabled by config option");
            return;
        }
        if ((gitSituation = this.getGitSituation(this.project.getProjectDir())) == null) {
            this.project.getLogger().warn("skip - project is not part of a git repository");
            return;
        }
        if (this.project.getLogger().isDebugEnabled()) {
            this.project.getLogger().debug("git situation:");
            this.project.getLogger().debug("  root directory: " + gitSituation.getRootDirectory());
            this.project.getLogger().debug("  head commit: " + gitSituation.getRev());
            this.project.getLogger().debug("  head commit timestamp: " + gitSituation.getTimestamp());
            this.project.getLogger().debug("  head branch: " + gitSituation.getBranch());
            this.project.getLogger().debug("  head tags: " + gitSituation.getTags());
            this.project.getLogger().debug("  head description: " + gitSituation.getDescription());
        }
        this.gitVersionDetails = GitVersioningPluginExtension.getGitVersionDetails(gitSituation, this.config);
        if (this.gitVersionDetails == null) {
            this.project.getLogger().warn("skip - no matching ref configuration and no rev configuration defined");
            this.project.getLogger().warn("git refs:");
            this.project.getLogger().warn("  branch: " + gitSituation.getBranch());
            this.project.getLogger().warn("  tags: " + gitSituation.getTags());
            this.project.getLogger().warn("defined ref configurations:");
            this.config.refs.list.forEach(ref -> this.project.getLogger().warn("  " + StringUtils.rightPad((String)ref.type.name(), (int)6) + " - pattern: " + ref.pattern));
            return;
        }
        this.project.getLogger().lifecycle("matching ref: " + this.gitVersionDetails.getRefType().name() + " - " + this.gitVersionDetails.getRefName());
        GitVersioningPluginConfig.RefPatchDescription patchDescription = this.gitVersionDetails.getPatchDescription();
        this.project.getLogger().lifecycle("ref configuration: " + this.gitVersionDetails.getRefType().name() + " - pattern: " + patchDescription.pattern);
        if (patchDescription.describeTagPattern != null) {
            this.project.getLogger().lifecycle("  describeTagPattern: " + patchDescription.describeTagPattern);
            gitSituation.setDescribeTagPattern(patchDescription.getDescribeTagPattern());
        }
        if (patchDescription.describeTagFirstParent != null) {
            this.project.getLogger().info("  describeTagFirstParent: " + patchDescription.describeTagFirstParent);
            gitSituation.setFirstParent(patchDescription.describeTagFirstParent);
        }
        if (patchDescription.version != null) {
            this.project.getLogger().lifecycle("  version: " + patchDescription.version);
        }
        if (!patchDescription.properties.isEmpty()) {
            this.project.getLogger().lifecycle("  properties:");
            patchDescription.properties.forEach((key, value) -> this.project.getLogger().lifecycle("    " + key + ": " + value));
        }
        if (updateGradleProperties = this.getUpdateGradlePropertiesOption(patchDescription)) {
            this.project.getLogger().lifecycle("  updateGradleProperties: " + updateGradleProperties);
        }
        this.globalFormatPlaceholderMap = this.generateGlobalFormatPlaceholderMap(gitSituation, this.gitVersionDetails, this.project);
        Map<String, String> gitProjectProperties = GitVersioningPluginExtension.generateGitProjectProperties(gitSituation, this.gitVersionDetails);
        this.project.getLogger().lifecycle("");
        this.project.getAllprojects().forEach(project -> {
            File gradleProperties;
            Map propertyFormats;
            String originalProjectVersion = project.getVersion().toString();
            String versionFormat = patchDescription.version;
            if (versionFormat != null) {
                this.updateVersion((Project)project, versionFormat);
                project.getLogger().lifecycle("project version: " + project.getVersion());
            }
            if ((propertyFormats = patchDescription.properties) != null && !propertyFormats.isEmpty()) {
                this.updatePropertyValues((Project)project, propertyFormats, originalProjectVersion);
            }
            this.addGitProjectProperties((Project)project, gitProjectProperties);
            if (updateGradleProperties && (gradleProperties = project.file((Object)"gradle.properties")).exists()) {
                this.updateGradlePropertiesFile(gradleProperties, (Project)project);
            }
        });
    }

    private void updateVersion(Project project, String versionFormat) {
        String gitProjectVersion = this.getGitVersion(versionFormat, project.getVersion().toString());
        project.getLogger().info("set version to  " + gitProjectVersion);
        project.setVersion((Object)gitProjectVersion);
    }

    private void updatePropertyValues(Project project, Map<String, String> propertyFormats, String originalProjectVersion) {
        boolean logHeader = true;
        for (Map.Entry projectProperty : project.getProperties().entrySet()) {
            String projectPropertyName = (String)projectProperty.getKey();
            Object projectPropertyValue = projectProperty.getValue();
            String propertyFormat = propertyFormats.get(projectPropertyName);
            if (propertyFormat == null) continue;
            if (projectPropertyValue == null || projectPropertyValue instanceof String) {
                String gitPropertyValue = this.getGitPropertyValue(propertyFormat, projectPropertyValue != null ? projectPropertyValue.toString() : null, originalProjectVersion);
                if (gitPropertyValue.equals(projectPropertyValue)) continue;
                if (logHeader) {
                    project.getLogger().lifecycle("properties:");
                    logHeader = false;
                }
                project.getLogger().lifecycle("  " + projectPropertyName + ": " + gitPropertyValue);
                project.setProperty(projectPropertyName, (Object)gitPropertyValue);
                continue;
            }
            project.getLogger().warn("Can not update property " + projectPropertyName + ". Expected value type is String, but was " + projectPropertyValue.getClass().getName());
        }
    }

    private void addGitProjectProperties(Project project, Map<String, String> gitProjectProperties) {
        ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
        gitProjectProperties.forEach((arg_0, arg_1) -> ((ExtraPropertiesExtension)extraProperties).set(arg_0, arg_1));
    }

    private void updateGradlePropertiesFile(File gradleProperties, Project project) {
        PropertiesConfiguration gradlePropertiesConfig = new PropertiesConfiguration();
        try (FileReader reader = new FileReader(gradleProperties);){
            gradlePropertiesConfig.read((Reader)reader);
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
        if (gradlePropertiesConfig.containsKey("version")) {
            Object gradlePropertyVersion = gradlePropertiesConfig.getProperty("version");
            Object projectVersion = project.getVersion();
            if (!Objects.equals(projectVersion, gradlePropertyVersion)) {
                gradlePropertiesConfig.setProperty("version", projectVersion);
            }
        }
        Map projectProperties = project.getProperties();
        this.gitVersionDetails.getPatchDescription().properties.forEach((key, value) -> {
            if (gradlePropertiesConfig.containsKey(key)) {
                Object gradlePropertyValue = gradlePropertiesConfig.getProperty(key);
                Object projectPropertyValue = projectProperties.get(key);
                if (!Objects.equals(projectPropertyValue, gradlePropertyValue)) {
                    gradlePropertiesConfig.setProperty(key, projectPropertyValue);
                }
            }
        });
        try (StringWriter writer = new StringWriter(512);){
            gradlePropertiesConfig.write((Writer)writer);
            byte[] gitVersionedGradlePropertiesBytes = writer.toString().getBytes();
            byte[] existingGradlePropertiesBytes = Files.readAllBytes(gradleProperties.toPath());
            if (!Arrays.equals(gitVersionedGradlePropertiesBytes, existingGradlePropertiesBytes)) {
                Files.write(gradleProperties.toPath(), gitVersionedGradlePropertiesBytes, new OpenOption[0]);
            }
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private GitSituation getGitSituation(File executionRootDirectory) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(executionRootDirectory);
        if (repositoryBuilder.getGitDir() == null) {
            return null;
        }
        final Repository repository = repositoryBuilder.build();
        return new GitSituation(repository){
            {
                super(arg0);
                this.handleEnvironment(repository);
            }

            private void handleEnvironment(Repository repository2) throws IOException {
                String commitTag;
                String commitBranch;
                String overrideBranch = GitVersioningPluginExtension.this.getCommandOption(GitVersioningPluginExtension.OPTION_NAME_GIT_BRANCH);
                String overrideTag = GitVersioningPluginExtension.this.getCommandOption(GitVersioningPluginExtension.OPTION_NAME_GIT_TAG);
                if (overrideBranch != null || overrideTag != null) {
                    overrideBranch = overrideBranch == null || overrideBranch.trim().isEmpty() ? null : overrideBranch.trim();
                    this.setBranch(overrideBranch);
                    overrideTag = overrideTag == null || overrideTag.trim().isEmpty() ? null : overrideTag.trim();
                    this.setTags(overrideTag == null ? Collections.emptyList() : Collections.singletonList(overrideTag));
                    return;
                }
                String providedRef = GitVersioningPluginExtension.this.getCommandOption(GitVersioningPluginExtension.OPTION_NAME_GIT_REF);
                if (providedRef != null) {
                    if (!providedRef.startsWith("refs/")) {
                        throw new IllegalArgumentException("invalid provided ref " + providedRef + " -  needs to start with refs/");
                    }
                    if (providedRef.startsWith("refs/tags/")) {
                        this.setBranch(null);
                        this.setTags(Collections.singletonList(providedRef));
                    } else {
                        this.setBranch(providedRef);
                        this.setTags(Collections.emptyList());
                    }
                    return;
                }
                if (repository2.getBranch() == null) {
                    return;
                }
                if ("true".equalsIgnoreCase(System.getenv("GITHUB_ACTIONS"))) {
                    if (!this.getRev().equals(System.getenv("GITHUB_SHA"))) {
                        return;
                    }
                    GitVersioningPluginExtension.this.project.getLogger().lifecycle("gather git situation from GitHub Actions environment variable: GITHUB_REF");
                    String githubRef = System.getenv("GITHUB_REF");
                    GitVersioningPluginExtension.this.project.getLogger().debug("  GITHUB_REF: " + githubRef);
                    if (githubRef.startsWith("refs/tags/")) {
                        this.addTag(githubRef);
                    } else {
                        this.setBranch(githubRef);
                    }
                    return;
                }
                if ("true".equalsIgnoreCase(System.getenv("GITLAB_CI"))) {
                    if (!this.getRev().equals(System.getenv("CI_COMMIT_SHA"))) {
                        return;
                    }
                    GitVersioningPluginExtension.this.project.getLogger().lifecycle("gather git situation from GitLab CI environment variables: CI_COMMIT_BRANCH, CI_MERGE_REQUEST_SOURCE_BRANCH_NAME and CI_COMMIT_TAG");
                    commitBranch = System.getenv("CI_COMMIT_BRANCH");
                    commitTag = System.getenv("CI_COMMIT_TAG");
                    String mrSourceBranch = System.getenv("CI_MERGE_REQUEST_SOURCE_BRANCH_NAME");
                    GitVersioningPluginExtension.this.project.getLogger().debug("  CI_COMMIT_BRANCH: " + commitBranch);
                    GitVersioningPluginExtension.this.project.getLogger().debug("  CI_COMMIT_TAG: " + commitTag);
                    GitVersioningPluginExtension.this.project.getLogger().debug("  CI_MERGE_REQUEST_SOURCE_BRANCH_NAME: " + mrSourceBranch);
                    if (!StringUtils.isBlank((CharSequence)commitBranch)) {
                        this.setBranch(commitBranch);
                    } else if (!StringUtils.isBlank((CharSequence)mrSourceBranch)) {
                        this.setBranch(mrSourceBranch);
                    } else if (!StringUtils.isBlank((CharSequence)commitTag)) {
                        this.addTag(commitTag);
                    }
                    return;
                }
                if ("true".equalsIgnoreCase(System.getenv("CIRCLECI"))) {
                    if (!this.getRev().equals(System.getenv("CIRCLE_SHA1"))) {
                        return;
                    }
                    GitVersioningPluginExtension.this.project.getLogger().lifecycle("gather git situation from Circle CI environment variables: CIRCLE_BRANCH and CIRCLE_TAG");
                    commitBranch = System.getenv("CIRCLE_BRANCH");
                    commitTag = System.getenv("CIRCLE_TAG");
                    GitVersioningPluginExtension.this.project.getLogger().debug("  CIRCLE_BRANCH: " + commitBranch);
                    GitVersioningPluginExtension.this.project.getLogger().debug("  CIRCLE_TAG: " + commitTag);
                    if (!StringUtils.isBlank((CharSequence)commitBranch)) {
                        this.setBranch(commitBranch.trim());
                    } else if (!StringUtils.isBlank((CharSequence)commitTag)) {
                        this.addTag(commitTag.trim());
                    }
                    return;
                }
                if (System.getenv("JENKINS_HOME") != null && !System.getenv("JENKINS_HOME").trim().isEmpty()) {
                    if (!this.getRev().equals(System.getenv("GIT_COMMIT"))) {
                        return;
                    }
                    GitVersioningPluginExtension.this.project.getLogger().lifecycle("gather git situation from jenkins environment variables: BRANCH_NAME and TAG_NAME");
                    commitBranch = System.getenv("BRANCH_NAME");
                    commitTag = System.getenv("TAG_NAME");
                    GitVersioningPluginExtension.this.project.getLogger().debug("  BRANCH_NAME: " + commitBranch);
                    GitVersioningPluginExtension.this.project.getLogger().debug("  TAG_NAME: " + commitTag);
                    if (!StringUtils.isBlank((CharSequence)commitBranch)) {
                        if (commitBranch.equals(commitTag)) {
                            this.addTag(commitBranch);
                        } else {
                            this.setBranch(commitBranch);
                        }
                    } else if (!StringUtils.isBlank((CharSequence)commitTag)) {
                        this.addTag(commitTag);
                    }
                    return;
                }
            }

            @Override
            protected void setBranch(String branch) {
                GitVersioningPluginExtension.this.project.getLogger().debug("override git branch with " + branch);
                super.setBranch(branch);
            }

            @Override
            protected void setTags(List<String> tags) {
                GitVersioningPluginExtension.this.project.getLogger().debug("override git tags with single tag " + tags);
                super.setTags(tags);
            }

            @Override
            protected void addTag(String tag) {
                GitVersioningPluginExtension.this.project.getLogger().debug("add git tag " + tag);
                super.addTag(tag);
            }
        };
    }

    private static GitVersionDetails getGitVersionDetails(GitSituation gitSituation, GitVersioningPluginConfig config) {
        Lazy<List> sortedTags = Lazy.by(() -> gitSituation.getTags().stream().sorted(Comparator.comparing(DefaultArtifactVersion::new)).collect(Collectors.toList()));
        block4: for (GitVersioningPluginConfig.RefPatchDescription refConfig : config.refs.list) {
            switch (refConfig.type) {
                case TAG: {
                    if (!gitSituation.isDetached() && !config.refs.considerTagsOnBranches) continue block4;
                    for (String tag : sortedTags.get()) {
                        if (refConfig.pattern != null && !refConfig.pattern.matcher(tag).matches()) continue;
                        return new GitVersionDetails(gitSituation.getRev(), GitRefType.TAG, tag, refConfig);
                    }
                    continue block4;
                }
                case BRANCH: {
                    if (gitSituation.isDetached()) continue block4;
                    String branch = gitSituation.getBranch();
                    if (refConfig.pattern != null && !refConfig.pattern.matcher(branch).matches()) continue block4;
                    return new GitVersionDetails(gitSituation.getRev(), GitRefType.BRANCH, branch, refConfig);
                }
                default: {
                    throw new IllegalArgumentException("Unexpected ref type: " + refConfig.type);
                }
            }
        }
        if (config.rev != null) {
            return new GitVersionDetails(gitSituation.getRev(), GitRefType.COMMIT, gitSituation.getRev(), new GitVersioningPluginConfig.RefPatchDescription(GitRefType.COMMIT, null, config.rev));
        }
        return null;
    }

    private String getGitVersion(String versionFormat, String projectVersion) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(projectVersion);
        return GitVersioningPluginExtension.slugify(StringUtil.substituteText(versionFormat, placeholderMap));
    }

    private String getGitPropertyValue(String propertyFormat, String originalValue, String projectVersion) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(projectVersion);
        placeholderMap.put("value", () -> originalValue);
        return StringUtil.substituteText(propertyFormat, placeholderMap);
    }

    private Map<String, Supplier<String>> generateFormatPlaceholderMap(String projectVersion) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>(this.globalFormatPlaceholderMap);
        placeholderMap.put("version", Lazy.of(projectVersion));
        Lazy<Matcher> projectVersionMatcher = Lazy.by(() -> this.matchVersion(projectVersion));
        placeholderMap.put("version.core", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)projectVersionMatcher.get()).group("core"), "0.0.0")));
        placeholderMap.put("version.major", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)projectVersionMatcher.get()).group("major"), "0")));
        placeholderMap.put("version.major.next", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("version.major")).get(), 1L)));
        placeholderMap.put("version.minor", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)projectVersionMatcher.get()).group("minor"), "0")));
        placeholderMap.put("version.minor.next", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("version.minor")).get(), 1L)));
        placeholderMap.put("version.patch", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)projectVersionMatcher.get()).group("patch"), "0")));
        placeholderMap.put("version.patch.next", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("version.patch")).get(), 1L)));
        placeholderMap.put("version.label", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)projectVersionMatcher.get()).group("label"), "")));
        placeholderMap.put("version.label.prefixed", Lazy.by(() -> {
            String label = (String)((Supplier)placeholderMap.get("version.label")).get();
            return !label.isEmpty() ? "-" + label : "";
        }));
        placeholderMap.put("version.release", Lazy.by(() -> projectVersion.replaceFirst("-.*$", "")));
        Pattern projectVersionPattern = this.config.projectVersionPattern();
        if (projectVersionPattern != null) {
            for (Map.Entry<String, String> patternGroup : StringUtil.patternGroupValues(projectVersionPattern, projectVersion).entrySet()) {
                String groupName = patternGroup.getKey();
                String value = patternGroup.getValue() != null ? patternGroup.getValue() : "";
                placeholderMap.put("version." + groupName, () -> value);
            }
        }
        return placeholderMap;
    }

    private Map<String, Supplier<String>> generateGlobalFormatPlaceholderMap(GitSituation gitSituation, GitVersionDetails gitVersionDetails, Project rootProject) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>();
        Lazy<String> hash = Lazy.by(gitSituation::getRev);
        placeholderMap.put("commit", hash);
        placeholderMap.put("commit.short", Lazy.by(() -> ((String)hash.get()).substring(0, 7)));
        Lazy<ZonedDateTime> headCommitDateTime = Lazy.by(gitSituation::getTimestamp);
        placeholderMap.put("commit.timestamp", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).toEpochSecond())));
        placeholderMap.put("commit.timestamp.year", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear())));
        placeholderMap.put("commit.timestamp.year.2digit", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear() % 100)));
        placeholderMap.put("commit.timestamp.month", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMonthValue()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.day", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getDayOfMonth()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.hour", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getHour()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.minute", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMinute()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.second", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getSecond()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.datetime", Lazy.by(() -> ((ZonedDateTime)headCommitDateTime.get()).toEpochSecond() > 0L ? ((ZonedDateTime)headCommitDateTime.get()).format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss")) : "00000000.000000"));
        String refName = gitVersionDetails.getRefName();
        Lazy<String> refNameSlug = Lazy.by(() -> GitVersioningPluginExtension.slugify(refName));
        placeholderMap.put("ref", () -> refName);
        placeholderMap.put("ref.slug", refNameSlug);
        Pattern refPattern = gitVersionDetails.getPatchDescription().pattern;
        if (refPattern != null) {
            for (Map.Entry<String, String> patternGroup : StringUtil.patternGroupValues(refPattern, refName).entrySet()) {
                String groupName = patternGroup.getKey();
                String value2 = patternGroup.getValue() != null ? patternGroup.getValue() : "";
                placeholderMap.put("ref." + groupName, () -> value2);
                placeholderMap.put("ref." + groupName + ".slug", Lazy.by(() -> GitVersioningPluginExtension.slugify(value2)));
            }
        }
        Lazy<Boolean> dirty = Lazy.by(() -> !gitSituation.isClean());
        placeholderMap.put("dirty", Lazy.by(() -> (Boolean)dirty.get() != false ? "-DIRTY" : ""));
        placeholderMap.put("dirty.snapshot", Lazy.by(() -> (Boolean)dirty.get() != false ? "-SNAPSHOT" : ""));
        Lazy<GitDescription> description = Lazy.by(gitSituation::getDescription);
        placeholderMap.put("describe", Lazy.by(() -> ((GitDescription)description.get()).toString()));
        Lazy<String> descriptionTag = Lazy.by(() -> ((GitDescription)description.get()).getTag());
        placeholderMap.put("describe.tag", descriptionTag);
        Lazy<Map> describeTagPatternValues = Lazy.by(() -> StringUtil.patternGroupValues(gitSituation.getDescribeTagPattern(), (String)descriptionTag.get()));
        for (String groupName : StringUtil.patternGroups(gitSituation.getDescribeTagPattern())) {
            Lazy<String> groupValue = Lazy.by(() -> (String)((Map)describeTagPatternValues.get()).get(groupName));
            placeholderMap.put("describe.tag." + groupName, groupValue);
            placeholderMap.put("describe.tag." + groupName + ".slug", Lazy.by(() -> GitVersioningPluginExtension.slugify((String)groupValue.get())));
        }
        Lazy<Matcher> descriptionTagVersionMatcher = Lazy.by(() -> this.matchVersion((String)descriptionTag.get()));
        placeholderMap.put("describe.tag.version", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)descriptionTagVersionMatcher.get()).group("version"), "0.0.0")));
        placeholderMap.put("describe.tag.version.core", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)descriptionTagVersionMatcher.get()).group("core"), "0")));
        placeholderMap.put("describe.tag.version.major", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)descriptionTagVersionMatcher.get()).group("major"), "0")));
        placeholderMap.put("describe.tag.version.major.next", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.major")).get(), 1L)));
        placeholderMap.put("describe.tag.version.minor", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)descriptionTagVersionMatcher.get()).group("minor"), "0")));
        placeholderMap.put("describe.tag.version.minor.next", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.minor")).get(), 1L)));
        placeholderMap.put("describe.tag.version.patch", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)descriptionTagVersionMatcher.get()).group("patch"), "0")));
        placeholderMap.put("describe.tag.version.patch.next", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.patch")).get(), 1L)));
        placeholderMap.put("describe.tag.version.label", Lazy.by(() -> GitVersioningPluginExtension.notNullOrDefault(((Matcher)descriptionTagVersionMatcher.get()).group("label"), "")));
        placeholderMap.put("describe.tag.version.label.next", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.label")).get(), 1L)));
        Lazy<Integer> descriptionDistance = Lazy.by(() -> ((GitDescription)description.get()).getDistance());
        placeholderMap.put("describe.distance", Lazy.by(() -> String.valueOf(descriptionDistance.get())));
        placeholderMap.put("describe.tag.version.patch.plus.describe.distance", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.patch")).get(), ((Integer)descriptionDistance.get()).intValue())));
        placeholderMap.put("describe.tag.version.patch.next.plus.describe.distance", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.patch.next")).get(), ((Integer)descriptionDistance.get()).intValue())));
        placeholderMap.put("describe.tag.version.label.plus.describe.distance", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.label")).get(), ((Integer)descriptionDistance.get()).intValue())));
        placeholderMap.put("describe.tag.version.label.next.plus.describe.distance", Lazy.by(() -> GitVersioningPluginExtension.increase((String)((Supplier)placeholderMap.get("describe.tag.version.label.next")).get(), ((Integer)descriptionDistance.get()).intValue())));
        for (Map.Entry property : rootProject.getProperties().entrySet()) {
            if (property.getValue() == null || !(property.getValue() instanceof String) && !(property.getValue() instanceof Number)) continue;
            placeholderMap.put("property." + (String)property.getKey(), () -> property.getValue().toString());
        }
        System.getenv().forEach((key, value) -> placeholderMap.put("env." + key, () -> value));
        return placeholderMap;
    }

    private Matcher matchVersion(String input) {
        Matcher matcher = VERSION_PATTERN.matcher(input);
        matcher.find();
        return matcher;
    }

    private static Map<String, String> generateGitProjectProperties(GitSituation gitSituation, GitVersionDetails gitVersionDetails) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("git.commit", gitVersionDetails.getCommit());
        properties.put("git.commit.short", gitVersionDetails.getCommit().substring(0, 7));
        ZonedDateTime headCommitDateTime = gitSituation.getTimestamp();
        properties.put("git.commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        properties.put("git.commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ISO_INSTANT) : "0000-00-00T00:00:00Z");
        String refName = gitVersionDetails.getRefName();
        String refNameSlug = GitVersioningPluginExtension.slugify(refName);
        properties.put(OPTION_NAME_GIT_REF, refName);
        properties.put("git.ref.slug", refNameSlug);
        return properties;
    }

    private void normalizeConfig(GitVersioningPluginConfig config) {
        ArrayList<GitVersioningPluginConfig.RefPatchDescription> patchDescriptions = new ArrayList<GitVersioningPluginConfig.RefPatchDescription>(config.refs.list);
        if (config.rev != null) {
            patchDescriptions.add((GitVersioningPluginConfig.RefPatchDescription)config.rev);
        }
        for (GitVersioningPluginConfig.PatchDescription patchDescription : patchDescriptions) {
            if (patchDescription.describeTagPattern == null) {
                patchDescription.describeTagPattern = config.describeTagPattern;
            }
            if (patchDescription.describeTagFirstParent == null) {
                patchDescription.describeTagFirstParent = config.describeTagFirstParent;
            }
            if (patchDescription.updateGradleProperties != null) continue;
            patchDescription.updateGradleProperties = config.updateGradleProperties;
        }
    }

    private String getCommandOption(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            String plainName = name.replaceFirst("^versioning\\.", "");
            String environmentVariableName = "VERSIONING_" + String.join((CharSequence)"_", plainName.split("(?=\\p{Lu})")).replaceAll("\\.", "_").toUpperCase();
            value = System.getenv(environmentVariableName);
        }
        return value;
    }

    private boolean getUpdateGradlePropertiesOption(GitVersioningPluginConfig.RefPatchDescription gitRefConfig) {
        String updateGradlePropertiesOption = this.getCommandOption(OPTION_UPDATE_GRADLE_PROPERTIES);
        if (updateGradlePropertiesOption != null) {
            return Boolean.parseBoolean(updateGradlePropertiesOption);
        }
        if (gitRefConfig.updateGradleProperties != null) {
            return gitRefConfig.updateGradleProperties;
        }
        return false;
    }

    private static String slugify(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("/", "-");
    }

    private static String increase(String number, long increment) {
        String sanitized = number.isEmpty() ? "0" : number;
        return String.format("%0" + sanitized.length() + "d", Long.parseLong(number.isEmpty() ? "0" : number) + increment);
    }

    public static <T> T notNullOrDefault(T obj, T defaultObj) {
        return obj != null ? obj : defaultObj;
    }
}

