/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.qoomon.gitversioning.commons.GitSituation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public final class GitUtil {
    public static String NO_COMMIT = "0000000000000000000000000000000000000000";

    public static Status status(Repository repository) {
        try {
            return Git.wrap((Repository)repository).status().call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public static String branch(Repository repository) throws IOException {
        String branch = repository.getBranch();
        if (ObjectId.isId((String)branch)) {
            return null;
        }
        return branch;
    }

    public static List<String> tag_pointsAt(Repository repository, String revstr) throws IOException {
        ObjectId revObjectId = repository.resolve(revstr);
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Ref ref : repository.getRefDatabase().getRefsByPrefix("refs/tags/")) {
            Ref peeledRef = repository.getRefDatabase().peel(ref);
            ObjectId targetObjectId = peeledRef.getPeeledObjectId() != null ? peeledRef.getPeeledObjectId() : peeledRef.getObjectId();
            if (!targetObjectId.equals((AnyObjectId)revObjectId)) continue;
            String tagName = ref.getName().replaceFirst("^refs/tags/", "");
            tagNames.add(tagName);
        }
        return tagNames;
    }

    public static String revParse(Repository repository, String revstr) throws IOException {
        ObjectId rev = repository.resolve(revstr);
        if (rev == null) {
            return NO_COMMIT;
        }
        return rev.getName();
    }

    public static long revTimestamp(Repository repository, String revstr) throws IOException {
        ObjectId rev = repository.resolve(revstr);
        if (rev == null) {
            return 0L;
        }
        return repository.parseCommit((AnyObjectId)rev).getCommitTime();
    }

    public static GitSituation situation(File directory) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(directory);
        if (repositoryBuilder.getGitDir() == null) {
            return null;
        }
        try (Repository repository = repositoryBuilder.build();){
            String headCommit = GitUtil.revParse(repository, "HEAD");
            long headCommitTimestamp = GitUtil.revTimestamp(repository, "HEAD");
            String headBranch = GitUtil.branch(repository);
            List<String> headTags = GitUtil.tag_pointsAt(repository, "HEAD");
            boolean isClean = GitUtil.status(repository).isClean();
            GitSituation gitSituation = new GitSituation(repositoryBuilder.getGitDir(), headCommit, headCommitTimestamp, headBranch, headTags, isClean);
            return gitSituation;
        }
    }
}

