/*
 * Decompiled with CFR 0.152.
 */
package me.piruin.quickaction;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import java.util.List;
import me.piruin.quickaction.ActionItem;
import me.piruin.quickaction.QuickAction;

public class QuickIntentAction {
    private static final int SERVICE = 1;
    private static final int ACTIVITY = 0;
    private Context mContext;
    private Intent mIntent;
    private int mOrientation;
    private int mIntentType = 0;
    private QuickAction.OnActionItemClickListener mOnActionItemClick;
    private String[] mType = new String[]{"Activity", "Service"};

    public QuickIntentAction(Context context) {
        this(context, 1);
    }

    public QuickIntentAction(Context context, int orientation) {
        this.mContext = context;
        this.mOrientation = orientation;
    }

    public QuickIntentAction setServiceIntent(Intent services) {
        this.mIntent = services;
        this.mIntentType = 1;
        return this;
    }

    public QuickIntentAction setActivityIntent(Intent activity) {
        this.mIntent = activity;
        this.mIntentType = 0;
        return this;
    }

    public QuickIntentAction serOnActionItemClickListener(QuickAction.OnActionItemClickListener onClick) {
        this.mOnActionItemClick = onClick;
        return this;
    }

    public QuickAction create() {
        if (this.mIntent == null) {
            throw new IllegalStateException("Must set intent be for create(), Use setActivityIntent() or setServiceIntent()");
        }
        QuickAction quickAction = new QuickAction(this.mContext, this.mOrientation);
        if (this.mIntent != null) {
            List lists;
            PackageManager pm = this.mContext.getPackageManager();
            switch (this.mIntentType) {
                case 1: {
                    lists = pm.queryIntentServices(this.mIntent, 0);
                    break;
                }
                default: {
                    lists = pm.queryIntentActivities(this.mIntent, 0);
                }
            }
            if (lists.size() > 0) {
                int index = 0;
                for (ResolveInfo info : lists) {
                    ActionItem item = new ActionItem(index++, (String)info.loadLabel(pm));
                    item.setIconDrawable(info.loadIcon(pm));
                    quickAction.addActionItem(item);
                }
                this.addOnActionItemClick(quickAction, lists);
            } else {
                ActionItem item = new ActionItem(0, "Not found support any" + this.mType[this.mIntentType] + "!");
                quickAction.addActionItem(item);
            }
        }
        return quickAction;
    }

    private void addOnActionItemClick(QuickAction action, List<ResolveInfo> lists) {
        if (this.mOnActionItemClick != null) {
            action.setOnActionItemClickListener(this.mOnActionItemClick);
        } else {
            this.setDefaultOnActionItemClick(action, lists);
        }
    }

    private void setDefaultOnActionItemClick(QuickAction action, final List<ResolveInfo> lists) {
        switch (this.mIntentType) {
            case 1: {
                action.setOnActionItemClickListener(new QuickAction.OnActionItemClickListener(){

                    @Override
                    public void onItemClick(ActionItem item) {
                        ResolveInfo info = (ResolveInfo)lists.get(item.getActionId());
                        String name = info.serviceInfo.name;
                        String packageName = info.serviceInfo.packageName;
                        Intent service = new Intent(QuickIntentAction.this.mIntent);
                        service.setComponent(new ComponentName(packageName, name));
                        QuickIntentAction.this.mContext.startService(service);
                    }
                });
                break;
            }
            default: {
                action.setOnActionItemClickListener(new QuickAction.OnActionItemClickListener(){

                    @Override
                    public void onItemClick(ActionItem item) {
                        ResolveInfo info = (ResolveInfo)lists.get(item.getActionId());
                        String name = info.activityInfo.name;
                        String packageName = info.activityInfo.packageName;
                        Intent intent = new Intent(QuickIntentAction.this.mIntent);
                        intent.setComponent(new ComponentName(packageName, name));
                        QuickIntentAction.this.mContext.startActivity(intent);
                    }
                });
            }
        }
    }
}

